// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.face_detection.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageReq;
import com.lark.oapi.service.face_detection.v1.model.DetectFaceAttributesImageResp;

public class FaceDetectionService {

  private final Image image; // 图片

  public FaceDetectionService(Config config) {
    this.image = new Image(config);
  }

  /**
   * 图片
   *
   * @return
   */
  public Image image() {
    return image;
  }

  public static class Image {

    private final Config config;

    public Image(Config config) {
      this.config = config;
    }

    /**
     * 人脸检测和属性分析，检测图片中的人脸属性和质量等信息
     * <p> 注意：返回值为 -1 表示该功能还暂未实现 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/ai/face_detection-v1/image/detect_face_attributes">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/ai/face_detection-v1/image/detect_face_attributes</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/face_detectionv1/DetectFaceAttributesImageSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/face_detectionv1/DetectFaceAttributesImageSample.java</a>
     * ;
     */
    public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/face_detection/v1/image/detect_face_attributes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DetectFaceAttributesImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DetectFaceAttributesImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 人脸检测和属性分析，检测图片中的人脸属性和质量等信息
     * <p> 注意：返回值为 -1 表示该功能还暂未实现 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/ai/face_detection-v1/image/detect_face_attributes">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/ai/face_detection-v1/image/detect_face_attributes</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/face_detectionv1/DetectFaceAttributesImageSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/face_detectionv1/DetectFaceAttributesImageSample.java</a>
     * ;
     */
    public DetectFaceAttributesImageResp detectFaceAttributes(DetectFaceAttributesImageReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/face_detection/v1/image/detect_face_attributes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DetectFaceAttributesImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DetectFaceAttributesImageResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}