// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.hire.v1.model.CreateApplicationReq;
import com.lark.oapi.service.hire.v1.model.CreateApplicationResp;
import com.lark.oapi.service.hire.v1.model.CreateNoteReq;
import com.lark.oapi.service.hire.v1.model.CreateNoteResp;
import com.lark.oapi.service.hire.v1.model.GetApplicationReq;
import com.lark.oapi.service.hire.v1.model.GetApplicationResp;
import com.lark.oapi.service.hire.v1.model.GetAttachmentReq;
import com.lark.oapi.service.hire.v1.model.GetAttachmentResp;
import com.lark.oapi.service.hire.v1.model.GetByApplicationEmployeeReq;
import com.lark.oapi.service.hire.v1.model.GetByApplicationEmployeeResp;
import com.lark.oapi.service.hire.v1.model.GetByApplicationReferralReq;
import com.lark.oapi.service.hire.v1.model.GetByApplicationReferralResp;
import com.lark.oapi.service.hire.v1.model.GetEmployeeReq;
import com.lark.oapi.service.hire.v1.model.GetEmployeeResp;
import com.lark.oapi.service.hire.v1.model.GetJobManagerReq;
import com.lark.oapi.service.hire.v1.model.GetJobManagerResp;
import com.lark.oapi.service.hire.v1.model.GetJobReq;
import com.lark.oapi.service.hire.v1.model.GetJobResp;
import com.lark.oapi.service.hire.v1.model.GetNoteReq;
import com.lark.oapi.service.hire.v1.model.GetNoteResp;
import com.lark.oapi.service.hire.v1.model.GetOfferSchemaReq;
import com.lark.oapi.service.hire.v1.model.GetOfferSchemaResp;
import com.lark.oapi.service.hire.v1.model.GetTalentReq;
import com.lark.oapi.service.hire.v1.model.GetTalentResp;
import com.lark.oapi.service.hire.v1.model.ListApplicationInterviewReq;
import com.lark.oapi.service.hire.v1.model.ListApplicationInterviewResp;
import com.lark.oapi.service.hire.v1.model.ListApplicationReq;
import com.lark.oapi.service.hire.v1.model.ListApplicationResp;
import com.lark.oapi.service.hire.v1.model.ListJobProcessReq;
import com.lark.oapi.service.hire.v1.model.ListJobProcessResp;
import com.lark.oapi.service.hire.v1.model.ListNoteReq;
import com.lark.oapi.service.hire.v1.model.ListNoteResp;
import com.lark.oapi.service.hire.v1.model.ListResumeSourceReq;
import com.lark.oapi.service.hire.v1.model.ListResumeSourceResp;
import com.lark.oapi.service.hire.v1.model.OfferApplicationReq;
import com.lark.oapi.service.hire.v1.model.OfferApplicationResp;
import com.lark.oapi.service.hire.v1.model.PatchEmployeeReq;
import com.lark.oapi.service.hire.v1.model.PatchEmployeeResp;
import com.lark.oapi.service.hire.v1.model.PatchNoteReq;
import com.lark.oapi.service.hire.v1.model.PatchNoteResp;
import com.lark.oapi.service.hire.v1.model.PreviewAttachmentReq;
import com.lark.oapi.service.hire.v1.model.PreviewAttachmentResp;
import com.lark.oapi.service.hire.v1.model.TerminateApplicationReq;
import com.lark.oapi.service.hire.v1.model.TerminateApplicationResp;
import com.lark.oapi.service.hire.v1.model.TransferOnboardApplicationReq;
import com.lark.oapi.service.hire.v1.model.TransferOnboardApplicationResp;

public class HireService {

  private final Application application; // 投递
  private final ApplicationInterview applicationInterview; // 面试
  private final Attachment attachment; // 附件
  private final Employee employee; // 入职
  private final Job job; // 职位
  private final JobManager jobManager; // job.manager
  private final JobProcess jobProcess; // 流程
  private final Note note; // 备注
  private final OfferSchema offerSchema; // offer
  private final Referral referral; // 内推
  private final ResumeSource resumeSource; // 简历来源
  private final Talent talent; // 人才

  public HireService(Config config) {
    this.application = new Application(config);
    this.applicationInterview = new ApplicationInterview(config);
    this.attachment = new Attachment(config);
    this.employee = new Employee(config);
    this.job = new Job(config);
    this.jobManager = new JobManager(config);
    this.jobProcess = new JobProcess(config);
    this.note = new Note(config);
    this.offerSchema = new OfferSchema(config);
    this.referral = new Referral(config);
    this.resumeSource = new ResumeSource(config);
    this.talent = new Talent(config);
  }

  /**
   * 投递
   *
   * @return
   */
  public Application application() {
    return application;
  }

  /**
   * 面试
   *
   * @return
   */
  public ApplicationInterview applicationInterview() {
    return applicationInterview;
  }

  /**
   * 附件
   *
   * @return
   */
  public Attachment attachment() {
    return attachment;
  }

  /**
   * 入职
   *
   * @return
   */
  public Employee employee() {
    return employee;
  }

  /**
   * 职位
   *
   * @return
   */
  public Job job() {
    return job;
  }

  /**
   * job.manager
   *
   * @return
   */
  public JobManager jobManager() {
    return jobManager;
  }

  /**
   * 流程
   *
   * @return
   */
  public JobProcess jobProcess() {
    return jobProcess;
  }

  /**
   * 备注
   *
   * @return
   */
  public Note note() {
    return note;
  }

  /**
   * offer
   *
   * @return
   */
  public OfferSchema offerSchema() {
    return offerSchema;
  }

  /**
   * 内推
   *
   * @return
   */
  public Referral referral() {
    return referral;
  }

  /**
   * 简历来源
   *
   * @return
   */
  public ResumeSource resumeSource() {
    return resumeSource;
  }

  /**
   * 人才
   *
   * @return
   */
  public Talent talent() {
    return talent;
  }

  public static class Application {

    private final Config config;

    public Application(Config config) {
      this.config = config;
    }

    /**
     * 创建投递，根据人才 ID 和职位 ID 创建投递
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/create_application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/create_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateApplicationSample.java</a>
     * ;
     */
    public CreateApplicationResp create(CreateApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建投递，根据人才 ID 和职位 ID 创建投递
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/create_application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/create_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateApplicationSample.java</a>
     * ;
     */
    public CreateApplicationResp create(CreateApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取投递信息，根据投递 ID 获取单个投递信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetApplicationSample.java</a>
     * ;
     */
    public GetApplicationResp get(GetApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取投递信息，根据投递 ID 获取单个投递信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetApplicationSample.java</a>
     * ;
     */
    public GetApplicationResp get(GetApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取投递列表，根据限定条件获取投递列表信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-list">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationSample.java</a>
     * ;
     */
    public ListApplicationResp list(ListApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取投递列表，根据限定条件获取投递列表信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-list">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationSample.java</a>
     * ;
     */
    public ListApplicationResp list(ListApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取 Offer 信息，根据投递 ID 获取 Offer 信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-offer">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-offer</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/OfferApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/OfferApplicationSample.java</a>
     * ;
     */
    public OfferApplicationResp offer(OfferApplicationReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id/offer"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      OfferApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          OfferApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取 Offer 信息，根据投递 ID 获取 Offer 信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-offer">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/get-application-offer</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/OfferApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/OfferApplicationSample.java</a>
     * ;
     */
    public OfferApplicationResp offer(OfferApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id/offer"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      OfferApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          OfferApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 终止投递，根据投递 ID 修改投递状态为「已终止」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/terminate-application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/terminate-application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TerminateApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TerminateApplicationSample.java</a>
     * ;
     */
    public TerminateApplicationResp terminate(TerminateApplicationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications/:application_id/terminate"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TerminateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TerminateApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 终止投递，根据投递 ID 修改投递状态为「已终止」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/terminate-application">https://open.feishu.cn/document/ukTMukTMukTM/uQzM1YjL0MTN24CNzUjN/terminate-application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TerminateApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TerminateApplicationSample.java</a>
     * ;
     */
    public TerminateApplicationResp terminate(TerminateApplicationReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications/:application_id/terminate"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TerminateApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TerminateApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 操作候选人入职，根据投递 ID 操作候选人入职并创建员工。投递须处于「待入职」阶段，可通过「转移阶段」接口变更投递状态
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uczM1YjL3MTN24yNzUjN">https://open.feishu.cn/document/ukTMukTMukTM/uczM1YjL3MTN24yNzUjN</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TransferOnboardApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TransferOnboardApplicationSample.java</a>
     * ;
     */
    public TransferOnboardApplicationResp transferOnboard(TransferOnboardApplicationReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications/:application_id/transfer_onboard"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TransferOnboardApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TransferOnboardApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 操作候选人入职，根据投递 ID 操作候选人入职并创建员工。投递须处于「待入职」阶段，可通过「转移阶段」接口变更投递状态
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uczM1YjL3MTN24yNzUjN">https://open.feishu.cn/document/ukTMukTMukTM/uczM1YjL3MTN24yNzUjN</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TransferOnboardApplicationSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/TransferOnboardApplicationSample.java</a>
     * ;
     */
    public TransferOnboardApplicationResp transferOnboard(TransferOnboardApplicationReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/applications/:application_id/transfer_onboard"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      TransferOnboardApplicationResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          TransferOnboardApplicationResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ApplicationInterview {

    private final Config config;

    public ApplicationInterview(Config config) {
      this.config = config;
    }

    /**
     * 获取面试记录列表，根据投递 ID 获取面试记录列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/application-interview/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/application-interview/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationInterviewSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationInterviewSample.java</a>
     * ;
     */
    public ListApplicationInterviewResp list(ListApplicationInterviewReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id/interviews"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationInterviewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationInterviewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取面试记录列表，根据投递 ID 获取面试记录列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/application-interview/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/application-interview/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationInterviewSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListApplicationInterviewSample.java</a>
     * ;
     */
    public ListApplicationInterviewResp list(ListApplicationInterviewReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/applications/:application_id/interviews"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListApplicationInterviewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListApplicationInterviewResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Attachment {

    private final Config config;

    public Attachment(Config config) {
      this.config = config;
    }

    /**
     * 获取附件信息，获取招聘系统中附件的元信息，比如文件名、创建时间、文件url等
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetAttachmentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetAttachmentSample.java</a>
     * ;
     */
    public GetAttachmentResp get(GetAttachmentReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/attachments/:attachment_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAttachmentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取附件信息，获取招聘系统中附件的元信息，比如文件名、创建时间、文件url等
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetAttachmentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetAttachmentSample.java</a>
     * ;
     */
    public GetAttachmentResp get(GetAttachmentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/attachments/:attachment_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetAttachmentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取附件预览信息，根据附件 ID 获取附件预览信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/preview">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/preview</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PreviewAttachmentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PreviewAttachmentSample.java</a>
     * ;
     */
    public PreviewAttachmentResp preview(PreviewAttachmentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/attachments/:attachment_id/preview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PreviewAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewAttachmentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取附件预览信息，根据附件 ID 获取附件预览信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/preview">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/attachment/preview</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PreviewAttachmentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PreviewAttachmentSample.java</a>
     * ;
     */
    public PreviewAttachmentResp preview(PreviewAttachmentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/attachments/:attachment_id/preview"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PreviewAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PreviewAttachmentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Employee {

    private final Config config;

    public Employee(Config config) {
      this.config = config;
    }

    /**
     * 通过员工 ID 获取入职信息，通过员工 ID 获取入职信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetEmployeeSample.java</a>
     * ;
     */
    public GetEmployeeResp get(GetEmployeeReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/employees/:employee_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 通过员工 ID 获取入职信息，通过员工 ID 获取入职信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetEmployeeSample.java</a>
     * ;
     */
    public GetEmployeeResp get(GetEmployeeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/employees/:employee_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 通过投递 ID 获取入职信息，通过投递 ID 获取入职信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get_by_application">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get_by_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationEmployeeSample.java</a>
     * ;
     */
    public GetByApplicationEmployeeResp getByApplication(GetByApplicationEmployeeReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/employees/get_by_application"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetByApplicationEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetByApplicationEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 通过投递 ID 获取入职信息，通过投递 ID 获取入职信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get_by_application">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/get_by_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationEmployeeSample.java</a>
     * ;
     */
    public GetByApplicationEmployeeResp getByApplication(GetByApplicationEmployeeReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/employees/get_by_application"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetByApplicationEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetByApplicationEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新入职状态，根据员工 ID 更新员工转正、离职状态
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/patch">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchEmployeeSample.java</a>
     * ;
     */
    public PatchEmployeeResp patch(PatchEmployeeReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/hire/v1/employees/:employee_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新入职状态，根据员工 ID 更新员工转正、离职状态
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/patch">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/employee/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchEmployeeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchEmployeeSample.java</a>
     * ;
     */
    public PatchEmployeeResp patch(PatchEmployeeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/hire/v1/employees/:employee_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchEmployeeResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Job {

    private final Config config;

    public Job(Config config) {
      this.config = config;
    }

    /**
     * 获取职位信息，根据职位 ID 获取职位信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/job/get-job">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/job/get-job</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobSample.java</a>
     * ;
     */
    public GetJobResp get(GetJobReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/jobs/:job_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetJobResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取职位信息，根据职位 ID 获取职位信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/job/get-job">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/job/get-job</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobSample.java</a>
     * ;
     */
    public GetJobResp get(GetJobReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/jobs/:job_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetJobResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetJobResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class JobManager {

    private final Config config;

    public JobManager(Config config) {
      this.config = config;
    }

    /**
     * 获取职位上的招聘人员信息，根据职位 ID 获取职位上的招聘人员信息，如招聘负责人、用人经理
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/job-manager/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/job-manager/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobManagerSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobManagerSample.java</a>
     * ;
     */
    public GetJobManagerResp get(GetJobManagerReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetJobManagerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetJobManagerResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取职位上的招聘人员信息，根据职位 ID 获取职位上的招聘人员信息，如招聘负责人、用人经理
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/job-manager/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/job-manager/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobManagerSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetJobManagerSample.java</a>
     * ;
     */
    public GetJobManagerResp get(GetJobManagerReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetJobManagerResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetJobManagerResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class JobProcess {

    private final Config config;

    public JobProcess(Config config) {
      this.config = config;
    }

    /**
     * 获取招聘流程信息，获取全部招聘流程信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/jop-process/get-process">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/jop-process/get-process</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListJobProcessSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListJobProcessSample.java</a>
     * ;
     */
    public ListJobProcessResp list(ListJobProcessReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/job_processes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListJobProcessResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListJobProcessResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取招聘流程信息，获取全部招聘流程信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/jop-process/get-process">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/jop-process/get-process</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListJobProcessSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListJobProcessSample.java</a>
     * ;
     */
    public ListJobProcessResp list(ListJobProcessReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/job_processes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListJobProcessResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListJobProcessResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Note {

    private final Config config;

    public Note(Config config) {
      this.config = config;
    }

    /**
     * 创建备注，创建备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/create">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateNoteSample.java</a>
     * ;
     */
    public CreateNoteResp create(CreateNoteReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/notes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建备注，创建备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/create">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/CreateNoteSample.java</a>
     * ;
     */
    public CreateNoteResp create(CreateNoteReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/hire/v1/notes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取备注，根据备注 ID 获取备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetNoteSample.java</a>
     * ;
     */
    public GetNoteResp get(GetNoteReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/notes/:note_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取备注，根据备注 ID 获取备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetNoteSample.java</a>
     * ;
     */
    public GetNoteResp get(GetNoteReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/notes/:note_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取备注列表，获取备注列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListNoteSample.java</a>
     * ;
     */
    public ListNoteResp list(ListNoteReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/notes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取备注列表，获取备注列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListNoteSample.java</a>
     * ;
     */
    public ListNoteResp list(ListNoteReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/notes"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新备注，根据备注 ID 更新备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/patch">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchNoteSample.java</a>
     * ;
     */
    public PatchNoteResp patch(PatchNoteReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/hire/v1/notes/:note_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新备注，根据备注 ID 更新备注信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/patch">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/note/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchNoteSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/PatchNoteSample.java</a>
     * ;
     */
    public PatchNoteResp patch(PatchNoteReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/hire/v1/notes/:note_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      PatchNoteResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchNoteResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class OfferSchema {

    private final Config config;

    public OfferSchema(Config config) {
      this.config = config;
    }

    /**
     * 获取 Offer 申请表详细信息，根据 Offer 申请表 ID，获取 Offer 申请表的详细信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/offer_schema/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/offer_schema/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetOfferSchemaSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetOfferSchemaSample.java</a>
     * ;
     */
    public GetOfferSchemaResp get(GetOfferSchemaReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/offer_schemas/:offer_schema_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetOfferSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetOfferSchemaResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取 Offer 申请表详细信息，根据 Offer 申请表 ID，获取 Offer 申请表的详细信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/offer_schema/get">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/offer_schema/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetOfferSchemaSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetOfferSchemaSample.java</a>
     * ;
     */
    public GetOfferSchemaResp get(GetOfferSchemaReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/offer_schemas/:offer_schema_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetOfferSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetOfferSchemaResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Referral {

    private final Config config;

    public Referral(Config config) {
      this.config = config;
    }

    /**
     * 获取内推信息，根据投递 ID 获取内推信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/referral/get_by_application">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/referral/get_by_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationReferralSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationReferralSample.java</a>
     * ;
     */
    public GetByApplicationReferralResp getByApplication(GetByApplicationReferralReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/referrals/get_by_application"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetByApplicationReferralResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetByApplicationReferralResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取内推信息，根据投递 ID 获取内推信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/referral/get_by_application">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/referral/get_by_application</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationReferralSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetByApplicationReferralSample.java</a>
     * ;
     */
    public GetByApplicationReferralResp getByApplication(GetByApplicationReferralReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/referrals/get_by_application"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetByApplicationReferralResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetByApplicationReferralResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ResumeSource {

    private final Config config;

    public ResumeSource(Config config) {
      this.config = config;
    }

    /**
     * 获取简历来源列表，获取简历来源列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/resume_source/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/resume_source/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListResumeSourceSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListResumeSourceSample.java</a>
     * ;
     */
    public ListResumeSourceResp list(ListResumeSourceReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/resume_sources"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListResumeSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListResumeSourceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取简历来源列表，获取简历来源列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/resume_source/list">https://open.feishu.cn/document/ukTMukTMukTM/uMzM1YjLzMTN24yMzUjN/hire-v1/resume_source/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListResumeSourceSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/ListResumeSourceSample.java</a>
     * ;
     */
    public ListResumeSourceResp list(ListResumeSourceReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/resume_sources"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListResumeSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListResumeSourceResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Talent {

    private final Config config;

    public Talent(Config config) {
      this.config = config;
    }

    /**
     * 获取人才信息，根据人才 ID 获取人才信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUzM1YjL1MTN24SNzUjN/get-talent">https://open.feishu.cn/document/ukTMukTMukTM/uUzM1YjL1MTN24SNzUjN/get-talent</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetTalentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetTalentSample.java</a>
     * ;
     */
    public GetTalentResp get(GetTalentReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/talents/:talent_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTalentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTalentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取人才信息，根据人才 ID 获取人才信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUzM1YjL1MTN24SNzUjN/get-talent">https://open.feishu.cn/document/ukTMukTMukTM/uUzM1YjL1MTN24SNzUjN/get-talent</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetTalentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/hirev1/GetTalentSample.java</a>
     * ;
     */
    public GetTalentResp get(GetTalentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/hire/v1/talents/:talent_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTalentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTalentResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}