// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.google.gson.annotations.SerializedName;

public class ExternalBackgroundCheck {

  /**
   * 外部背调 ID
   * <p> 示例值：6989202908470446380
   */
  @SerializedName("id")
  private String id;
  /**
   * 外部系统背调主键 （仅用于幂等）
   * <p> 示例值：123
   */
  @SerializedName("external_id")
  private String externalId;
  /**
   * 外部投递 ID
   * <p> 示例值：1234111
   */
  @SerializedName("external_application_id")
  private String externalApplicationId;
  /**
   * 背调日期
   * <p> 示例值：1626602069393
   */
  @SerializedName("date")
  private Integer date;
  /**
   * 背调名字
   * <p> 示例值：测试.pdf
   */
  @SerializedName("name")
  private String name;
  /**
   * 背调结果
   * <p> 示例值：1
   */
  @SerializedName("result")
  private String result;
  /**
   * 背调附件ID列表
   * <p> 示例值：6989181065243969836
   */
  @SerializedName("attachment_id_list")
  private String[] attachmentIdList;
  /**
   * 背调附件
   * <p> 示例值：
   */
  @SerializedName("attachment_list")
  private ExternalBackgroundCheckAttachment[] attachmentList;

  // builder 开始
  public ExternalBackgroundCheck() {
  }

  public ExternalBackgroundCheck(Builder builder) {
    /**
     * 外部背调 ID
     * <p> 示例值：6989202908470446380
     */
    this.id = builder.id;
    /**
     * 外部系统背调主键 （仅用于幂等）
     * <p> 示例值：123
     */
    this.externalId = builder.externalId;
    /**
     * 外部投递 ID
     * <p> 示例值：1234111
     */
    this.externalApplicationId = builder.externalApplicationId;
    /**
     * 背调日期
     * <p> 示例值：1626602069393
     */
    this.date = builder.date;
    /**
     * 背调名字
     * <p> 示例值：测试.pdf
     */
    this.name = builder.name;
    /**
     * 背调结果
     * <p> 示例值：1
     */
    this.result = builder.result;
    /**
     * 背调附件ID列表
     * <p> 示例值：6989181065243969836
     */
    this.attachmentIdList = builder.attachmentIdList;
    /**
     * 背调附件
     * <p> 示例值：
     */
    this.attachmentList = builder.attachmentList;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getId() {
    return this.id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getExternalId() {
    return this.externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public String getExternalApplicationId() {
    return this.externalApplicationId;
  }

  public void setExternalApplicationId(String externalApplicationId) {
    this.externalApplicationId = externalApplicationId;
  }

  public Integer getDate() {
    return this.date;
  }

  public void setDate(Integer date) {
    this.date = date;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getResult() {
    return this.result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public String[] getAttachmentIdList() {
    return this.attachmentIdList;
  }

  public void setAttachmentIdList(String[] attachmentIdList) {
    this.attachmentIdList = attachmentIdList;
  }

  public ExternalBackgroundCheckAttachment[] getAttachmentList() {
    return this.attachmentList;
  }

  public void setAttachmentList(ExternalBackgroundCheckAttachment[] attachmentList) {
    this.attachmentList = attachmentList;
  }

  public static class Builder {

    /**
     * 外部背调 ID
     * <p> 示例值：6989202908470446380
     */
    private String id;
    /**
     * 外部系统背调主键 （仅用于幂等）
     * <p> 示例值：123
     */
    private String externalId;
    /**
     * 外部投递 ID
     * <p> 示例值：1234111
     */
    private String externalApplicationId;
    /**
     * 背调日期
     * <p> 示例值：1626602069393
     */
    private Integer date;
    /**
     * 背调名字
     * <p> 示例值：测试.pdf
     */
    private String name;
    /**
     * 背调结果
     * <p> 示例值：1
     */
    private String result;
    /**
     * 背调附件ID列表
     * <p> 示例值：6989181065243969836
     */
    private String[] attachmentIdList;
    /**
     * 背调附件
     * <p> 示例值：
     */
    private ExternalBackgroundCheckAttachment[] attachmentList;

    /**
     * 外部背调 ID
     * <p> 示例值：6989202908470446380
     *
     * @param id
     * @return
     */
    public Builder id(String id) {
      this.id = id;
      return this;
    }


    /**
     * 外部系统背调主键 （仅用于幂等）
     * <p> 示例值：123
     *
     * @param externalId
     * @return
     */
    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }


    /**
     * 外部投递 ID
     * <p> 示例值：1234111
     *
     * @param externalApplicationId
     * @return
     */
    public Builder externalApplicationId(String externalApplicationId) {
      this.externalApplicationId = externalApplicationId;
      return this;
    }


    /**
     * 背调日期
     * <p> 示例值：1626602069393
     *
     * @param date
     * @return
     */
    public Builder date(Integer date) {
      this.date = date;
      return this;
    }


    /**
     * 背调名字
     * <p> 示例值：测试.pdf
     *
     * @param name
     * @return
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }


    /**
     * 背调结果
     * <p> 示例值：1
     *
     * @param result
     * @return
     */
    public Builder result(String result) {
      this.result = result;
      return this;
    }


    /**
     * 背调附件ID列表
     * <p> 示例值：6989181065243969836
     *
     * @param attachmentIdList
     * @return
     */
    public Builder attachmentIdList(String[] attachmentIdList) {
      this.attachmentIdList = attachmentIdList;
      return this;
    }


    /**
     * 背调附件
     * <p> 示例值：
     *
     * @param attachmentList
     * @return
     */
    public Builder attachmentList(ExternalBackgroundCheckAttachment[] attachmentList) {
      this.attachmentList = attachmentList;
      return this;
    }


    public ExternalBackgroundCheck build() {
      return new ExternalBackgroundCheck(this);
    }
  }
}
