// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.google.gson.annotations.SerializedName;

public class SiteJobPostSearchRequest {

  /**
   * 搜索关键字
   * <p> 示例值：
   */
  @SerializedName("keyword")
  private String keyword;
  /**
   * 分页用的偏移量，默认0
   * <p> 示例值：
   */
  @SerializedName("offset")
  private Integer offset;
  /**
   * 分页用的分页条数，最大100
   * <p> 示例值：
   */
  @SerializedName("limit")
  private Integer limit;
  /**
   * 职能列表返回的id
   * <p> 示例值：
   */
  @SerializedName("job_type_id_list")
  private String[] jobTypeIdList;
  /**
   * 地址列表返回的code
   * <p> 示例值：
   */
  @SerializedName("city_code_list")
  private String[] cityCodeList;
  /**
   * 官网id，不传则查询默认官网
   * <p> 示例值：
   */
  @SerializedName("site_id")
  private String siteId;

  // builder 开始
  public SiteJobPostSearchRequest() {
  }

  public SiteJobPostSearchRequest(Builder builder) {
    /**
     * 搜索关键字
     * <p> 示例值：
     */
    this.keyword = builder.keyword;
    /**
     * 分页用的偏移量，默认0
     * <p> 示例值：
     */
    this.offset = builder.offset;
    /**
     * 分页用的分页条数，最大100
     * <p> 示例值：
     */
    this.limit = builder.limit;
    /**
     * 职能列表返回的id
     * <p> 示例值：
     */
    this.jobTypeIdList = builder.jobTypeIdList;
    /**
     * 地址列表返回的code
     * <p> 示例值：
     */
    this.cityCodeList = builder.cityCodeList;
    /**
     * 官网id，不传则查询默认官网
     * <p> 示例值：
     */
    this.siteId = builder.siteId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getKeyword() {
    return this.keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public Integer getOffset() {
    return this.offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public Integer getLimit() {
    return this.limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public String[] getJobTypeIdList() {
    return this.jobTypeIdList;
  }

  public void setJobTypeIdList(String[] jobTypeIdList) {
    this.jobTypeIdList = jobTypeIdList;
  }

  public String[] getCityCodeList() {
    return this.cityCodeList;
  }

  public void setCityCodeList(String[] cityCodeList) {
    this.cityCodeList = cityCodeList;
  }

  public String getSiteId() {
    return this.siteId;
  }

  public void setSiteId(String siteId) {
    this.siteId = siteId;
  }

  public static class Builder {

    /**
     * 搜索关键字
     * <p> 示例值：
     */
    private String keyword;
    /**
     * 分页用的偏移量，默认0
     * <p> 示例值：
     */
    private Integer offset;
    /**
     * 分页用的分页条数，最大100
     * <p> 示例值：
     */
    private Integer limit;
    /**
     * 职能列表返回的id
     * <p> 示例值：
     */
    private String[] jobTypeIdList;
    /**
     * 地址列表返回的code
     * <p> 示例值：
     */
    private String[] cityCodeList;
    /**
     * 官网id，不传则查询默认官网
     * <p> 示例值：
     */
    private String siteId;

    /**
     * 搜索关键字
     * <p> 示例值：
     *
     * @param keyword
     * @return
     */
    public Builder keyword(String keyword) {
      this.keyword = keyword;
      return this;
    }


    /**
     * 分页用的偏移量，默认0
     * <p> 示例值：
     *
     * @param offset
     * @return
     */
    public Builder offset(Integer offset) {
      this.offset = offset;
      return this;
    }


    /**
     * 分页用的分页条数，最大100
     * <p> 示例值：
     *
     * @param limit
     * @return
     */
    public Builder limit(Integer limit) {
      this.limit = limit;
      return this;
    }


    /**
     * 职能列表返回的id
     * <p> 示例值：
     *
     * @param jobTypeIdList
     * @return
     */
    public Builder jobTypeIdList(String[] jobTypeIdList) {
      this.jobTypeIdList = jobTypeIdList;
      return this;
    }


    /**
     * 地址列表返回的code
     * <p> 示例值：
     *
     * @param cityCodeList
     * @return
     */
    public Builder cityCodeList(String[] cityCodeList) {
      this.cityCodeList = cityCodeList;
      return this;
    }


    /**
     * 官网id，不传则查询默认官网
     * <p> 示例值：
     *
     * @param siteId
     * @return
     */
    public Builder siteId(String siteId) {
      this.siteId = siteId;
      return this;
    }


    public SiteJobPostSearchRequest build() {
      return new SiteJobPostSearchRequest(this);
    }
  }
}
