// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;

import com.google.gson.annotations.SerializedName;

public class ChatMemberUser {

  /**
   * 用户名字
   * <p> 示例值：user name
   */
  @SerializedName("name")
  private String name;
  /**
   * 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
   * <p> 示例值：3774yuu3743
   */
  @SerializedName("tenant_key")
  private String tenantKey;
  /**
   * 用户 ID
   * <p> 示例值：
   */
  @SerializedName("user_id")
  private UserId userId;

  // builder 开始
  public ChatMemberUser() {
  }

  public ChatMemberUser(Builder builder) {
    /**
     * 用户名字
     * <p> 示例值：user name
     */
    this.name = builder.name;
    /**
     * 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
     * <p> 示例值：3774yuu3743
     */
    this.tenantKey = builder.tenantKey;
    /**
     * 用户 ID
     * <p> 示例值：
     */
    this.userId = builder.userId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getTenantKey() {
    return this.tenantKey;
  }

  public void setTenantKey(String tenantKey) {
    this.tenantKey = tenantKey;
  }

  public UserId getUserId() {
    return this.userId;
  }

  public void setUserId(UserId userId) {
    this.userId = userId;
  }

  public static class Builder {

    /**
     * 用户名字
     * <p> 示例值：user name
     */
    private String name;
    /**
     * 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
     * <p> 示例值：3774yuu3743
     */
    private String tenantKey;
    /**
     * 用户 ID
     * <p> 示例值：
     */
    private UserId userId;

    /**
     * 用户名字
     * <p> 示例值：user name
     *
     * @param name
     * @return
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }


    /**
     * 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
     * <p> 示例值：3774yuu3743
     *
     * @param tenantKey
     * @return
     */
    public Builder tenantKey(String tenantKey) {
      this.tenantKey = tenantKey;
      return this;
    }


    /**
     * 用户 ID
     * <p> 示例值：
     *
     * @param userId
     * @return
     */
    public Builder userId(UserId userId) {
      this.userId = userId;
      return this;
    }


    public ChatMemberUser build() {
      return new ChatMemberUser(this);
    }
  }
}
