// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.meeting_room.v1;


import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.meeting_room.v1.model.P1ThirdPartyMeetingRoomChangedV1;
import com.lark.oapi.service.meeting_room.v1.model.P2MeetingRoomCreatedV1;
import com.lark.oapi.service.meeting_room.v1.model.P2MeetingRoomDeletedV1;
import com.lark.oapi.service.meeting_room.v1.model.P2MeetingRoomStatusChangedV1;
import com.lark.oapi.service.meeting_room.v1.model.P2MeetingRoomUpdatedV1;

public class MeetingRoomService {

  private final MeetingRoom meetingRoom; // 事件

  public MeetingRoomService(Config config) {
    this.meetingRoom = new MeetingRoom(config);
  }

  /**
   * 事件
   *
   * @return
   */
  public MeetingRoom meetingRoom() {
    return meetingRoom;
  }

  public static class MeetingRoom {

    private final Config config;

    public MeetingRoom(Config config) {
      this.config = config;
    }
  }

  public abstract static class P2MeetingRoomCreatedV1Handler implements
      IEventHandler<P2MeetingRoomCreatedV1> {

    @Override
    public P2MeetingRoomCreatedV1 getEvent() {
      return new P2MeetingRoomCreatedV1();
    }
  }

  public abstract static class P2MeetingRoomDeletedV1Handler implements
      IEventHandler<P2MeetingRoomDeletedV1> {

    @Override
    public P2MeetingRoomDeletedV1 getEvent() {
      return new P2MeetingRoomDeletedV1();
    }
  }

  public abstract static class P2MeetingRoomStatusChangedV1Handler implements
      IEventHandler<P2MeetingRoomStatusChangedV1> {

    @Override
    public P2MeetingRoomStatusChangedV1 getEvent() {
      return new P2MeetingRoomStatusChangedV1();
    }
  }

  public abstract static class P2MeetingRoomUpdatedV1Handler implements
      IEventHandler<P2MeetingRoomUpdatedV1> {

    @Override
    public P2MeetingRoomUpdatedV1 getEvent() {
      return new P2MeetingRoomUpdatedV1();
    }
  }

  public abstract static class P1ThirdPartyMeetingRoomChangedV1Handler implements
      IEventHandler<P1ThirdPartyMeetingRoomChangedV1> {

    @Override
    public P1ThirdPartyMeetingRoomChangedV1 getEvent() {
      return new P1ThirdPartyMeetingRoomChangedV1();
    }
  }
}