// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class BatchGetOkrReq {

  /**
   * 此次调用中使用的用户ID的类型
   * <p> 示例值：
   */
  @Query
  @SerializedName("user_id_type")
  private String userIdType;
  /**
   * OKR ID 列表，最多10个
   * <p> 示例值：7043693679567028244
   */
  @Query
  @SerializedName("okr_ids")
  private String[] okrIds;
  /**
   * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn，请求 Query中
   * <p> 示例值：zh_cn
   */
  @Query
  @SerializedName("lang")
  private String lang;

  // builder 开始
  public BatchGetOkrReq() {
  }

  public BatchGetOkrReq(Builder builder) {
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    this.userIdType = builder.userIdType;
    /**
     * OKR ID 列表，最多10个
     * <p> 示例值：7043693679567028244
     */
    this.okrIds = builder.okrIds;
    /**
     * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn，请求 Query中
     * <p> 示例值：zh_cn
     */
    this.lang = builder.lang;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getUserIdType() {
    return this.userIdType;
  }

  public void setUserIdType(String userIdType) {
    this.userIdType = userIdType;
  }

  public String[] getOkrIds() {
    return this.okrIds;
  }

  public void setOkrIds(String[] okrIds) {
    this.okrIds = okrIds;
  }

  public String getLang() {
    return this.lang;
  }

  public void setLang(String lang) {
    this.lang = lang;
  }

  public static class Builder {

    private String userIdType; // 此次调用中使用的用户ID的类型
    private String[] okrIds; // OKR ID 列表，最多10个
    private String lang; // 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn，请求 Query中


    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     *
     * @param userIdType
     * @return
     */
    public Builder userIdType(String userIdType) {
      this.userIdType = userIdType;
      return this;
    }

    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     *
     * @param userIdType {@link com.lark.oapi.service.okr.v1.enums.BatchGetOkrUserIdTypeEnum}
     * @return
     */
    public Builder userIdType(
        com.lark.oapi.service.okr.v1.enums.BatchGetOkrUserIdTypeEnum userIdType) {
      this.userIdType = userIdType.getValue();
      return this;
    }


    /**
     * OKR ID 列表，最多10个
     * <p> 示例值：7043693679567028244
     *
     * @param okrIds
     * @return
     */
    public Builder okrIds(String[] okrIds) {
      this.okrIds = okrIds;
      return this;
    }


    /**
     * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn，请求 Query中
     * <p> 示例值：zh_cn
     *
     * @param lang
     * @return
     */
    public Builder lang(String lang) {
      this.lang = lang;
      return this;
    }

    public BatchGetOkrReq build() {
      return new BatchGetOkrReq(this);
    }
  }
}
