// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v1.model;

import com.google.gson.annotations.SerializedName;

public class Due {

  /**
   * 截止时间的时间戳（单位为秒）
   * <p> 示例值：1623124318
   */
  @SerializedName("time")
  private String time;
  /**
   * 截止时间对应的时区，使用IANA Time Zone Database标准，如Asia/Shanghai
   * <p> 示例值：Asia/Shanghai
   */
  @SerializedName("timezone")
  private String timezone;
  /**
   * 标记任务是否为全天任务（全天任务的截止时间为当天 UTC 时间的 0 点）
   * <p> 示例值：false
   */
  @SerializedName("is_all_day")
  private Boolean isAllDay;

  // builder 开始
  public Due() {
  }

  public Due(Builder builder) {
    /**
     * 截止时间的时间戳（单位为秒）
     * <p> 示例值：1623124318
     */
    this.time = builder.time;
    /**
     * 截止时间对应的时区，使用IANA Time Zone Database标准，如Asia/Shanghai
     * <p> 示例值：Asia/Shanghai
     */
    this.timezone = builder.timezone;
    /**
     * 标记任务是否为全天任务（全天任务的截止时间为当天 UTC 时间的 0 点）
     * <p> 示例值：false
     */
    this.isAllDay = builder.isAllDay;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getTime() {
    return this.time;
  }

  public void setTime(String time) {
    this.time = time;
  }

  public String getTimezone() {
    return this.timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  public Boolean getIsAllDay() {
    return this.isAllDay;
  }

  public void setIsAllDay(Boolean isAllDay) {
    this.isAllDay = isAllDay;
  }

  public static class Builder {

    /**
     * 截止时间的时间戳（单位为秒）
     * <p> 示例值：1623124318
     */
    private String time;
    /**
     * 截止时间对应的时区，使用IANA Time Zone Database标准，如Asia/Shanghai
     * <p> 示例值：Asia/Shanghai
     */
    private String timezone;
    /**
     * 标记任务是否为全天任务（全天任务的截止时间为当天 UTC 时间的 0 点）
     * <p> 示例值：false
     */
    private Boolean isAllDay;

    /**
     * 截止时间的时间戳（单位为秒）
     * <p> 示例值：1623124318
     *
     * @param time
     * @return
     */
    public Builder time(String time) {
      this.time = time;
      return this;
    }


    /**
     * 截止时间对应的时区，使用IANA Time Zone Database标准，如Asia/Shanghai
     * <p> 示例值：Asia/Shanghai
     *
     * @param timezone
     * @return
     */
    public Builder timezone(String timezone) {
      this.timezone = timezone;
      return this;
    }


    /**
     * 标记任务是否为全天任务（全天任务的截止时间为当天 UTC 时间的 0 点）
     * <p> 示例值：false
     *
     * @param isAllDay
     * @return
     */
    public Builder isAllDay(Boolean isAllDay) {
      this.isAllDay = isAllDay;
      return this;
    }


    public Due build() {
      return new Due(this);
    }
  }
}
