// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v1.model;

import com.google.gson.annotations.SerializedName;

public class PatchTaskReqBody {

  /**
   * 被更新的任务实体基础信息
   * <p> 示例值：
   */
  @SerializedName("task")
  private Task task;
  /**
   * 指定需要更新的任务字段，否则服务端将不知道更新哪些字段
   * <p> 示例值：["summary"]
   */
  @SerializedName("update_fields")
  private String[] updateFields;

  // builder 开始
  public PatchTaskReqBody() {
  }

  public PatchTaskReqBody(Builder builder) {
    /**
     * 被更新的任务实体基础信息
     * <p> 示例值：
     */
    this.task = builder.task;
    /**
     * 指定需要更新的任务字段，否则服务端将不知道更新哪些字段
     * <p> 示例值：["summary"]
     */
    this.updateFields = builder.updateFields;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Task getTask() {
    return this.task;
  }

  public void setTask(Task task) {
    this.task = task;
  }

  public String[] getUpdateFields() {
    return this.updateFields;
  }

  public void setUpdateFields(String[] updateFields) {
    this.updateFields = updateFields;
  }

  public static class Builder {

    /**
     * 被更新的任务实体基础信息
     * <p> 示例值：
     */
    private Task task;
    /**
     * 指定需要更新的任务字段，否则服务端将不知道更新哪些字段
     * <p> 示例值：["summary"]
     */
    private String[] updateFields;

    /**
     * 被更新的任务实体基础信息
     * <p> 示例值：
     *
     * @param task
     * @return
     */
    public Builder task(Task task) {
      this.task = task;
      return this;
    }


    /**
     * 指定需要更新的任务字段，否则服务端将不知道更新哪些字段
     * <p> 示例值：["summary"]
     *
     * @param updateFields
     * @return
     */
    public Builder updateFields(String[] updateFields) {
      this.updateFields = updateFields;
      return this;
    }


    public PatchTaskReqBody build() {
      return new PatchTaskReqBody(this);
    }
  }
}
