// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.vc.v1.model.ApplyReserveReq;
import com.lark.oapi.service.vc.v1.model.ApplyReserveResp;
import com.lark.oapi.service.vc.v1.model.DeleteReserveReq;
import com.lark.oapi.service.vc.v1.model.DeleteReserveResp;
import com.lark.oapi.service.vc.v1.model.DownloadExportReq;
import com.lark.oapi.service.vc.v1.model.DownloadExportResp;
import com.lark.oapi.service.vc.v1.model.EndMeetingReq;
import com.lark.oapi.service.vc.v1.model.EndMeetingResp;
import com.lark.oapi.service.vc.v1.model.GetActiveMeetingReserveReq;
import com.lark.oapi.service.vc.v1.model.GetActiveMeetingReserveResp;
import com.lark.oapi.service.vc.v1.model.GetDailyReportReq;
import com.lark.oapi.service.vc.v1.model.GetDailyReportResp;
import com.lark.oapi.service.vc.v1.model.GetExportReq;
import com.lark.oapi.service.vc.v1.model.GetExportResp;
import com.lark.oapi.service.vc.v1.model.GetMeetingRecordingReq;
import com.lark.oapi.service.vc.v1.model.GetMeetingRecordingResp;
import com.lark.oapi.service.vc.v1.model.GetMeetingReq;
import com.lark.oapi.service.vc.v1.model.GetMeetingResp;
import com.lark.oapi.service.vc.v1.model.GetReserveReq;
import com.lark.oapi.service.vc.v1.model.GetReserveResp;
import com.lark.oapi.service.vc.v1.model.GetTopUserReportReq;
import com.lark.oapi.service.vc.v1.model.GetTopUserReportResp;
import com.lark.oapi.service.vc.v1.model.InviteMeetingReq;
import com.lark.oapi.service.vc.v1.model.InviteMeetingResp;
import com.lark.oapi.service.vc.v1.model.KickoutMeetingReq;
import com.lark.oapi.service.vc.v1.model.KickoutMeetingResp;
import com.lark.oapi.service.vc.v1.model.ListAlertReq;
import com.lark.oapi.service.vc.v1.model.ListAlertResp;
import com.lark.oapi.service.vc.v1.model.ListByNoMeetingReq;
import com.lark.oapi.service.vc.v1.model.ListByNoMeetingResp;
import com.lark.oapi.service.vc.v1.model.MeetingListExportReq;
import com.lark.oapi.service.vc.v1.model.MeetingListExportResp;
import com.lark.oapi.service.vc.v1.model.P2MeetingEndedV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingJoinMeetingV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingLeaveMeetingV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingRecordingEndedV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingRecordingReadyV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingRecordingStartedV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingShareEndedV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingShareStartedV1;
import com.lark.oapi.service.vc.v1.model.P2MeetingStartedV1;
import com.lark.oapi.service.vc.v1.model.ParticipantListExportReq;
import com.lark.oapi.service.vc.v1.model.ParticipantListExportResp;
import com.lark.oapi.service.vc.v1.model.ParticipantQualityListExportReq;
import com.lark.oapi.service.vc.v1.model.ParticipantQualityListExportResp;
import com.lark.oapi.service.vc.v1.model.PatchReserveConfigReq;
import com.lark.oapi.service.vc.v1.model.PatchReserveConfigResp;
import com.lark.oapi.service.vc.v1.model.QueryRoomConfigReq;
import com.lark.oapi.service.vc.v1.model.QueryRoomConfigResp;
import com.lark.oapi.service.vc.v1.model.ReserveScopeReserveConfigReq;
import com.lark.oapi.service.vc.v1.model.ReserveScopeReserveConfigResp;
import com.lark.oapi.service.vc.v1.model.ResourceReservationListExportReq;
import com.lark.oapi.service.vc.v1.model.ResourceReservationListExportResp;
import com.lark.oapi.service.vc.v1.model.SetHostMeetingReq;
import com.lark.oapi.service.vc.v1.model.SetHostMeetingResp;
import com.lark.oapi.service.vc.v1.model.SetPermissionMeetingRecordingReq;
import com.lark.oapi.service.vc.v1.model.SetPermissionMeetingRecordingResp;
import com.lark.oapi.service.vc.v1.model.SetRoomConfigReq;
import com.lark.oapi.service.vc.v1.model.SetRoomConfigResp;
import com.lark.oapi.service.vc.v1.model.StartMeetingRecordingReq;
import com.lark.oapi.service.vc.v1.model.StartMeetingRecordingResp;
import com.lark.oapi.service.vc.v1.model.StopMeetingRecordingReq;
import com.lark.oapi.service.vc.v1.model.StopMeetingRecordingResp;
import com.lark.oapi.service.vc.v1.model.UpdateReserveReq;
import com.lark.oapi.service.vc.v1.model.UpdateReserveResp;
import java.io.ByteArrayOutputStream;

public class VcService {

  private final Alert alert; // 告警中心
  private final Export export; // 导出
  private final Meeting meeting; // 会议
  private final MeetingRecording meetingRecording; // 录制
  private final Report report; // 会议报告
  private final Reserve reserve; // 预约
  private final ReserveConfig reserveConfig; // reserve_config
  private final RoomConfig roomConfig; // 会议室配置

  public VcService(Config config) {
    this.alert = new Alert(config);
    this.export = new Export(config);
    this.meeting = new Meeting(config);
    this.meetingRecording = new MeetingRecording(config);
    this.report = new Report(config);
    this.reserve = new Reserve(config);
    this.reserveConfig = new ReserveConfig(config);
    this.roomConfig = new RoomConfig(config);
  }

  /**
   * 告警中心
   *
   * @return
   */
  public Alert alert() {
    return alert;
  }

  /**
   * 导出
   *
   * @return
   */
  public Export export() {
    return export;
  }

  /**
   * 会议
   *
   * @return
   */
  public Meeting meeting() {
    return meeting;
  }

  /**
   * 录制
   *
   * @return
   */
  public MeetingRecording meetingRecording() {
    return meetingRecording;
  }

  /**
   * 会议报告
   *
   * @return
   */
  public Report report() {
    return report;
  }

  /**
   * 预约
   *
   * @return
   */
  public Reserve reserve() {
    return reserve;
  }

  /**
   * reserve_config
   *
   * @return
   */
  public ReserveConfig reserveConfig() {
    return reserveConfig;
  }

  /**
   * 会议室配置
   *
   * @return
   */
  public RoomConfig roomConfig() {
    return roomConfig;
  }

  public static class Alert {

    private final Config config;

    public Alert(Config config) {
      this.config = config;
    }

    /**
     * 获取告警记录，获取特定条件下租户的设备告警记录
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/alert/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/alert/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListAlertSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListAlertSample.java</a>
     * ;
     */
    public ListAlertResp list(ListAlertReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/alerts"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAlertResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAlertResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取告警记录，获取特定条件下租户的设备告警记录
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/alert/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/alert/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListAlertSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListAlertSample.java</a>
     * ;
     */
    public ListAlertResp list(ListAlertReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/alerts"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAlertResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAlertResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Export {

    private final Config config;

    public Export(Config config) {
      this.config = config;
    }

    /**
     * 下载导出文件，下载导出文件
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/download">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/download</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DownloadExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DownloadExportSample.java</a>
     * ;
     */
    public DownloadExportResp download(DownloadExportReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/exports/download"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      if (httpResponse.getStatusCode() == 200) {
        DownloadExportResp resp = new DownloadExportResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      DownloadExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DownloadExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 下载导出文件，下载导出文件
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/download">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/download</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DownloadExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DownloadExportSample.java</a>
     * ;
     */
    public DownloadExportResp download(DownloadExportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();
      reqOptions.setSupportDownLoad(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/exports/download"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 下载请求，返回流
      if (httpResponse.getStatusCode() == 200) {
        DownloadExportResp resp = new DownloadExportResp();
        resp.setRawResponse(httpResponse);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(httpResponse.getBody());
        resp.setData(outputStream);
        resp.setFileName(httpResponse.getFileName());
        return resp;
      }
      // 反序列化
      DownloadExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DownloadExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 查询导出任务结果，查看异步导出的进度
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetExportSample.java</a>
     * ;
     */
    public GetExportResp get(GetExportReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/exports/:task_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 查询导出任务结果，查看异步导出的进度
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetExportSample.java</a>
     * ;
     */
    public GetExportResp get(GetExportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/exports/:task_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出会议明细，导出会议明细，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/meeting_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/meeting_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/MeetingListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/MeetingListExportSample.java</a>
     * ;
     */
    public MeetingListExportResp meetingList(MeetingListExportReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/meeting_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      MeetingListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          MeetingListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出会议明细，导出会议明细，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/meeting_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/meeting_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/MeetingListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/MeetingListExportSample.java</a>
     * ;
     */
    public MeetingListExportResp meetingList(MeetingListExportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/meeting_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      MeetingListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          MeetingListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出参会人明细，导出某个会议的参会人详情列表，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantListExportSample.java</a>
     * ;
     */
    public ParticipantListExportResp participantList(ParticipantListExportReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/participant_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ParticipantListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ParticipantListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出参会人明细，导出某个会议的参会人详情列表，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantListExportSample.java</a>
     * ;
     */
    public ParticipantListExportResp participantList(ParticipantListExportReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/participant_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ParticipantListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ParticipantListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出参会人会议质量数据，导出某场会议某个参会人的音视频&共享质量数据;，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_quality_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_quality_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantQualityListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantQualityListExportSample.java</a>
     * ;
     */
    public ParticipantQualityListExportResp participantQualityList(
        ParticipantQualityListExportReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/participant_quality_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ParticipantQualityListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ParticipantQualityListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出参会人会议质量数据，导出某场会议某个参会人的音视频&共享质量数据;，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_quality_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/participant_quality_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantQualityListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ParticipantQualityListExportSample.java</a>
     * ;
     */
    public ParticipantQualityListExportResp participantQualityList(
        ParticipantQualityListExportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/participant_quality_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ParticipantQualityListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ParticipantQualityListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出会议室预定数据，导出会议室预定数据，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/resource_reservation_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/resource_reservation_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ResourceReservationListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ResourceReservationListExportSample.java</a>
     * ;
     */
    public ResourceReservationListExportResp resourceReservationList(
        ResourceReservationListExportReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/resource_reservation_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ResourceReservationListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResourceReservationListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 导出会议室预定数据，导出会议室预定数据，具体权限要求请参考「导出概述」
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/resource_reservation_list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/export/resource_reservation_list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ResourceReservationListExportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ResourceReservationListExportSample.java</a>
     * ;
     */
    public ResourceReservationListExportResp resourceReservationList(
        ResourceReservationListExportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/exports/resource_reservation_list"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ResourceReservationListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResourceReservationListExportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Meeting {

    private final Config config;

    public Meeting(Config config) {
      this.config = config;
    }

    /**
     * 结束会议，结束一个进行中的会议
     * <p> 会议正在进行中，且操作者须具有相应的权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/end">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/end</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/EndMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/EndMeetingSample.java</a>
     * ;
     */
    public EndMeetingResp end(EndMeetingReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/end"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      EndMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, EndMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 结束会议，结束一个进行中的会议
     * <p> 会议正在进行中，且操作者须具有相应的权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/end">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/end</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/EndMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/EndMeetingSample.java</a>
     * ;
     */
    public EndMeetingResp end(EndMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/end"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      EndMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, EndMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取会议详情，获取一个会议的详细数据
     * <p> 只能获取归属于自己的会议，支持查询最近90天内的会议 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingSample.java</a>
     * ;
     */
    public GetMeetingResp get(GetMeetingReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/:meeting_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取会议详情，获取一个会议的详细数据
     * <p> 只能获取归属于自己的会议，支持查询最近90天内的会议 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingSample.java</a>
     * ;
     */
    public GetMeetingResp get(GetMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/:meeting_id"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 邀请参会人，邀请参会人进入会议
     * <p> 发起邀请的操作者必须具有相应的权限（如果操作者为用户，则必须在会中），如果会议被锁定、或参会人数如果达到上限，则会邀请失败 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/invite">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/invite</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/InviteMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/InviteMeetingSample.java</a>
     * ;
     */
    public InviteMeetingResp invite(InviteMeetingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/invite"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      InviteMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          InviteMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 邀请参会人，邀请参会人进入会议
     * <p> 发起邀请的操作者必须具有相应的权限（如果操作者为用户，则必须在会中），如果会议被锁定、或参会人数如果达到上限，则会邀请失败 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/invite">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/invite</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/InviteMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/InviteMeetingSample.java</a>
     * ;
     */
    public InviteMeetingResp invite(InviteMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/invite"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      InviteMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          InviteMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 移除参会人，将参会人从会议中移除
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/kickout">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/kickout</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/KickoutMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/KickoutMeetingSample.java</a>
     * ;
     */
    public KickoutMeetingResp kickout(KickoutMeetingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/meetings/:meeting_id/kickout"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      KickoutMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          KickoutMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 移除参会人，将参会人从会议中移除
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/kickout">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/kickout</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/KickoutMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/KickoutMeetingSample.java</a>
     * ;
     */
    public KickoutMeetingResp kickout(KickoutMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/meetings/:meeting_id/kickout"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      KickoutMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          KickoutMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取与会议号相关联的会议列表，获取指定时间范围（90天内)会议号关联的会议简要信息列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/list_by_no">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/list_by_no</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListByNoMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListByNoMeetingSample.java</a>
     * ;
     */
    public ListByNoMeetingResp listByNo(ListByNoMeetingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/list_by_no"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListByNoMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListByNoMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取与会议号相关联的会议列表，获取指定时间范围（90天内)会议号关联的会议简要信息列表
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/list_by_no">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/list_by_no</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListByNoMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ListByNoMeetingSample.java</a>
     * ;
     */
    public ListByNoMeetingResp listByNo(ListByNoMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/list_by_no"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListByNoMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListByNoMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 设置主持人，设置会议的主持人
     * <p> 发起设置主持人的操作者必须具有相应的权限（如果操作者为用户，必须是会中当前主持人）；该操作使用CAS并发安全机制，需传入会中当前主持人，如果操作失败可使用返回的最新数据重试 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/set_host">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/set_host</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetHostMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetHostMeetingSample.java</a>
     * ;
     */
    public SetHostMeetingResp setHost(SetHostMeetingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/set_host"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      SetHostMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetHostMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 设置主持人，设置会议的主持人
     * <p> 发起设置主持人的操作者必须具有相应的权限（如果操作者为用户，必须是会中当前主持人）；该操作使用CAS并发安全机制，需传入会中当前主持人，如果操作失败可使用返回的最新数据重试 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/set_host">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting/set_host</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetHostMeetingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetHostMeetingSample.java</a>
     * ;
     */
    public SetHostMeetingResp setHost(SetHostMeetingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/set_host"
          , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
          , req);

      // 反序列化
      SetHostMeetingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetHostMeetingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class MeetingRecording {

    private final Config config;

    public MeetingRecording(Config config) {
      this.config = config;
    }

    /**
     * 获取录制文件，获取一个会议的录制文件。
     * <p> 会议结束后并且收到了"录制完成"的事件方可获取录制文件；只有会议owner（通过开放平台预约的会议即为预约人）有权限获取；录制时间太短(&lt;5s)有可能无法生成录制文件 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingRecordingSample.java</a>
     * ;
     */
    public GetMeetingRecordingResp get(GetMeetingRecordingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取录制文件，获取一个会议的录制文件。
     * <p> 会议结束后并且收到了"录制完成"的事件方可获取录制文件；只有会议owner（通过开放平台预约的会议即为预约人）有权限获取；录制时间太短(&lt;5s)有可能无法生成录制文件 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetMeetingRecordingSample.java</a>
     * ;
     */
    public GetMeetingRecordingResp get(GetMeetingRecordingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 授权录制文件，将一个会议的录制文件授权给组织、用户或公开到公网
     * <p> 会议结束后并且收到了"录制完成"的事件方可进行授权；会议owner（通过开放平台预约的会议即为预约人）才有权限操作 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/set_permission">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/set_permission</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetPermissionMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetPermissionMeetingRecordingSample.java</a>
     * ;
     */
    public SetPermissionMeetingRecordingResp setPermission(SetPermissionMeetingRecordingReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/set_permission"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SetPermissionMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetPermissionMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 授权录制文件，将一个会议的录制文件授权给组织、用户或公开到公网
     * <p> 会议结束后并且收到了"录制完成"的事件方可进行授权；会议owner（通过开放平台预约的会议即为预约人）才有权限操作 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/set_permission">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/set_permission</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetPermissionMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetPermissionMeetingRecordingSample.java</a>
     * ;
     */
    public SetPermissionMeetingRecordingResp setPermission(SetPermissionMeetingRecordingReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/set_permission"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      SetPermissionMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetPermissionMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 开始录制，在会议中开始录制。
     * <p> 会议正在进行中，且操作者具有相应权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/start">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/start</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StartMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StartMeetingRecordingSample.java</a>
     * ;
     */
    public StartMeetingRecordingResp start(StartMeetingRecordingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/start"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      StartMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StartMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 开始录制，在会议中开始录制。
     * <p> 会议正在进行中，且操作者具有相应权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/start">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/start</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StartMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StartMeetingRecordingSample.java</a>
     * ;
     */
    public StartMeetingRecordingResp start(StartMeetingRecordingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/start"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      StartMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StartMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 停止录制，在会议中停止录制。
     * <p> 会议正在录制中，且操作者具有相应权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/stop">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/stop</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StopMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StopMeetingRecordingSample.java</a>
     * ;
     */
    public StopMeetingRecordingResp stop(StopMeetingRecordingReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/stop"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      StopMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StopMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 停止录制，在会议中停止录制。
     * <p> 会议正在录制中，且操作者具有相应权限（如果操作者为用户，必须是会中当前主持人） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/stop">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/meeting-recording/stop</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StopMeetingRecordingSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/StopMeetingRecordingSample.java</a>
     * ;
     */
    public StopMeetingRecordingResp stop(StopMeetingRecordingReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/meetings/:meeting_id/recording/stop"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      StopMeetingRecordingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          StopMeetingRecordingResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Report {

    private final Config config;

    public Report(Config config) {
      this.config = config;
    }

    /**
     * 获取会议报告，获取一段时间内组织的每日会议使用报告。
     * <p> 支持最近90天内的数据查询 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_daily">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_daily</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetDailyReportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetDailyReportSample.java</a>
     * ;
     */
    public GetDailyReportResp getDaily(GetDailyReportReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reports/get_daily"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetDailyReportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDailyReportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取会议报告，获取一段时间内组织的每日会议使用报告。
     * <p> 支持最近90天内的数据查询 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_daily">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_daily</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetDailyReportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetDailyReportSample.java</a>
     * ;
     */
    public GetDailyReportResp getDaily(GetDailyReportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reports/get_daily"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetDailyReportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDailyReportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取top用户列表，获取一段时间内组织内会议使用的top用户列表。
     * <p> 支持最近90天内的数据查询；默认返回前10位，最多可查询前100位 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_top_user">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_top_user</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetTopUserReportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetTopUserReportSample.java</a>
     * ;
     */
    public GetTopUserReportResp getTopUser(GetTopUserReportReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reports/get_top_user"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTopUserReportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetTopUserReportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取top用户列表，获取一段时间内组织内会议使用的top用户列表。
     * <p> 支持最近90天内的数据查询；默认返回前10位，最多可查询前100位 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_top_user">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/report/get_top_user</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetTopUserReportSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetTopUserReportSample.java</a>
     * ;
     */
    public GetTopUserReportResp getTopUser(GetTopUserReportReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reports/get_top_user"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetTopUserReportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetTopUserReportResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Reserve {

    private final Config config;

    public Reserve(Config config) {
      this.config = config;
    }

    /**
     * 预约会议，创建一个会议预约。
     * <p> 支持预约最近30天内的会议（到期时间距离当前时间不超过30天），预约到期后会议号将被释放，如需继续使用可通过"更新预约"接口进行续期；预约会议时可配置参会人在会中的权限，以达到控制会议的目的
     * ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/apply">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/apply</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ApplyReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ApplyReserveSample.java</a>
     * ;
     */
    public ApplyReserveResp apply(ApplyReserveReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/reserves/apply"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      ApplyReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ApplyReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 预约会议，创建一个会议预约。
     * <p> 支持预约最近30天内的会议（到期时间距离当前时间不超过30天），预约到期后会议号将被释放，如需继续使用可通过"更新预约"接口进行续期；预约会议时可配置参会人在会中的权限，以达到控制会议的目的
     * ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/apply">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/apply</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ApplyReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ApplyReserveSample.java</a>
     * ;
     */
    public ApplyReserveResp apply(ApplyReserveReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/reserves/apply"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      ApplyReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ApplyReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 删除预约，删除一个预约
     * <p> 只能删除归属于自己的预约；删除后数据不可恢复 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DeleteReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DeleteReserveSample.java</a>
     * ;
     */
    public DeleteReserveResp delete(DeleteReserveReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 删除预约，删除一个预约
     * <p> 只能删除归属于自己的预约；删除后数据不可恢复 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DeleteReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/DeleteReserveSample.java</a>
     * ;
     */
    public DeleteReserveResp delete(DeleteReserveReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      DeleteReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取预约，获取一个预约的详情
     * <p> 只能获取归属于自己的预约 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetReserveSample.java</a>
     * ;
     */
    public GetReserveResp get(GetReserveReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取预约，获取一个预约的详情
     * <p> 只能获取归属于自己的预约 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetReserveSample.java</a>
     * ;
     */
    public GetReserveResp get(GetReserveReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取活跃会议，获取一个预约的当前活跃会议
     * <p> 只能获取归属于自己的预约的活跃会议（一个预约最多有一个正在进行中的会议） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get_active_meeting">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get_active_meeting</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetActiveMeetingReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetActiveMeetingReserveSample.java</a>
     * ;
     */
    public GetActiveMeetingReserveResp getActiveMeeting(GetActiveMeetingReserveReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserves/:reserve_id/get_active_meeting"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetActiveMeetingReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetActiveMeetingReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取活跃会议，获取一个预约的当前活跃会议
     * <p> 只能获取归属于自己的预约的活跃会议（一个预约最多有一个正在进行中的会议） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get_active_meeting">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/get_active_meeting</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetActiveMeetingReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/GetActiveMeetingReserveSample.java</a>
     * ;
     */
    public GetActiveMeetingReserveResp getActiveMeeting(GetActiveMeetingReserveReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserves/:reserve_id/get_active_meeting"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      GetActiveMeetingReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetActiveMeetingReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新预约，更新一个预约
     * <p> 只能更新归属于自己的预约，不需要更新的字段不传（如果传空则会被更新为空）；可用于续期操作，到期时间距离当前时间不超过30天 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/UpdateReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/UpdateReserveSample.java</a>
     * ;
     */
    public UpdateReserveResp update(UpdateReserveReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      UpdateReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新预约，更新一个预约
     * <p> 只能更新归属于自己的预约，不需要更新的字段不传（如果传空则会被更新为空）；可用于续期操作，到期时间距离当前时间不超过30天 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/UpdateReserveSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/UpdateReserveSample.java</a>
     * ;
     */
    public UpdateReserveResp update(UpdateReserveReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/vc/v1/reserves/:reserve_id"
          , Sets.newHashSet(AccessTokenType.User)
          , req);

      // 反序列化
      UpdateReserveResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateReserveResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class ReserveConfig {

    private final Config config;

    public ReserveConfig(Config config) {
      this.config = config;
    }

    /**
     * 更新会议室预定范围，更新会议室预定范围
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/patch">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/PatchReserveConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/PatchReserveConfigSample.java</a>
     * ;
     */
    public PatchReserveConfigResp patch(PatchReserveConfigReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/reserve_configs/:reserve_config_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchReserveConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchReserveConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新会议室预定范围，更新会议室预定范围
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/patch">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/PatchReserveConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/PatchReserveConfigSample.java</a>
     * ;
     */
    public PatchReserveConfigResp patch(PatchReserveConfigReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/vc/v1/reserve_configs/:reserve_config_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchReserveConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchReserveConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取会议室预定范围，获取会议室预定范围
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/reserve_scope">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/reserve_scope</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ReserveScopeReserveConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ReserveScopeReserveConfigSample.java</a>
     * ;
     */
    public ReserveScopeReserveConfigResp reserveScope(ReserveScopeReserveConfigReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserve_configs/reserve_scope"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ReserveScopeReserveConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ReserveScopeReserveConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取会议室预定范围，获取会议室预定范围
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/reserve_scope">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/reserve_config/reserve_scope</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ReserveScopeReserveConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/ReserveScopeReserveConfigSample.java</a>
     * ;
     */
    public ReserveScopeReserveConfigResp reserveScope(ReserveScopeReserveConfigReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/reserve_configs/reserve_scope"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ReserveScopeReserveConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ReserveScopeReserveConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class RoomConfig {

    private final Config config;

    public RoomConfig(Config config) {
      this.config = config;
    }

    /**
     * 查询会议室配置，查询一个范围内的会议室配置。
     * <p> 根据查询范围传入对应的参数 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/query">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/query</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/QueryRoomConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/QueryRoomConfigSample.java</a>
     * ;
     */
    public QueryRoomConfigResp query(QueryRoomConfigReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/room_configs/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      QueryRoomConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QueryRoomConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 查询会议室配置，查询一个范围内的会议室配置。
     * <p> 根据查询范围传入对应的参数 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/query">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/query</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/QueryRoomConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/QueryRoomConfigSample.java</a>
     * ;
     */
    public QueryRoomConfigResp query(QueryRoomConfigReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/vc/v1/room_configs/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      QueryRoomConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          QueryRoomConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 设置会议室配置，设置一个范围内的会议室配置。
     * <p> 根据设置范围传入对应的参数 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/set">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/set</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetRoomConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetRoomConfigSample.java</a>
     * ;
     */
    public SetRoomConfigResp set(SetRoomConfigReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/room_configs/set"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SetRoomConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetRoomConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 设置会议室配置，设置一个范围内的会议室配置。
     * <p> 根据设置范围传入对应的参数 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/set">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/vc-v1/room_config/set</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetRoomConfigSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/vcv1/SetRoomConfigSample.java</a>
     * ;
     */
    public SetRoomConfigResp set(SetRoomConfigReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/vc/v1/room_configs/set"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      SetRoomConfigResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          SetRoomConfigResp.class);
      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public abstract static class P2MeetingJoinMeetingV1Handler implements
      IEventHandler<P2MeetingJoinMeetingV1> {

    @Override
    public P2MeetingJoinMeetingV1 getEvent() {
      return new P2MeetingJoinMeetingV1();
    }
  }

  public abstract static class P2MeetingLeaveMeetingV1Handler implements
      IEventHandler<P2MeetingLeaveMeetingV1> {

    @Override
    public P2MeetingLeaveMeetingV1 getEvent() {
      return new P2MeetingLeaveMeetingV1();
    }
  }

  public abstract static class P2MeetingEndedV1Handler implements IEventHandler<P2MeetingEndedV1> {

    @Override
    public P2MeetingEndedV1 getEvent() {
      return new P2MeetingEndedV1();
    }
  }

  public abstract static class P2MeetingStartedV1Handler implements
      IEventHandler<P2MeetingStartedV1> {

    @Override
    public P2MeetingStartedV1 getEvent() {
      return new P2MeetingStartedV1();
    }
  }

  public abstract static class P2MeetingRecordingEndedV1Handler implements
      IEventHandler<P2MeetingRecordingEndedV1> {

    @Override
    public P2MeetingRecordingEndedV1 getEvent() {
      return new P2MeetingRecordingEndedV1();
    }
  }

  public abstract static class P2MeetingRecordingReadyV1Handler implements
      IEventHandler<P2MeetingRecordingReadyV1> {

    @Override
    public P2MeetingRecordingReadyV1 getEvent() {
      return new P2MeetingRecordingReadyV1();
    }
  }

  public abstract static class P2MeetingRecordingStartedV1Handler implements
      IEventHandler<P2MeetingRecordingStartedV1> {

    @Override
    public P2MeetingRecordingStartedV1 getEvent() {
      return new P2MeetingRecordingStartedV1();
    }
  }

  public abstract static class P2MeetingShareEndedV1Handler implements
      IEventHandler<P2MeetingShareEndedV1> {

    @Override
    public P2MeetingShareEndedV1 getEvent() {
      return new P2MeetingShareEndedV1();
    }
  }

  public abstract static class P2MeetingShareStartedV1Handler implements
      IEventHandler<P2MeetingShareStartedV1> {

    @Override
    public P2MeetingShareStartedV1 getEvent() {
      return new P2MeetingShareStartedV1();
    }
  }
}