/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.drive.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.drive.v1.model.BatchGetTmpDownloadUrlMediaReq;
import com.lark.oapi.service.drive.v1.model.BatchGetTmpDownloadUrlMediaResp;
import com.lark.oapi.service.drive.v1.model.BatchQueryMetaReq;
import com.lark.oapi.service.drive.v1.model.BatchQueryMetaResp;
import com.lark.oapi.service.drive.v1.model.CopyFileReq;
import com.lark.oapi.service.drive.v1.model.CopyFileResp;
import com.lark.oapi.service.drive.v1.model.CreateExportTaskReq;
import com.lark.oapi.service.drive.v1.model.CreateExportTaskResp;
import com.lark.oapi.service.drive.v1.model.CreateFileCommentReq;
import com.lark.oapi.service.drive.v1.model.CreateFileCommentResp;
import com.lark.oapi.service.drive.v1.model.CreateFileSubscriptionReq;
import com.lark.oapi.service.drive.v1.model.CreateFileSubscriptionResp;
import com.lark.oapi.service.drive.v1.model.CreateFolderFileReq;
import com.lark.oapi.service.drive.v1.model.CreateFolderFileResp;
import com.lark.oapi.service.drive.v1.model.CreateImportTaskReq;
import com.lark.oapi.service.drive.v1.model.CreateImportTaskResp;
import com.lark.oapi.service.drive.v1.model.CreatePermissionMemberReq;
import com.lark.oapi.service.drive.v1.model.CreatePermissionMemberResp;
import com.lark.oapi.service.drive.v1.model.DeleteFileCommentReplyReq;
import com.lark.oapi.service.drive.v1.model.DeleteFileCommentReplyResp;
import com.lark.oapi.service.drive.v1.model.DeleteFileReq;
import com.lark.oapi.service.drive.v1.model.DeleteFileResp;
import com.lark.oapi.service.drive.v1.model.DeletePermissionMemberReq;
import com.lark.oapi.service.drive.v1.model.DeletePermissionMemberResp;
import com.lark.oapi.service.drive.v1.model.DownloadExportTaskReq;
import com.lark.oapi.service.drive.v1.model.DownloadExportTaskResp;
import com.lark.oapi.service.drive.v1.model.DownloadFileReq;
import com.lark.oapi.service.drive.v1.model.DownloadFileResp;
import com.lark.oapi.service.drive.v1.model.DownloadMediaReq;
import com.lark.oapi.service.drive.v1.model.DownloadMediaResp;
import com.lark.oapi.service.drive.v1.model.GetExportTaskReq;
import com.lark.oapi.service.drive.v1.model.GetExportTaskResp;
import com.lark.oapi.service.drive.v1.model.GetFileCommentReq;
import com.lark.oapi.service.drive.v1.model.GetFileCommentResp;
import com.lark.oapi.service.drive.v1.model.GetFileStatisticsReq;
import com.lark.oapi.service.drive.v1.model.GetFileStatisticsResp;
import com.lark.oapi.service.drive.v1.model.GetFileSubscriptionReq;
import com.lark.oapi.service.drive.v1.model.GetFileSubscriptionResp;
import com.lark.oapi.service.drive.v1.model.GetImportTaskReq;
import com.lark.oapi.service.drive.v1.model.GetImportTaskResp;
import com.lark.oapi.service.drive.v1.model.GetPermissionPublicReq;
import com.lark.oapi.service.drive.v1.model.GetPermissionPublicResp;
import com.lark.oapi.service.drive.v1.model.ListFileCommentReq;
import com.lark.oapi.service.drive.v1.model.ListFileCommentResp;
import com.lark.oapi.service.drive.v1.model.ListFileReq;
import com.lark.oapi.service.drive.v1.model.ListFileResp;
import com.lark.oapi.service.drive.v1.model.ListPermissionMemberReq;
import com.lark.oapi.service.drive.v1.model.ListPermissionMemberResp;
import com.lark.oapi.service.drive.v1.model.MoveFileReq;
import com.lark.oapi.service.drive.v1.model.MoveFileResp;
import com.lark.oapi.service.drive.v1.model.P2FileBitableFieldChangedV1;
import com.lark.oapi.service.drive.v1.model.P2FileDeletedV1;
import com.lark.oapi.service.drive.v1.model.P2FileEditV1;
import com.lark.oapi.service.drive.v1.model.P2FilePermissionMemberAddedV1;
import com.lark.oapi.service.drive.v1.model.P2FilePermissionMemberRemovedV1;
import com.lark.oapi.service.drive.v1.model.P2FileReadV1;
import com.lark.oapi.service.drive.v1.model.P2FileTitleUpdatedV1;
import com.lark.oapi.service.drive.v1.model.P2FileTrashedV1;
import com.lark.oapi.service.drive.v1.model.PatchFileCommentReq;
import com.lark.oapi.service.drive.v1.model.PatchFileCommentResp;
import com.lark.oapi.service.drive.v1.model.PatchFileSubscriptionReq;
import com.lark.oapi.service.drive.v1.model.PatchFileSubscriptionResp;
import com.lark.oapi.service.drive.v1.model.PatchPermissionPublicReq;
import com.lark.oapi.service.drive.v1.model.PatchPermissionPublicResp;
import com.lark.oapi.service.drive.v1.model.SubscribeFileReq;
import com.lark.oapi.service.drive.v1.model.SubscribeFileResp;
import com.lark.oapi.service.drive.v1.model.TaskCheckFileReq;
import com.lark.oapi.service.drive.v1.model.TaskCheckFileResp;
import com.lark.oapi.service.drive.v1.model.UpdateFileCommentReplyReq;
import com.lark.oapi.service.drive.v1.model.UpdateFileCommentReplyResp;
import com.lark.oapi.service.drive.v1.model.UpdatePermissionMemberReq;
import com.lark.oapi.service.drive.v1.model.UpdatePermissionMemberResp;
import com.lark.oapi.service.drive.v1.model.UploadAllFileReq;
import com.lark.oapi.service.drive.v1.model.UploadAllFileResp;
import com.lark.oapi.service.drive.v1.model.UploadAllMediaReq;
import com.lark.oapi.service.drive.v1.model.UploadAllMediaResp;
import com.lark.oapi.service.drive.v1.model.UploadFinishFileReq;
import com.lark.oapi.service.drive.v1.model.UploadFinishFileResp;
import com.lark.oapi.service.drive.v1.model.UploadFinishMediaReq;
import com.lark.oapi.service.drive.v1.model.UploadFinishMediaResp;
import com.lark.oapi.service.drive.v1.model.UploadPartFileReq;
import com.lark.oapi.service.drive.v1.model.UploadPartFileResp;
import com.lark.oapi.service.drive.v1.model.UploadPartMediaReq;
import com.lark.oapi.service.drive.v1.model.UploadPartMediaResp;
import com.lark.oapi.service.drive.v1.model.UploadPrepareFileReq;
import com.lark.oapi.service.drive.v1.model.UploadPrepareFileResp;
import com.lark.oapi.service.drive.v1.model.UploadPrepareMediaReq;
import com.lark.oapi.service.drive.v1.model.UploadPrepareMediaResp;
import java.io.ByteArrayOutputStream;

public class DriveService {
    private final ExportTask exportTask;
    private final File file;
    private final FileComment fileComment;
    private final FileCommentReply fileCommentReply;
    private final FileStatistics fileStatistics;
    private final FileSubscription fileSubscription;
    private final ImportTask importTask;
    private final Media media;
    private final Meta meta;
    private final PermissionMember permissionMember;
    private final PermissionPublic permissionPublic;

    public DriveService(Config config) {
        this.exportTask = new ExportTask(config);
        this.file = new File(config);
        this.fileComment = new FileComment(config);
        this.fileCommentReply = new FileCommentReply(config);
        this.fileStatistics = new FileStatistics(config);
        this.fileSubscription = new FileSubscription(config);
        this.importTask = new ImportTask(config);
        this.media = new Media(config);
        this.meta = new Meta(config);
        this.permissionMember = new PermissionMember(config);
        this.permissionPublic = new PermissionPublic(config);
    }

    public ExportTask exportTask() {
        return this.exportTask;
    }

    public File file() {
        return this.file;
    }

    public FileComment fileComment() {
        return this.fileComment;
    }

    public FileCommentReply fileCommentReply() {
        return this.fileCommentReply;
    }

    public FileStatistics fileStatistics() {
        return this.fileStatistics;
    }

    public FileSubscription fileSubscription() {
        return this.fileSubscription;
    }

    public ImportTask importTask() {
        return this.importTask;
    }

    public Media media() {
        return this.media;
    }

    public Meta meta() {
        return this.meta;
    }

    public PermissionMember permissionMember() {
        return this.permissionMember;
    }

    public PermissionPublic permissionPublic() {
        return this.permissionPublic;
    }

    public static abstract class P2FileTrashedV1Handler
    implements IEventHandler<P2FileTrashedV1> {
        @Override
        public P2FileTrashedV1 getEvent() {
            return new P2FileTrashedV1();
        }
    }

    public static abstract class P2FileTitleUpdatedV1Handler
    implements IEventHandler<P2FileTitleUpdatedV1> {
        @Override
        public P2FileTitleUpdatedV1 getEvent() {
            return new P2FileTitleUpdatedV1();
        }
    }

    public static abstract class P2FileReadV1Handler
    implements IEventHandler<P2FileReadV1> {
        @Override
        public P2FileReadV1 getEvent() {
            return new P2FileReadV1();
        }
    }

    public static abstract class P2FilePermissionMemberRemovedV1Handler
    implements IEventHandler<P2FilePermissionMemberRemovedV1> {
        @Override
        public P2FilePermissionMemberRemovedV1 getEvent() {
            return new P2FilePermissionMemberRemovedV1();
        }
    }

    public static abstract class P2FilePermissionMemberAddedV1Handler
    implements IEventHandler<P2FilePermissionMemberAddedV1> {
        @Override
        public P2FilePermissionMemberAddedV1 getEvent() {
            return new P2FilePermissionMemberAddedV1();
        }
    }

    public static abstract class P2FileEditV1Handler
    implements IEventHandler<P2FileEditV1> {
        @Override
        public P2FileEditV1 getEvent() {
            return new P2FileEditV1();
        }
    }

    public static abstract class P2FileDeletedV1Handler
    implements IEventHandler<P2FileDeletedV1> {
        @Override
        public P2FileDeletedV1 getEvent() {
            return new P2FileDeletedV1();
        }
    }

    public static abstract class P2FileBitableFieldChangedV1Handler
    implements IEventHandler<P2FileBitableFieldChangedV1> {
        @Override
        public P2FileBitableFieldChangedV1 getEvent() {
            return new P2FileBitableFieldChangedV1();
        }
    }

    public static class PermissionPublic {
        private final Config config;

        public PermissionPublic(Config config) {
            this.config = config;
        }

        public GetPermissionPublicResp get(GetPermissionPublicReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/permissions/:token/public", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetPermissionPublicResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetPermissionPublicResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetPermissionPublicResp get(GetPermissionPublicReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/permissions/:token/public", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetPermissionPublicResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetPermissionPublicResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchPermissionPublicResp patch(PatchPermissionPublicReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/permissions/:token/public", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            PatchPermissionPublicResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchPermissionPublicResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchPermissionPublicResp patch(PatchPermissionPublicReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/permissions/:token/public", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            PatchPermissionPublicResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchPermissionPublicResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class PermissionMember {
        private final Config config;

        public PermissionMember(Config config) {
            this.config = config;
        }

        public CreatePermissionMemberResp create(CreatePermissionMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/permissions/:token/members", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreatePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreatePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreatePermissionMemberResp create(CreatePermissionMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/permissions/:token/members", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreatePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreatePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeletePermissionMemberResp delete(DeletePermissionMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/permissions/:token/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeletePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeletePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeletePermissionMemberResp delete(DeletePermissionMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/permissions/:token/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeletePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeletePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListPermissionMemberResp list(ListPermissionMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/permissions/:token/members", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListPermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListPermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListPermissionMemberResp list(ListPermissionMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/permissions/:token/members", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListPermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListPermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdatePermissionMemberResp update(UpdatePermissionMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/drive/v1/permissions/:token/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdatePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdatePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdatePermissionMemberResp update(UpdatePermissionMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/drive/v1/permissions/:token/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdatePermissionMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdatePermissionMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Meta {
        private final Config config;

        public Meta(Config config) {
            this.config = config;
        }

        public BatchQueryMetaResp batchQuery(BatchQueryMetaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/metas/batch_query", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchQueryMetaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchQueryMetaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchQueryMetaResp batchQuery(BatchQueryMetaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/metas/batch_query", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchQueryMetaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchQueryMetaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Media {
        private final Config config;

        public Media(Config config) {
            this.config = config;
        }

        public BatchGetTmpDownloadUrlMediaResp batchGetTmpDownloadUrl(BatchGetTmpDownloadUrlMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/medias/batch_get_tmp_download_url", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            BatchGetTmpDownloadUrlMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetTmpDownloadUrlMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchGetTmpDownloadUrlMediaResp batchGetTmpDownloadUrl(BatchGetTmpDownloadUrlMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/medias/batch_get_tmp_download_url", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            BatchGetTmpDownloadUrlMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetTmpDownloadUrlMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadMediaResp download(DownloadMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/medias/:file_token/download", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadMediaResp resp = new DownloadMediaResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadMediaResp download(DownloadMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/medias/:file_token/download", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadMediaResp resp = new DownloadMediaResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadAllMediaResp uploadAll(UploadAllMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_all", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadAllMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadAllMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadAllMediaResp uploadAll(UploadAllMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_all", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadAllMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadAllMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadFinishMediaResp uploadFinish(UploadFinishMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_finish", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadFinishMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFinishMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadFinishMediaResp uploadFinish(UploadFinishMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_finish", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadFinishMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFinishMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPartMediaResp uploadPart(UploadPartMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_part", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPartMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPartMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPartMediaResp uploadPart(UploadPartMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_part", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPartMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPartMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPrepareMediaResp uploadPrepare(UploadPrepareMediaReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_prepare", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPrepareMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPrepareMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPrepareMediaResp uploadPrepare(UploadPrepareMediaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/medias/upload_prepare", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPrepareMediaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPrepareMediaResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ImportTask {
        private final Config config;

        public ImportTask(Config config) {
            this.config = config;
        }

        public CreateImportTaskResp create(CreateImportTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/import_tasks", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateImportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateImportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateImportTaskResp create(CreateImportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/import_tasks", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateImportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateImportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetImportTaskResp get(GetImportTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/import_tasks/:ticket", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetImportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetImportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetImportTaskResp get(GetImportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/import_tasks/:ticket", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetImportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetImportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class FileSubscription {
        private final Config config;

        public FileSubscription(Config config) {
            this.config = config;
        }

        public CreateFileSubscriptionResp create(CreateFileSubscriptionReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/subscriptions", Sets.newHashSet(AccessTokenType.User), req);
            CreateFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateFileSubscriptionResp create(CreateFileSubscriptionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/subscriptions", Sets.newHashSet(AccessTokenType.User), req);
            CreateFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFileSubscriptionResp get(GetFileSubscriptionReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/subscriptions/:subscription_id", Sets.newHashSet(AccessTokenType.User), req);
            GetFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFileSubscriptionResp get(GetFileSubscriptionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/subscriptions/:subscription_id", Sets.newHashSet(AccessTokenType.User), req);
            GetFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFileSubscriptionResp patch(PatchFileSubscriptionReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/files/:file_token/subscriptions/:subscription_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFileSubscriptionResp patch(PatchFileSubscriptionReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/files/:file_token/subscriptions/:subscription_id", Sets.newHashSet(AccessTokenType.User), req);
            PatchFileSubscriptionResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFileSubscriptionResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class FileStatistics {
        private final Config config;

        public FileStatistics(Config config) {
            this.config = config;
        }

        public GetFileStatisticsResp get(GetFileStatisticsReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/statistics", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetFileStatisticsResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileStatisticsResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFileStatisticsResp get(GetFileStatisticsReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/statistics", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetFileStatisticsResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileStatisticsResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class FileCommentReply {
        private final Config config;

        public FileCommentReply(Config config) {
            this.config = config;
        }

        public DeleteFileCommentReplyResp delete(DeleteFileCommentReplyReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            DeleteFileCommentReplyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFileCommentReplyResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteFileCommentReplyResp delete(DeleteFileCommentReplyReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            DeleteFileCommentReplyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFileCommentReplyResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateFileCommentReplyResp update(UpdateFileCommentReplyReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateFileCommentReplyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateFileCommentReplyResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateFileCommentReplyResp update(UpdateFileCommentReplyReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateFileCommentReplyResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateFileCommentReplyResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class FileComment {
        private final Config config;

        public FileComment(Config config) {
            this.config = config;
        }

        public CreateFileCommentResp create(CreateFileCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/comments", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateFileCommentResp create(CreateFileCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/comments", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFileCommentResp get(GetFileCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/comments/:comment_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetFileCommentResp get(GetFileCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/comments/:comment_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFileCommentResp list(ListFileCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/comments", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFileCommentResp list(ListFileCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/comments", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFileCommentResp patch(PatchFileCommentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/files/:file_token/comments/:comment_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            PatchFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchFileCommentResp patch(PatchFileCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/drive/v1/files/:file_token/comments/:comment_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            PatchFileCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchFileCommentResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class File {
        private final Config config;

        public File(Config config) {
            this.config = config;
        }

        public CopyFileResp copy(CopyFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/copy", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CopyFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CopyFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CopyFileResp copy(CopyFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/copy", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CopyFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CopyFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateFolderFileResp createFolder(CreateFolderFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/create_folder", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateFolderFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFolderFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateFolderFileResp createFolder(CreateFolderFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/create_folder", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateFolderFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateFolderFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteFileResp delete(DeleteFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/files/:file_token", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteFileResp delete(DeleteFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/drive/v1/files/:file_token", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadFileResp download(DownloadFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/download", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadFileResp resp = new DownloadFileResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadFileResp download(DownloadFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/:file_token/download", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadFileResp resp = new DownloadFileResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFileResp list(ListFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListFileResp list(ListFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveFileResp move(MoveFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/move", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveFileResp move(MoveFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/move", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubscribeFileResp subscribe(SubscribeFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/subscribe", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            SubscribeFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubscribeFileResp subscribe(SubscribeFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/:file_token/subscribe", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            SubscribeFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TaskCheckFileResp taskCheck(TaskCheckFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/task_check", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            TaskCheckFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TaskCheckFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TaskCheckFileResp taskCheck(TaskCheckFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/files/task_check", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            TaskCheckFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TaskCheckFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadAllFileResp uploadAll(UploadAllFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_all", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadAllFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadAllFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadAllFileResp uploadAll(UploadAllFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_all", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadAllFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadAllFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadFinishFileResp uploadFinish(UploadFinishFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_finish", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadFinishFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFinishFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadFinishFileResp uploadFinish(UploadFinishFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_finish", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadFinishFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFinishFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPartFileResp uploadPart(UploadPartFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_part", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPartFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPartFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPartFileResp uploadPart(UploadPartFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_part", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPartFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPartFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPrepareFileResp uploadPrepare(UploadPrepareFileReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_prepare", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPrepareFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPrepareFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadPrepareFileResp uploadPrepare(UploadPrepareFileReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/files/upload_prepare", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UploadPrepareFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadPrepareFileResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ExportTask {
        private final Config config;

        public ExportTask(Config config) {
            this.config = config;
        }

        public CreateExportTaskResp create(CreateExportTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/export_tasks", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateExportTaskResp create(CreateExportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/drive/v1/export_tasks", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadExportTaskResp download(DownloadExportTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/export_tasks/file/:file_token/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadExportTaskResp resp = new DownloadExportTaskResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DownloadExportTaskResp download(DownloadExportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/export_tasks/file/:file_token/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            if (httpResponse.getStatusCode() == 200) {
                DownloadExportTaskResp resp = new DownloadExportTaskResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            DownloadExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetExportTaskResp get(GetExportTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/export_tasks/:ticket", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetExportTaskResp get(GetExportTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/drive/v1/export_tasks/:ticket", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetExportTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExportTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

