// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.admin.v1.model.CreateBadgeGrantReq;
import com.lark.oapi.service.admin.v1.model.CreateBadgeGrantResp;
import com.lark.oapi.service.admin.v1.model.CreateBadgeImageReq;
import com.lark.oapi.service.admin.v1.model.CreateBadgeImageResp;
import com.lark.oapi.service.admin.v1.model.CreateBadgeReq;
import com.lark.oapi.service.admin.v1.model.CreateBadgeResp;
import com.lark.oapi.service.admin.v1.model.DeleteBadgeGrantReq;
import com.lark.oapi.service.admin.v1.model.DeleteBadgeGrantResp;
import com.lark.oapi.service.admin.v1.model.GetBadgeGrantReq;
import com.lark.oapi.service.admin.v1.model.GetBadgeGrantResp;
import com.lark.oapi.service.admin.v1.model.GetBadgeReq;
import com.lark.oapi.service.admin.v1.model.GetBadgeResp;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminDeptStatResp;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatReq;
import com.lark.oapi.service.admin.v1.model.ListAdminUserStatResp;
import com.lark.oapi.service.admin.v1.model.ListBadgeGrantReq;
import com.lark.oapi.service.admin.v1.model.ListBadgeGrantResp;
import com.lark.oapi.service.admin.v1.model.ListBadgeReq;
import com.lark.oapi.service.admin.v1.model.ListBadgeResp;
import com.lark.oapi.service.admin.v1.model.ResetPasswordReq;
import com.lark.oapi.service.admin.v1.model.ResetPasswordResp;
import com.lark.oapi.service.admin.v1.model.UpdateBadgeGrantReq;
import com.lark.oapi.service.admin.v1.model.UpdateBadgeGrantResp;
import com.lark.oapi.service.admin.v1.model.UpdateBadgeReq;
import com.lark.oapi.service.admin.v1.model.UpdateBadgeResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminService {

  private static final Logger log = LoggerFactory.getLogger(AdminService.class);
  private final AdminDeptStat adminDeptStat; // 部门维度的数据报表
  private final AdminUserStat adminUserStat; // 用户维度的数据报表
  private final Badge badge; // 勋章
  private final BadgeGrant badgeGrant; // 勋章授予名单
  private final BadgeImage badgeImage; // 勋章图片
  private final Password password; // 密码

  public AdminService(Config config) {
    this.adminDeptStat = new AdminDeptStat(config);
    this.adminUserStat = new AdminUserStat(config);
    this.badge = new Badge(config);
    this.badgeGrant = new BadgeGrant(config);
    this.badgeImage = new BadgeImage(config);
    this.password = new Password(config);
  }

  /**
   * 部门维度的数据报表
   *
   * @return
   */
  public AdminDeptStat adminDeptStat() {
    return adminDeptStat;
  }

  /**
   * 用户维度的数据报表
   *
   * @return
   */
  public AdminUserStat adminUserStat() {
    return adminUserStat;
  }

  /**
   * 勋章
   *
   * @return
   */
  public Badge badge() {
    return badge;
  }

  /**
   * 勋章授予名单
   *
   * @return
   */
  public BadgeGrant badgeGrant() {
    return badgeGrant;
  }

  /**
   * 勋章图片
   *
   * @return
   */
  public BadgeImage badgeImage() {
    return badgeImage;
  }

  /**
   * 密码
   *
   * @return
   */
  public Password password() {
    return password;
  }

  public static class AdminDeptStat {

    private final Config config;

    public AdminDeptStat(Config config) {
      this.config = config;
    }

    /**
     * 获取部门维度的用户活跃和功能使用数据，该接口用于获取部门维度的用户活跃和功能使用数据，即IM（即时通讯）、日历、云文档、音视频会议功能的使用数据。
     * <p> - 只有企业自建应用才有权限调用此接口;;- 当天的数据会在第二天的早上九点半产出（UTC+8） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_dept_stat/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_dept_stat/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminDeptStatSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminDeptStatSample.java</a>
     * ;
     */
    public ListAdminDeptStatResp list(ListAdminDeptStatReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_dept_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminDeptStatResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/admin_dept_stats"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取部门维度的用户活跃和功能使用数据，该接口用于获取部门维度的用户活跃和功能使用数据，即IM（即时通讯）、日历、云文档、音视频会议功能的使用数据。
     * <p> - 只有企业自建应用才有权限调用此接口;;- 当天的数据会在第二天的早上九点半产出（UTC+8） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_dept_stat/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_dept_stat/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminDeptStatSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminDeptStatSample.java</a>
     * ;
     */
    public ListAdminDeptStatResp list(ListAdminDeptStatReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_dept_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminDeptStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminDeptStatResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/admin_dept_stats"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class AdminUserStat {

    private final Config config;

    public AdminUserStat(Config config) {
      this.config = config;
    }

    /**
     * 获取用户维度的用户活跃和功能使用数据，用于获取用户维度的用户活跃和功能使用数据，即IM（即时通讯）、日历、云文档、音视频会议功能的使用数据。
     * <p> - 只有企业自建应用才有权限调用此接口;;- 当天的数据会在第二天的早上九点半产出（UTC+8） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_user_stat/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_user_stat/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminUserStatSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminUserStatSample.java</a>
     * ;
     */
    public ListAdminUserStatResp list(ListAdminUserStatReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_user_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminUserStatResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/admin_user_stats"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取用户维度的用户活跃和功能使用数据，用于获取用户维度的用户活跃和功能使用数据，即IM（即时通讯）、日历、云文档、音视频会议功能的使用数据。
     * <p> - 只有企业自建应用才有权限调用此接口;;- 当天的数据会在第二天的早上九点半产出（UTC+8） ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_user_stat/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/admin_user_stat/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminUserStatSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListAdminUserStatSample.java</a>
     * ;
     */
    public ListAdminUserStatResp list(ListAdminUserStatReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/admin_user_stats"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListAdminUserStatResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListAdminUserStatResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/admin_user_stats"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Badge {

    private final Config config;

    public Badge(Config config) {
      this.config = config;
    }

    /**
     * 创建勋章，使用该接口可以创建一枚完整的勋章信息，一个租户下最多可创建1000枚勋章。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeSample.java</a>
     * ;
     */
    public CreateBadgeResp create(CreateBadgeReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badges"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建勋章，使用该接口可以创建一枚完整的勋章信息，一个租户下最多可创建1000枚勋章。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeSample.java</a>
     * ;
     */
    public CreateBadgeResp create(CreateBadgeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badges"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章详情，可以通过该接口查询勋章的详情
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeSample.java</a>
     * ;
     */
    public GetBadgeResp get(GetBadgeReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章详情，可以通过该接口查询勋章的详情
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeSample.java</a>
     * ;
     */
    public GetBadgeResp get(GetBadgeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章列表，可以通过该接口列出租户下所有的勋章，勋章的排列顺序是按照创建时间倒序排列。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeSample.java</a>
     * ;
     */
    public ListBadgeResp list(ListBadgeReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章列表，可以通过该接口列出租户下所有的勋章，勋章的排列顺序是按照创建时间倒序排列。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeSample.java</a>
     * ;
     */
    public ListBadgeResp list(ListBadgeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 修改勋章信息，通过该接口可以修改勋章的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeSample.java</a>
     * ;
     */
    public UpdateBadgeResp update(UpdateBadgeReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/admin/v1/badges/:badge_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 修改勋章信息，通过该接口可以修改勋章的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeSample.java</a>
     * ;
     */
    public UpdateBadgeResp update(UpdateBadgeReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/admin/v1/badges/:badge_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateBadgeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateBadgeResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class BadgeGrant {

    private final Config config;

    public BadgeGrant(Config config) {
      this.config = config;
    }

    /**
     * 创建勋章的授予名单，通过该接口可以为特定勋章创建一份授予名单，一枚勋章下最多可创建1000份授予名单。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeGrantSample.java</a>
     * ;
     */
    public CreateBadgeGrantResp create(CreateBadgeGrantReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badges/:badge_id/grants"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建勋章的授予名单，通过该接口可以为特定勋章创建一份授予名单，一枚勋章下最多可创建1000份授予名单。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeGrantSample.java</a>
     * ;
     */
    public CreateBadgeGrantResp create(CreateBadgeGrantReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badges/:badge_id/grants"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 删除授予名单，通过该接口可以删除特定授予名单的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/DeleteBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/DeleteBadgeGrantSample.java</a>
     * ;
     */
    public DeleteBadgeGrantResp delete(DeleteBadgeGrantReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 删除授予名单，通过该接口可以删除特定授予名单的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/DeleteBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/DeleteBadgeGrantSample.java</a>
     * ;
     */
    public DeleteBadgeGrantResp delete(DeleteBadgeGrantReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      DeleteBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          DeleteBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取授予名单的信息，通过该接口可以获取特定授予名单的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeGrantSample.java</a>
     * ;
     */
    public GetBadgeGrantResp get(GetBadgeGrantReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取授予名单的信息，通过该接口可以获取特定授予名单的信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/get">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/GetBadgeGrantSample.java</a>
     * ;
     */
    public GetBadgeGrantResp get(GetBadgeGrantReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      GetBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章的授予名单列表，通过该接口可以获取特定勋章下的授予名单列表，授予名单的排列顺序按照创建时间倒序排列。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeGrantSample.java</a>
     * ;
     */
    public ListBadgeGrantResp list(ListBadgeGrantReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id/grants"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取勋章的授予名单列表，通过该接口可以获取特定勋章下的授予名单列表，授予名单的排列顺序按照创建时间倒序排列。
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ListBadgeGrantSample.java</a>
     * ;
     */
    public ListBadgeGrantResp list(ListBadgeGrantReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/admin/v1/badges/:badge_id/grants"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ListBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 修改授予名单，通过该接口可以修改特定授予名单的相关信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeGrantSample.java</a>
     * ;
     */
    public UpdateBadgeGrantResp update(UpdateBadgeGrantReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 修改授予名单，通过该接口可以修改特定授予名单的相关信息
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/update">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge-grant/update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeGrantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/UpdateBadgeGrantSample.java</a>
     * ;
     */
    public UpdateBadgeGrantResp update(UpdateBadgeGrantReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PUT"
          , "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      UpdateBadgeGrantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          UpdateBadgeGrantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badges/:badge_id/grants/:grant_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class BadgeImage {

    private final Config config;

    public BadgeImage(Config config) {
      this.config = config;
    }

    /**
     * 上传勋章图片，通过该接口可以上传勋章详情图、挂饰图的文件，获取对应的文件key
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge_image/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge_image/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeImageSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeImageSample.java</a>
     * ;
     */
    public CreateBadgeImageResp create(CreateBadgeImageReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }
      reqOptions.setSupportUpload(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badge_images"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBadgeImageResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badge_images"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 上传勋章图片，通过该接口可以上传勋章详情图、挂饰图的文件，获取对应的文件key
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge_image/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/badge_image/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeImageSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/CreateBadgeImageSample.java</a>
     * ;
     */
    public CreateBadgeImageResp create(CreateBadgeImageReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();
      reqOptions.setSupportUpload(true);

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/badge_images"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      CreateBadgeImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateBadgeImageResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/badge_images"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class Password {

    private final Config config;

    public Password(Config config) {
      this.config = config;
    }

    /**
     * 重置密码，重置用户的企业邮箱密码，仅当用户的邮箱和企业邮箱(别名)一致时生效，可用于处理飞书企业邮箱登录死锁的问题。;;邮箱死锁：当用户的登录凭证与飞书企业邮箱一致时，目前飞书登录流程要求用户输入验证码，由于飞书邮箱无单独的帐号体系，则未登录时无法收取邮箱验证码，即陷入死锁
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/password/reset">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/password/reset</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ResetPasswordSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ResetPasswordSample.java</a>
     * ;
     */
    public ResetPasswordResp reset(ResetPasswordReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/password/reset"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResetPasswordResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/password/reset"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 重置密码，重置用户的企业邮箱密码，仅当用户的邮箱和企业邮箱(别名)一致时生效，可用于处理飞书企业邮箱登录死锁的问题。;;邮箱死锁：当用户的登录凭证与飞书企业邮箱一致时，目前飞书登录流程要求用户输入验证码，由于飞书邮箱无单独的帐号体系，则未登录时无法收取邮箱验证码，即陷入死锁
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/password/reset">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/admin-v1/password/reset</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ResetPasswordSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/adminv1/ResetPasswordSample.java</a>
     * ;
     */
    public ResetPasswordResp reset(ResetPasswordReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/admin/v1/password/reset"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , req);

      // 反序列化
      ResetPasswordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ResetPasswordResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/admin/v1/password/reset"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}