// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1.model;

import com.google.gson.annotations.SerializedName;

public class File {

  /**
   * 文档标题
   * <p> 示例值：文件管理综述
   */
  @SerializedName("title")
  private String title;
  /**
   * 文档类型
   * <p> 示例值：doc
   */
  @SerializedName("type")
  private String type;
  /**
   * 文档所有者
   * <p> 示例值：
   */
  @SerializedName("owner")
  private User owner;
  /**
   * 文档大小
   * <p> 示例值：1024
   */
  @SerializedName("size")
  private String size;
  /**
   * 更新时间
   * <p> 示例值：1649419092
   */
  @SerializedName("last_op_time")
  private String lastOpTime;
  /**
   * 文档状态
   * <p> 示例值：1
   */
  @SerializedName("status")
  private String status;
  /**
   * 文档token
   * <p> 示例值：doxbcOIyUhrRBWSKpBGfzefQgHe
   */
  @SerializedName("token")
  private String token;

  // builder 开始
  public File() {
  }

  public File(Builder builder) {
    /**
     * 文档标题
     * <p> 示例值：文件管理综述
     */
    this.title = builder.title;
    /**
     * 文档类型
     * <p> 示例值：doc
     */
    this.type = builder.type;
    /**
     * 文档所有者
     * <p> 示例值：
     */
    this.owner = builder.owner;
    /**
     * 文档大小
     * <p> 示例值：1024
     */
    this.size = builder.size;
    /**
     * 更新时间
     * <p> 示例值：1649419092
     */
    this.lastOpTime = builder.lastOpTime;
    /**
     * 文档状态
     * <p> 示例值：1
     */
    this.status = builder.status;
    /**
     * 文档token
     * <p> 示例值：doxbcOIyUhrRBWSKpBGfzefQgHe
     */
    this.token = builder.token;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getTitle() {
    return this.title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getType() {
    return this.type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public User getOwner() {
    return this.owner;
  }

  public void setOwner(User owner) {
    this.owner = owner;
  }

  public String getSize() {
    return this.size;
  }

  public void setSize(String size) {
    this.size = size;
  }

  public String getLastOpTime() {
    return this.lastOpTime;
  }

  public void setLastOpTime(String lastOpTime) {
    this.lastOpTime = lastOpTime;
  }

  public String getStatus() {
    return this.status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getToken() {
    return this.token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  public static class Builder {

    /**
     * 文档标题
     * <p> 示例值：文件管理综述
     */
    private String title;
    /**
     * 文档类型
     * <p> 示例值：doc
     */
    private String type;
    /**
     * 文档所有者
     * <p> 示例值：
     */
    private User owner;
    /**
     * 文档大小
     * <p> 示例值：1024
     */
    private String size;
    /**
     * 更新时间
     * <p> 示例值：1649419092
     */
    private String lastOpTime;
    /**
     * 文档状态
     * <p> 示例值：1
     */
    private String status;
    /**
     * 文档token
     * <p> 示例值：doxbcOIyUhrRBWSKpBGfzefQgHe
     */
    private String token;

    /**
     * 文档标题
     * <p> 示例值：文件管理综述
     *
     * @param title
     * @return
     */
    public Builder title(String title) {
      this.title = title;
      return this;
    }


    /**
     * 文档类型
     * <p> 示例值：doc
     *
     * @param type
     * @return
     */
    public Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * 文档类型
     * <p> 示例值：doc
     *
     * @param type {@link com.lark.oapi.service.admin.v1.enums.FileTypeEnum}
     * @return
     */
    public Builder type(com.lark.oapi.service.admin.v1.enums.FileTypeEnum type) {
      this.type = type.getValue();
      return this;
    }


    /**
     * 文档所有者
     * <p> 示例值：
     *
     * @param owner
     * @return
     */
    public Builder owner(User owner) {
      this.owner = owner;
      return this;
    }


    /**
     * 文档大小
     * <p> 示例值：1024
     *
     * @param size
     * @return
     */
    public Builder size(String size) {
      this.size = size;
      return this;
    }


    /**
     * 更新时间
     * <p> 示例值：1649419092
     *
     * @param lastOpTime
     * @return
     */
    public Builder lastOpTime(String lastOpTime) {
      this.lastOpTime = lastOpTime;
      return this;
    }


    /**
     * 文档状态
     * <p> 示例值：1
     *
     * @param status
     * @return
     */
    public Builder status(String status) {
      this.status = status;
      return this;
    }

    /**
     * 文档状态
     * <p> 示例值：1
     *
     * @param status {@link com.lark.oapi.service.admin.v1.enums.FileStatusEnum}
     * @return
     */
    public Builder status(com.lark.oapi.service.admin.v1.enums.FileStatusEnum status) {
      this.status = status.getValue();
      return this;
    }


    /**
     * 文档token
     * <p> 示例值：doxbcOIyUhrRBWSKpBGfzefQgHe
     *
     * @param token
     * @return
     */
    public Builder token(String token) {
      this.token = token;
      return this;
    }


    public File build() {
      return new File(this);
    }
  }
}
