// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.google.gson.annotations.SerializedName;

public class UserTrip {

  /**
   * 审批实例 ID
   * <p> 示例值：6737202939523236113
   */
  @SerializedName("approval_id")
  private String approvalId;
  /**
   * 开始时间，时间格式为 yyyy-MM-dd HH:mm:ss
   * <p> 示例值：2021-01-04 09:00:00
   */
  @SerializedName("start_time")
  private String startTime;
  /**
   * 结束时间，时间格式为 yyyy-MM-dd HH:mm:ss
   * <p> 示例值：2021-01-04 19:00:00
   */
  @SerializedName("end_time")
  private String endTime;
  /**
   * 出差理由
   * <p> 示例值：培训
   */
  @SerializedName("reason")
  private String reason;
  /**
   * 审批通过时间，时间格式为 yyyy-MM-dd HH:mm:ss
   * <p> 示例值：2021-01-04 12:00:00
   */
  @SerializedName("approve_pass_time")
  private String approvePassTime;
  /**
   * 审批申请时间，时间格式为 yyyy-MM-dd HH:mm:ss
   * <p> 示例值：2021-01-04 11:00:00
   */
  @SerializedName("approve_apply_time")
  private String approveApplyTime;

  // builder 开始
  public UserTrip() {
  }

  public UserTrip(Builder builder) {
    /**
     * 审批实例 ID
     * <p> 示例值：6737202939523236113
     */
    this.approvalId = builder.approvalId;
    /**
     * 开始时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 09:00:00
     */
    this.startTime = builder.startTime;
    /**
     * 结束时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 19:00:00
     */
    this.endTime = builder.endTime;
    /**
     * 出差理由
     * <p> 示例值：培训
     */
    this.reason = builder.reason;
    /**
     * 审批通过时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 12:00:00
     */
    this.approvePassTime = builder.approvePassTime;
    /**
     * 审批申请时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 11:00:00
     */
    this.approveApplyTime = builder.approveApplyTime;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getApprovalId() {
    return this.approvalId;
  }

  public void setApprovalId(String approvalId) {
    this.approvalId = approvalId;
  }

  public String getStartTime() {
    return this.startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public String getEndTime() {
    return this.endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public String getReason() {
    return this.reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public String getApprovePassTime() {
    return this.approvePassTime;
  }

  public void setApprovePassTime(String approvePassTime) {
    this.approvePassTime = approvePassTime;
  }

  public String getApproveApplyTime() {
    return this.approveApplyTime;
  }

  public void setApproveApplyTime(String approveApplyTime) {
    this.approveApplyTime = approveApplyTime;
  }

  public static class Builder {

    /**
     * 审批实例 ID
     * <p> 示例值：6737202939523236113
     */
    private String approvalId;
    /**
     * 开始时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 09:00:00
     */
    private String startTime;
    /**
     * 结束时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 19:00:00
     */
    private String endTime;
    /**
     * 出差理由
     * <p> 示例值：培训
     */
    private String reason;
    /**
     * 审批通过时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 12:00:00
     */
    private String approvePassTime;
    /**
     * 审批申请时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 11:00:00
     */
    private String approveApplyTime;

    /**
     * 审批实例 ID
     * <p> 示例值：6737202939523236113
     *
     * @param approvalId
     * @return
     */
    public Builder approvalId(String approvalId) {
      this.approvalId = approvalId;
      return this;
    }


    /**
     * 开始时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 09:00:00
     *
     * @param startTime
     * @return
     */
    public Builder startTime(String startTime) {
      this.startTime = startTime;
      return this;
    }


    /**
     * 结束时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 19:00:00
     *
     * @param endTime
     * @return
     */
    public Builder endTime(String endTime) {
      this.endTime = endTime;
      return this;
    }


    /**
     * 出差理由
     * <p> 示例值：培训
     *
     * @param reason
     * @return
     */
    public Builder reason(String reason) {
      this.reason = reason;
      return this;
    }


    /**
     * 审批通过时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 12:00:00
     *
     * @param approvePassTime
     * @return
     */
    public Builder approvePassTime(String approvePassTime) {
      this.approvePassTime = approvePassTime;
      return this;
    }


    /**
     * 审批申请时间，时间格式为 yyyy-MM-dd HH:mm:ss
     * <p> 示例值：2021-01-04 11:00:00
     *
     * @param approveApplyTime
     * @return
     */
    public Builder approveApplyTime(String approveApplyTime) {
      this.approveApplyTime = approveApplyTime;
      return this;
    }


    public UserTrip build() {
      return new UserTrip(this);
    }
  }
}
