// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.baike.v1.model;

import com.google.gson.annotations.SerializedName;

public class WordInfo {

  /**
   * 用户输入的总词汇量
   * <p> 示例值：
   */
  @SerializedName("input_total")
  private Integer inputTotal;
  /**
   * 用户输入的去重后的总词汇量
   * <p> 示例值：
   */
  @SerializedName("dedup_input_total")
  private Integer dedupInputTotal;
  /**
   * 时间区间内每一天发送的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
   * <p> 示例值：
   */
  @SerializedName("eachday_input")
  private Integer[] eachdayInput;
  /**
   * 时间区间内每一天发送的归一化去重后的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
   * <p> 示例值：
   */
  @SerializedName("eachday_dedup_input")
  private Integer[] eachdayDedupInput;
  /**
   * 发送的消息总数
   * <p> 示例值：
   */
  @SerializedName("send_message_total")
  private Integer sendMessageTotal;
  /**
   * 发送的英语消息总数
   * <p> 示例值：
   */
  @SerializedName("send_en_message_total")
  private Integer sendEnMessageTotal;
  /**
   * 接收消息的数量
   * <p> 示例值：
   */
  @SerializedName("receive_message_total")
  private Integer receiveMessageTotal;
  /**
   * 接收英文消息的数量
   * <p> 示例值：
   */
  @SerializedName("receive_en_message_total")
  private Integer receiveEnMessageTotal;
  /**
   * 历史总计英语词数（包含新增）
   * <p> 示例值：
   */
  @SerializedName("history_words_total")
  private Integer historyWordsTotal;
  /**
   * 新增英语词数
   * <p> 示例值：
   */
  @SerializedName("new_words_total")
  private Integer newWordsTotal;

  // builder 开始
  public WordInfo() {
  }

  public WordInfo(Builder builder) {
    /**
     * 用户输入的总词汇量
     * <p> 示例值：
     */
    this.inputTotal = builder.inputTotal;
    /**
     * 用户输入的去重后的总词汇量
     * <p> 示例值：
     */
    this.dedupInputTotal = builder.dedupInputTotal;
    /**
     * 时间区间内每一天发送的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     */
    this.eachdayInput = builder.eachdayInput;
    /**
     * 时间区间内每一天发送的归一化去重后的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     */
    this.eachdayDedupInput = builder.eachdayDedupInput;
    /**
     * 发送的消息总数
     * <p> 示例值：
     */
    this.sendMessageTotal = builder.sendMessageTotal;
    /**
     * 发送的英语消息总数
     * <p> 示例值：
     */
    this.sendEnMessageTotal = builder.sendEnMessageTotal;
    /**
     * 接收消息的数量
     * <p> 示例值：
     */
    this.receiveMessageTotal = builder.receiveMessageTotal;
    /**
     * 接收英文消息的数量
     * <p> 示例值：
     */
    this.receiveEnMessageTotal = builder.receiveEnMessageTotal;
    /**
     * 历史总计英语词数（包含新增）
     * <p> 示例值：
     */
    this.historyWordsTotal = builder.historyWordsTotal;
    /**
     * 新增英语词数
     * <p> 示例值：
     */
    this.newWordsTotal = builder.newWordsTotal;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Integer getInputTotal() {
    return this.inputTotal;
  }

  public void setInputTotal(Integer inputTotal) {
    this.inputTotal = inputTotal;
  }

  public Integer getDedupInputTotal() {
    return this.dedupInputTotal;
  }

  public void setDedupInputTotal(Integer dedupInputTotal) {
    this.dedupInputTotal = dedupInputTotal;
  }

  public Integer[] getEachdayInput() {
    return this.eachdayInput;
  }

  public void setEachdayInput(Integer[] eachdayInput) {
    this.eachdayInput = eachdayInput;
  }

  public Integer[] getEachdayDedupInput() {
    return this.eachdayDedupInput;
  }

  public void setEachdayDedupInput(Integer[] eachdayDedupInput) {
    this.eachdayDedupInput = eachdayDedupInput;
  }

  public Integer getSendMessageTotal() {
    return this.sendMessageTotal;
  }

  public void setSendMessageTotal(Integer sendMessageTotal) {
    this.sendMessageTotal = sendMessageTotal;
  }

  public Integer getSendEnMessageTotal() {
    return this.sendEnMessageTotal;
  }

  public void setSendEnMessageTotal(Integer sendEnMessageTotal) {
    this.sendEnMessageTotal = sendEnMessageTotal;
  }

  public Integer getReceiveMessageTotal() {
    return this.receiveMessageTotal;
  }

  public void setReceiveMessageTotal(Integer receiveMessageTotal) {
    this.receiveMessageTotal = receiveMessageTotal;
  }

  public Integer getReceiveEnMessageTotal() {
    return this.receiveEnMessageTotal;
  }

  public void setReceiveEnMessageTotal(Integer receiveEnMessageTotal) {
    this.receiveEnMessageTotal = receiveEnMessageTotal;
  }

  public Integer getHistoryWordsTotal() {
    return this.historyWordsTotal;
  }

  public void setHistoryWordsTotal(Integer historyWordsTotal) {
    this.historyWordsTotal = historyWordsTotal;
  }

  public Integer getNewWordsTotal() {
    return this.newWordsTotal;
  }

  public void setNewWordsTotal(Integer newWordsTotal) {
    this.newWordsTotal = newWordsTotal;
  }

  public static class Builder {

    /**
     * 用户输入的总词汇量
     * <p> 示例值：
     */
    private Integer inputTotal;
    /**
     * 用户输入的去重后的总词汇量
     * <p> 示例值：
     */
    private Integer dedupInputTotal;
    /**
     * 时间区间内每一天发送的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     */
    private Integer[] eachdayInput;
    /**
     * 时间区间内每一天发送的归一化去重后的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     */
    private Integer[] eachdayDedupInput;
    /**
     * 发送的消息总数
     * <p> 示例值：
     */
    private Integer sendMessageTotal;
    /**
     * 发送的英语消息总数
     * <p> 示例值：
     */
    private Integer sendEnMessageTotal;
    /**
     * 接收消息的数量
     * <p> 示例值：
     */
    private Integer receiveMessageTotal;
    /**
     * 接收英文消息的数量
     * <p> 示例值：
     */
    private Integer receiveEnMessageTotal;
    /**
     * 历史总计英语词数（包含新增）
     * <p> 示例值：
     */
    private Integer historyWordsTotal;
    /**
     * 新增英语词数
     * <p> 示例值：
     */
    private Integer newWordsTotal;

    /**
     * 用户输入的总词汇量
     * <p> 示例值：
     *
     * @param inputTotal
     * @return
     */
    public Builder inputTotal(Integer inputTotal) {
      this.inputTotal = inputTotal;
      return this;
    }


    /**
     * 用户输入的去重后的总词汇量
     * <p> 示例值：
     *
     * @param dedupInputTotal
     * @return
     */
    public Builder dedupInputTotal(Integer dedupInputTotal) {
      this.dedupInputTotal = dedupInputTotal;
      return this;
    }


    /**
     * 时间区间内每一天发送的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     *
     * @param eachdayInput
     * @return
     */
    public Builder eachdayInput(Integer[] eachdayInput) {
      this.eachdayInput = eachdayInput;
      return this;
    }


    /**
     * 时间区间内每一天发送的归一化去重后的英文词数，时间是由远到近。以七天数据为例：下标6为昨天，下标5位前天以此类推
     * <p> 示例值：
     *
     * @param eachdayDedupInput
     * @return
     */
    public Builder eachdayDedupInput(Integer[] eachdayDedupInput) {
      this.eachdayDedupInput = eachdayDedupInput;
      return this;
    }


    /**
     * 发送的消息总数
     * <p> 示例值：
     *
     * @param sendMessageTotal
     * @return
     */
    public Builder sendMessageTotal(Integer sendMessageTotal) {
      this.sendMessageTotal = sendMessageTotal;
      return this;
    }


    /**
     * 发送的英语消息总数
     * <p> 示例值：
     *
     * @param sendEnMessageTotal
     * @return
     */
    public Builder sendEnMessageTotal(Integer sendEnMessageTotal) {
      this.sendEnMessageTotal = sendEnMessageTotal;
      return this;
    }


    /**
     * 接收消息的数量
     * <p> 示例值：
     *
     * @param receiveMessageTotal
     * @return
     */
    public Builder receiveMessageTotal(Integer receiveMessageTotal) {
      this.receiveMessageTotal = receiveMessageTotal;
      return this;
    }


    /**
     * 接收英文消息的数量
     * <p> 示例值：
     *
     * @param receiveEnMessageTotal
     * @return
     */
    public Builder receiveEnMessageTotal(Integer receiveEnMessageTotal) {
      this.receiveEnMessageTotal = receiveEnMessageTotal;
      return this;
    }


    /**
     * 历史总计英语词数（包含新增）
     * <p> 示例值：
     *
     * @param historyWordsTotal
     * @return
     */
    public Builder historyWordsTotal(Integer historyWordsTotal) {
      this.historyWordsTotal = historyWordsTotal;
      return this;
    }


    /**
     * 新增英语词数
     * <p> 示例值：
     *
     * @param newWordsTotal
     * @return
     */
    public Builder newWordsTotal(Integer newWordsTotal) {
      this.newWordsTotal = newWordsTotal;
      return this;
    }


    public WordInfo build() {
      return new WordInfo(this);
    }
  }
}
