// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.docx.v1.model.BatchDeleteDocumentBlockChildrenReq;
import com.lark.oapi.service.docx.v1.model.BatchDeleteDocumentBlockChildrenResp;
import com.lark.oapi.service.docx.v1.model.BatchUpdateDocumentBlockReq;
import com.lark.oapi.service.docx.v1.model.BatchUpdateDocumentBlockResp;
import com.lark.oapi.service.docx.v1.model.CreateDocumentBlockChildrenReq;
import com.lark.oapi.service.docx.v1.model.CreateDocumentBlockChildrenResp;
import com.lark.oapi.service.docx.v1.model.CreateDocumentReq;
import com.lark.oapi.service.docx.v1.model.CreateDocumentResp;
import com.lark.oapi.service.docx.v1.model.GetDocumentBlockChildrenReq;
import com.lark.oapi.service.docx.v1.model.GetDocumentBlockChildrenResp;
import com.lark.oapi.service.docx.v1.model.GetDocumentBlockReq;
import com.lark.oapi.service.docx.v1.model.GetDocumentBlockResp;
import com.lark.oapi.service.docx.v1.model.GetDocumentReq;
import com.lark.oapi.service.docx.v1.model.GetDocumentResp;
import com.lark.oapi.service.docx.v1.model.ListDocumentBlockReq;
import com.lark.oapi.service.docx.v1.model.ListDocumentBlockResp;
import com.lark.oapi.service.docx.v1.model.PatchDocumentBlockReq;
import com.lark.oapi.service.docx.v1.model.PatchDocumentBlockResp;
import com.lark.oapi.service.docx.v1.model.RawContentDocumentReq;
import com.lark.oapi.service.docx.v1.model.RawContentDocumentResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxService {

  private static final Logger log = LoggerFactory.getLogger(DocxService.class);
  private final Document document; // 文档
  private final DocumentBlock documentBlock; // 块
  private final DocumentBlockChildren documentBlockChildren; // document.block.children

  public DocxService(Config config) {
    this.document = new Document(config);
    this.documentBlock = new DocumentBlock(config);
    this.documentBlockChildren = new DocumentBlockChildren(config);
  }

  /**
   * 文档
   *
   * @return
   */
  public Document document() {
    return document;
  }

  /**
   * 块
   *
   * @return
   */
  public DocumentBlock documentBlock() {
    return documentBlock;
  }

  /**
   * document.block.children
   *
   * @return
   */
  public DocumentBlockChildren documentBlockChildren() {
    return documentBlockChildren;
  }

  public static class Document {

    private final Config config;

    public Document(Config config) {
      this.config = config;
    }

    /**
     * 创建文档，创建新版文档，文档标题和目录可选。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnyoyCgwS8ywWwMtQr9yjZ2f)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/create">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentSample.java</a>
     * ;
     */
    public CreateDocumentResp create(CreateDocumentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/docx/v1/documents"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建文档，创建新版文档，文档标题和目录可选。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnyoyCgwS8ywWwMtQr9yjZ2f)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/create">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentSample.java</a>
     * ;
     */
    public CreateDocumentResp create(CreateDocumentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/docx/v1/documents"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档基本信息，获取文档最新版本号、标题等
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnWKAE4aSaIU4GcdLInSaVde)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentSample.java</a>
     * ;
     */
    public GetDocumentResp get(GetDocumentReq req, RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档基本信息，获取文档最新版本号、标题等
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnWKAE4aSaIU4GcdLInSaVde)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentSample.java</a>
     * ;
     */
    public GetDocumentResp get(GetDocumentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档纯文本内容，获取文档的纯文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnQeqI4wiKIMis6GNvCOBuqg)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/raw_content">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/raw_content</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/RawContentDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/RawContentDocumentSample.java</a>
     * ;
     */
    public RawContentDocumentResp rawContent(RawContentDocumentReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/raw_content"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      RawContentDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          RawContentDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/raw_content"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档纯文本内容，获取文档的纯文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnQeqI4wiKIMis6GNvCOBuqg)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/raw_content">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document/raw_content</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/RawContentDocumentSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/RawContentDocumentSample.java</a>
     * ;
     */
    public RawContentDocumentResp rawContent(RawContentDocumentReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/raw_content"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      RawContentDocumentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          RawContentDocumentResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/raw_content"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class DocumentBlock {

    private final Config config;

    public DocumentBlock(Config config) {
      this.config = config;
    }

    /**
     * 批量更新块，批量更新块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnMiwAKCiE6oQEkPyhvmmQEe)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/batch_update">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/batch_update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchUpdateDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchUpdateDocumentBlockSample.java</a>
     * ;
     */
    public BatchUpdateDocumentBlockResp batchUpdate(BatchUpdateDocumentBlockReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/docx/v1/documents/:document_id/blocks/batch_update"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchUpdateDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchUpdateDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/batch_update"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 批量更新块，批量更新块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnMiwAKCiE6oQEkPyhvmmQEe)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/batch_update">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/batch_update</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchUpdateDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchUpdateDocumentBlockSample.java</a>
     * ;
     */
    public BatchUpdateDocumentBlockResp batchUpdate(BatchUpdateDocumentBlockReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/docx/v1/documents/:document_id/blocks/batch_update"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchUpdateDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchUpdateDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/batch_update"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取块，获取指定块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnamKaccZKqIMopnREJCZUMe#doxcnWEMWYAg2YMkEq0SZXHzaih)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockSample.java</a>
     * ;
     */
    public GetDocumentBlockResp get(GetDocumentBlockReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取块，获取指定块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnamKaccZKqIMopnREJCZUMe#doxcnWEMWYAg2YMkEq0SZXHzaih)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockSample.java</a>
     * ;
     */
    public GetDocumentBlockResp get(GetDocumentBlockReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档所有块，获取文档所有块的富文本内容并分页返回。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnamKaccZKqIMopnREJCZUMe#doxcn6AkCE2AUUm2WwxID7lS7Xc)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/list">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/ListDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/ListDocumentBlockSample.java</a>
     * ;
     */
    public ListDocumentBlockResp list(ListDocumentBlockReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取文档所有块，获取文档所有块的富文本内容并分页返回。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnamKaccZKqIMopnREJCZUMe#doxcn6AkCE2AUUm2WwxID7lS7Xc)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/list">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/list</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/ListDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/ListDocumentBlockSample.java</a>
     * ;
     */
    public ListDocumentBlockResp list(ListDocumentBlockReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      ListDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          ListDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新块，更新指定的块。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnEeyS0I8MMqoieIMpK7jm8g)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/patch">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/PatchDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/PatchDocumentBlockSample.java</a>
     * ;
     */
    public PatchDocumentBlockResp patch(PatchDocumentBlockReq req, RequestOptions reqOptions)
        throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 更新块，更新指定的块。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnEeyS0I8MMqoieIMpK7jm8g)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/patch">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block/patch</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/PatchDocumentBlockSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/PatchDocumentBlockSample.java</a>
     * ;
     */
    public PatchDocumentBlockResp patch(PatchDocumentBlockReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      PatchDocumentBlockResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          PatchDocumentBlockResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

  public static class DocumentBlockChildren {

    private final Config config;

    public DocumentBlockChildren(Config config) {
      this.config = config;
    }

    /**
     * 删除块，指定需要操作的块，删除其指定范围的子块。如果操作成功，接口将返回应用删除操作后的文档版本号。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcngCsscGk0WacO258mYDgM6b)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/batch_delete">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/batch_delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchDeleteDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchDeleteDocumentBlockChildrenSample.java</a>
     * ;
     */
    public BatchDeleteDocumentBlockChildrenResp batchDelete(BatchDeleteDocumentBlockChildrenReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children/batch_delete"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 删除块，指定需要操作的块，删除其指定范围的子块。如果操作成功，接口将返回应用删除操作后的文档版本号。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcngCsscGk0WacO258mYDgM6b)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/batch_delete">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/batch_delete</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchDeleteDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/BatchDeleteDocumentBlockChildrenSample.java</a>
     * ;
     */
    public BatchDeleteDocumentBlockChildrenResp batchDelete(BatchDeleteDocumentBlockChildrenReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children/batch_delete"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      BatchDeleteDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          BatchDeleteDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children/batch_delete"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建块，指定需要操作的块，为其创建一批子块，并插入到指定位置。如果操作成功，接口将返回新创建子块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnm0ooUe0s20GwwVB3a05rtb)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/create">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentBlockChildrenSample.java</a>
     * ;
     */
    public CreateDocumentBlockChildrenResp create(CreateDocumentBlockChildrenReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 创建块，指定需要操作的块，为其创建一批子块，并插入到指定位置。如果操作成功，接口将返回新创建子块的富文本内容。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnm0ooUe0s20GwwVB3a05rtb)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 3 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/create">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/create</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/CreateDocumentBlockChildrenSample.java</a>
     * ;
     */
    public CreateDocumentBlockChildrenResp create(CreateDocumentBlockChildrenReq req)
        throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      CreateDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          CreateDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取所有子块，给定一个指定版本的文档，并指定需要操作的块，分页遍历其所有子块富文本内容 。如果不指定版本，则会默认查询最新版本。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnE2UK2yY0gEGK8nBMPtB0vd)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockChildrenSample.java</a>
     * ;
     */
    public GetDocumentBlockChildrenResp get(GetDocumentBlockChildrenReq req,
        RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }

    /**
     * 获取所有子块，给定一个指定版本的文档，并指定需要操作的块，分页遍历其所有子块富文本内容 。如果不指定版本，则会默认查询最新版本。
     * <p> 在调用此接口前，请仔细阅读[新版文档 OpenAPI 接口校验规则](https://bytedance.feishu.cn/docx/doxcnby5Y0yoACL3PdfZqrJEm6f#doxcnE2UK2yY0gEGK8nBMPtB0vd)，了解相关规则及约束。
     * ;
     * <p> 频率限制：单个应用调用频率上限为每秒 5 次。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/get">https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/document-docx/docx-v1/document-block-children/get</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockChildrenSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/docxv1/GetDocumentBlockChildrenSample.java</a>
     * ;
     */
    public GetDocumentBlockChildrenResp get(GetDocumentBlockChildrenReq req) throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
          , Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User)
          , req);

      // 反序列化
      GetDocumentBlockChildrenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse,
          GetDocumentBlockChildrenResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/docx/v1/documents/:document_id/blocks/:block_id/children"
            , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));
        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      resp.setRequest(req);

      return resp;
    }
  }

}