// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.google.gson.annotations.SerializedName;

public class ObjectiveIdWithKrId {

  /**
   * OKR 中 Objective 的 ID
   * <p> 示例值：7109022409227026460
   */
  @SerializedName("objective_id")
  private String objectiveId;
  /**
   * Key Result 的 ID 列表，此值为空时插入当前 Objective 下的所有 Key Result
   * <p> 示例值：["7109022573011894300","7109022546444517404"]
   */
  @SerializedName("kr_ids")
  private String[] krIds;

  // builder 开始
  public ObjectiveIdWithKrId() {
  }

  public ObjectiveIdWithKrId(Builder builder) {
    /**
     * OKR 中 Objective 的 ID
     * <p> 示例值：7109022409227026460
     */
    this.objectiveId = builder.objectiveId;
    /**
     * Key Result 的 ID 列表，此值为空时插入当前 Objective 下的所有 Key Result
     * <p> 示例值：["7109022573011894300","7109022546444517404"]
     */
    this.krIds = builder.krIds;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getObjectiveId() {
    return this.objectiveId;
  }

  public void setObjectiveId(String objectiveId) {
    this.objectiveId = objectiveId;
  }

  public String[] getKrIds() {
    return this.krIds;
  }

  public void setKrIds(String[] krIds) {
    this.krIds = krIds;
  }

  public static class Builder {

    /**
     * OKR 中 Objective 的 ID
     * <p> 示例值：7109022409227026460
     */
    private String objectiveId;
    /**
     * Key Result 的 ID 列表，此值为空时插入当前 Objective 下的所有 Key Result
     * <p> 示例值：["7109022573011894300","7109022546444517404"]
     */
    private String[] krIds;

    /**
     * OKR 中 Objective 的 ID
     * <p> 示例值：7109022409227026460
     *
     * @param objectiveId
     * @return
     */
    public Builder objectiveId(String objectiveId) {
      this.objectiveId = objectiveId;
      return this;
    }


    /**
     * Key Result 的 ID 列表，此值为空时插入当前 Objective 下的所有 Key Result
     * <p> 示例值：["7109022573011894300","7109022546444517404"]
     *
     * @param krIds
     * @return
     */
    public Builder krIds(String[] krIds) {
      this.krIds = krIds;
      return this;
    }


    public ObjectiveIdWithKrId build() {
      return new ObjectiveIdWithKrId(this);
    }
  }
}
