// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.google.gson.annotations.SerializedName;

public class OkrProgressRate {

  /**
   * 状态模式
   * <p> 示例值："simple"
   */
  @SerializedName("mode")
  private String mode;
  /**
   * 当前进度, advanced 模式使用
   * <p> 示例值：0
   */
  @SerializedName("current")
  private Double current;
  /**
   * 当前进度百分比，simple 模式使用
   * <p> 示例值：100
   */
  @SerializedName("percent")
  private Double percent;
  /**
   * 进展状态
   * <p> 示例值："normal"
   */
  @SerializedName("progress_status")
  private String progressStatus;
  /**
   * 进度起始值，advanced 模式使用
   * <p> 示例值：0
   */
  @SerializedName("start")
  private Double start;
  /**
   * 状态计算类型
   * <p> 示例值："default"
   */
  @SerializedName("status_type")
  private String statusType;
  /**
   * 进度目标值，advanced 模式使用
   * <p> 示例值：
   */
  @SerializedName("target")
  private Double target;

  // builder 开始
  public OkrProgressRate() {
  }

  public OkrProgressRate(Builder builder) {
    /**
     * 状态模式
     * <p> 示例值："simple"
     */
    this.mode = builder.mode;
    /**
     * 当前进度, advanced 模式使用
     * <p> 示例值：0
     */
    this.current = builder.current;
    /**
     * 当前进度百分比，simple 模式使用
     * <p> 示例值：100
     */
    this.percent = builder.percent;
    /**
     * 进展状态
     * <p> 示例值："normal"
     */
    this.progressStatus = builder.progressStatus;
    /**
     * 进度起始值，advanced 模式使用
     * <p> 示例值：0
     */
    this.start = builder.start;
    /**
     * 状态计算类型
     * <p> 示例值："default"
     */
    this.statusType = builder.statusType;
    /**
     * 进度目标值，advanced 模式使用
     * <p> 示例值：
     */
    this.target = builder.target;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getMode() {
    return this.mode;
  }

  public void setMode(String mode) {
    this.mode = mode;
  }

  public Double getCurrent() {
    return this.current;
  }

  public void setCurrent(Double current) {
    this.current = current;
  }

  public Double getPercent() {
    return this.percent;
  }

  public void setPercent(Double percent) {
    this.percent = percent;
  }

  public String getProgressStatus() {
    return this.progressStatus;
  }

  public void setProgressStatus(String progressStatus) {
    this.progressStatus = progressStatus;
  }

  public Double getStart() {
    return this.start;
  }

  public void setStart(Double start) {
    this.start = start;
  }

  public String getStatusType() {
    return this.statusType;
  }

  public void setStatusType(String statusType) {
    this.statusType = statusType;
  }

  public Double getTarget() {
    return this.target;
  }

  public void setTarget(Double target) {
    this.target = target;
  }

  public static class Builder {

    /**
     * 状态模式
     * <p> 示例值："simple"
     */
    private String mode;
    /**
     * 当前进度, advanced 模式使用
     * <p> 示例值：0
     */
    private Double current;
    /**
     * 当前进度百分比，simple 模式使用
     * <p> 示例值：100
     */
    private Double percent;
    /**
     * 进展状态
     * <p> 示例值："normal"
     */
    private String progressStatus;
    /**
     * 进度起始值，advanced 模式使用
     * <p> 示例值：0
     */
    private Double start;
    /**
     * 状态计算类型
     * <p> 示例值："default"
     */
    private String statusType;
    /**
     * 进度目标值，advanced 模式使用
     * <p> 示例值：
     */
    private Double target;

    /**
     * 状态模式
     * <p> 示例值："simple"
     *
     * @param mode
     * @return
     */
    public Builder mode(String mode) {
      this.mode = mode;
      return this;
    }

    /**
     * 状态模式
     * <p> 示例值："simple"
     *
     * @param mode {@link com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressRateModeEnum}
     * @return
     */
    public Builder mode(
        com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressRateModeEnum mode) {
      this.mode = mode.getValue();
      return this;
    }


    /**
     * 当前进度, advanced 模式使用
     * <p> 示例值：0
     *
     * @param current
     * @return
     */
    public Builder current(Double current) {
      this.current = current;
      return this;
    }


    /**
     * 当前进度百分比，simple 模式使用
     * <p> 示例值：100
     *
     * @param percent
     * @return
     */
    public Builder percent(Double percent) {
      this.percent = percent;
      return this;
    }


    /**
     * 进展状态
     * <p> 示例值："normal"
     *
     * @param progressStatus
     * @return
     */
    public Builder progressStatus(String progressStatus) {
      this.progressStatus = progressStatus;
      return this;
    }

    /**
     * 进展状态
     * <p> 示例值："normal"
     *
     * @param progressStatus {@link com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressStatusEnum}
     * @return
     */
    public Builder progressStatus(
        com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressStatusEnum progressStatus) {
      this.progressStatus = progressStatus.getValue();
      return this;
    }


    /**
     * 进度起始值，advanced 模式使用
     * <p> 示例值：0
     *
     * @param start
     * @return
     */
    public Builder start(Double start) {
      this.start = start;
      return this;
    }


    /**
     * 状态计算类型
     * <p> 示例值："default"
     *
     * @param statusType
     * @return
     */
    public Builder statusType(String statusType) {
      this.statusType = statusType;
      return this;
    }

    /**
     * 状态计算类型
     * <p> 示例值："default"
     *
     * @param statusType {@link com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressStatusTypeEnum}
     * @return
     */
    public Builder statusType(
        com.lark.oapi.service.docx.v1.enums.OkrProgressRateOkrProgressStatusTypeEnum statusType) {
      this.statusType = statusType.getValue();
      return this;
    }


    /**
     * 进度目标值，advanced 模式使用
     * <p> 示例值：
     *
     * @param target
     * @return
     */
    public Builder target(Double target) {
      this.target = target;
      return this;
    }


    public OkrProgressRate build() {
      return new OkrProgressRate(this);
    }
  }
}
