// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.face_detection.v1.model;

import com.google.gson.annotations.SerializedName;

public class FacePosition {

  /**
   * 人脸框的左上角坐标
   * <p> 示例值：
   */
  @SerializedName("upper_left")
  private Point upperLeft;
  /**
   * 人脸框的右下角坐标
   * <p> 示例值：
   */
  @SerializedName("lower_right")
  private Point lowerRight;

  // builder 开始
  public FacePosition() {
  }

  public FacePosition(Builder builder) {
    /**
     * 人脸框的左上角坐标
     * <p> 示例值：
     */
    this.upperLeft = builder.upperLeft;
    /**
     * 人脸框的右下角坐标
     * <p> 示例值：
     */
    this.lowerRight = builder.lowerRight;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Point getUpperLeft() {
    return this.upperLeft;
  }

  public void setUpperLeft(Point upperLeft) {
    this.upperLeft = upperLeft;
  }

  public Point getLowerRight() {
    return this.lowerRight;
  }

  public void setLowerRight(Point lowerRight) {
    this.lowerRight = lowerRight;
  }

  public static class Builder {

    /**
     * 人脸框的左上角坐标
     * <p> 示例值：
     */
    private Point upperLeft;
    /**
     * 人脸框的右下角坐标
     * <p> 示例值：
     */
    private Point lowerRight;

    /**
     * 人脸框的左上角坐标
     * <p> 示例值：
     *
     * @param upperLeft
     * @return
     */
    public Builder upperLeft(Point upperLeft) {
      this.upperLeft = upperLeft;
      return this;
    }


    /**
     * 人脸框的右下角坐标
     * <p> 示例值：
     *
     * @param lowerRight
     * @return
     */
    public Builder lowerRight(Point lowerRight) {
      this.lowerRight = lowerRight;
      return this;
    }


    public FacePosition build() {
      return new FacePosition(this);
    }
  }
}
