// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;

import com.google.gson.annotations.SerializedName;

public class ChatChange {

  /**
   * 群头像
   * <p> 示例值：default-avatar_0cda3662-875a-4354-94d2-83e7393c7123
   */
  @SerializedName("avatar")
  private String avatar;
  /**
   * 群名称
   * <p> 示例值：群名称测试
   */
  @SerializedName("name")
  private String name;
  /**
   * 群描述
   * <p> 示例值：群描述测试
   */
  @SerializedName("description")
  private String description;
  /**
   * 群国际化名称
   * <p> 示例值：
   */
  @SerializedName("i18n_names")
  private I18nNames i18nNames;
  /**
   * 加人入群权限(all_members/only_owner/unknown)
   * <p> 示例值：all_members
   */
  @SerializedName("add_member_permission")
  private String addMemberPermission;
  /**
   * 群分享权限(allowed/not_allowed/unknown)
   * <p> 示例值：allowed
   */
  @SerializedName("share_card_permission")
  private String shareCardPermission;
  /**
   * at 所有人权限(all_members/only_owner/unknown)
   * <p> 示例值：only_owner
   */
  @SerializedName("at_all_permission")
  private String atAllPermission;
  /**
   * 群编辑权限(all_members/only_owner/unknown)
   * <p> 示例值：all_members
   */
  @SerializedName("edit_permission")
  private String editPermission;
  /**
   * 加群审批(no_approval_required/approval_required)
   * <p> 示例值：approval_required
   */
  @SerializedName("membership_approval")
  private String membershipApproval;
  /**
   * 入群消息可见性(only_owner/all_members/not_anyone)
   * <p> 示例值：all_members
   */
  @SerializedName("join_message_visibility")
  private String joinMessageVisibility;
  /**
   * 出群消息可见性(only_owner/all_members/not_anyone)
   * <p> 示例值：all_members
   */
  @SerializedName("leave_message_visibility")
  private String leaveMessageVisibility;
  /**
   * 发言权限(all_members/only_owner)
   * <p> 示例值：all_members
   */
  @SerializedName("moderation_permission")
  private String moderationPermission;
  /**
   * 用户 ID
   * <p> 示例值：
   */
  @SerializedName("owner_id")
  private UserId ownerId;

  // builder 开始
  public ChatChange() {
  }

  public ChatChange(Builder builder) {
    /**
     * 群头像
     * <p> 示例值：default-avatar_0cda3662-875a-4354-94d2-83e7393c7123
     */
    this.avatar = builder.avatar;
    /**
     * 群名称
     * <p> 示例值：群名称测试
     */
    this.name = builder.name;
    /**
     * 群描述
     * <p> 示例值：群描述测试
     */
    this.description = builder.description;
    /**
     * 群国际化名称
     * <p> 示例值：
     */
    this.i18nNames = builder.i18nNames;
    /**
     * 加人入群权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     */
    this.addMemberPermission = builder.addMemberPermission;
    /**
     * 群分享权限(allowed/not_allowed/unknown)
     * <p> 示例值：allowed
     */
    this.shareCardPermission = builder.shareCardPermission;
    /**
     * at 所有人权限(all_members/only_owner/unknown)
     * <p> 示例值：only_owner
     */
    this.atAllPermission = builder.atAllPermission;
    /**
     * 群编辑权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     */
    this.editPermission = builder.editPermission;
    /**
     * 加群审批(no_approval_required/approval_required)
     * <p> 示例值：approval_required
     */
    this.membershipApproval = builder.membershipApproval;
    /**
     * 入群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     */
    this.joinMessageVisibility = builder.joinMessageVisibility;
    /**
     * 出群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     */
    this.leaveMessageVisibility = builder.leaveMessageVisibility;
    /**
     * 发言权限(all_members/only_owner)
     * <p> 示例值：all_members
     */
    this.moderationPermission = builder.moderationPermission;
    /**
     * 用户 ID
     * <p> 示例值：
     */
    this.ownerId = builder.ownerId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getAvatar() {
    return this.avatar;
  }

  public void setAvatar(String avatar) {
    this.avatar = avatar;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public I18nNames getI18nNames() {
    return this.i18nNames;
  }

  public void setI18nNames(I18nNames i18nNames) {
    this.i18nNames = i18nNames;
  }

  public String getAddMemberPermission() {
    return this.addMemberPermission;
  }

  public void setAddMemberPermission(String addMemberPermission) {
    this.addMemberPermission = addMemberPermission;
  }

  public String getShareCardPermission() {
    return this.shareCardPermission;
  }

  public void setShareCardPermission(String shareCardPermission) {
    this.shareCardPermission = shareCardPermission;
  }

  public String getAtAllPermission() {
    return this.atAllPermission;
  }

  public void setAtAllPermission(String atAllPermission) {
    this.atAllPermission = atAllPermission;
  }

  public String getEditPermission() {
    return this.editPermission;
  }

  public void setEditPermission(String editPermission) {
    this.editPermission = editPermission;
  }

  public String getMembershipApproval() {
    return this.membershipApproval;
  }

  public void setMembershipApproval(String membershipApproval) {
    this.membershipApproval = membershipApproval;
  }

  public String getJoinMessageVisibility() {
    return this.joinMessageVisibility;
  }

  public void setJoinMessageVisibility(String joinMessageVisibility) {
    this.joinMessageVisibility = joinMessageVisibility;
  }

  public String getLeaveMessageVisibility() {
    return this.leaveMessageVisibility;
  }

  public void setLeaveMessageVisibility(String leaveMessageVisibility) {
    this.leaveMessageVisibility = leaveMessageVisibility;
  }

  public String getModerationPermission() {
    return this.moderationPermission;
  }

  public void setModerationPermission(String moderationPermission) {
    this.moderationPermission = moderationPermission;
  }

  public UserId getOwnerId() {
    return this.ownerId;
  }

  public void setOwnerId(UserId ownerId) {
    this.ownerId = ownerId;
  }

  public static class Builder {

    /**
     * 群头像
     * <p> 示例值：default-avatar_0cda3662-875a-4354-94d2-83e7393c7123
     */
    private String avatar;
    /**
     * 群名称
     * <p> 示例值：群名称测试
     */
    private String name;
    /**
     * 群描述
     * <p> 示例值：群描述测试
     */
    private String description;
    /**
     * 群国际化名称
     * <p> 示例值：
     */
    private I18nNames i18nNames;
    /**
     * 加人入群权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     */
    private String addMemberPermission;
    /**
     * 群分享权限(allowed/not_allowed/unknown)
     * <p> 示例值：allowed
     */
    private String shareCardPermission;
    /**
     * at 所有人权限(all_members/only_owner/unknown)
     * <p> 示例值：only_owner
     */
    private String atAllPermission;
    /**
     * 群编辑权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     */
    private String editPermission;
    /**
     * 加群审批(no_approval_required/approval_required)
     * <p> 示例值：approval_required
     */
    private String membershipApproval;
    /**
     * 入群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     */
    private String joinMessageVisibility;
    /**
     * 出群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     */
    private String leaveMessageVisibility;
    /**
     * 发言权限(all_members/only_owner)
     * <p> 示例值：all_members
     */
    private String moderationPermission;
    /**
     * 用户 ID
     * <p> 示例值：
     */
    private UserId ownerId;

    /**
     * 群头像
     * <p> 示例值：default-avatar_0cda3662-875a-4354-94d2-83e7393c7123
     *
     * @param avatar
     * @return
     */
    public Builder avatar(String avatar) {
      this.avatar = avatar;
      return this;
    }


    /**
     * 群名称
     * <p> 示例值：群名称测试
     *
     * @param name
     * @return
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }


    /**
     * 群描述
     * <p> 示例值：群描述测试
     *
     * @param description
     * @return
     */
    public Builder description(String description) {
      this.description = description;
      return this;
    }


    /**
     * 群国际化名称
     * <p> 示例值：
     *
     * @param i18nNames
     * @return
     */
    public Builder i18nNames(I18nNames i18nNames) {
      this.i18nNames = i18nNames;
      return this;
    }


    /**
     * 加人入群权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     *
     * @param addMemberPermission
     * @return
     */
    public Builder addMemberPermission(String addMemberPermission) {
      this.addMemberPermission = addMemberPermission;
      return this;
    }


    /**
     * 群分享权限(allowed/not_allowed/unknown)
     * <p> 示例值：allowed
     *
     * @param shareCardPermission
     * @return
     */
    public Builder shareCardPermission(String shareCardPermission) {
      this.shareCardPermission = shareCardPermission;
      return this;
    }


    /**
     * at 所有人权限(all_members/only_owner/unknown)
     * <p> 示例值：only_owner
     *
     * @param atAllPermission
     * @return
     */
    public Builder atAllPermission(String atAllPermission) {
      this.atAllPermission = atAllPermission;
      return this;
    }


    /**
     * 群编辑权限(all_members/only_owner/unknown)
     * <p> 示例值：all_members
     *
     * @param editPermission
     * @return
     */
    public Builder editPermission(String editPermission) {
      this.editPermission = editPermission;
      return this;
    }


    /**
     * 加群审批(no_approval_required/approval_required)
     * <p> 示例值：approval_required
     *
     * @param membershipApproval
     * @return
     */
    public Builder membershipApproval(String membershipApproval) {
      this.membershipApproval = membershipApproval;
      return this;
    }


    /**
     * 入群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     *
     * @param joinMessageVisibility
     * @return
     */
    public Builder joinMessageVisibility(String joinMessageVisibility) {
      this.joinMessageVisibility = joinMessageVisibility;
      return this;
    }


    /**
     * 出群消息可见性(only_owner/all_members/not_anyone)
     * <p> 示例值：all_members
     *
     * @param leaveMessageVisibility
     * @return
     */
    public Builder leaveMessageVisibility(String leaveMessageVisibility) {
      this.leaveMessageVisibility = leaveMessageVisibility;
      return this;
    }


    /**
     * 发言权限(all_members/only_owner)
     * <p> 示例值：all_members
     *
     * @param moderationPermission
     * @return
     */
    public Builder moderationPermission(String moderationPermission) {
      this.moderationPermission = moderationPermission;
      return this;
    }


    /**
     * 用户 ID
     * <p> 示例值：
     *
     * @param ownerId
     * @return
     */
    public Builder ownerId(UserId ownerId) {
      this.ownerId = ownerId;
      return this;
    }


    public ChatChange build() {
      return new ChatChange(this);
    }
  }
}
