// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;

import com.google.gson.annotations.SerializedName;

public class Pin {

  /**
   * Pin的消息ID
   * <p> 示例值：om_dc13264520392913993dd051dba21dcf
   */
  @SerializedName("message_id")
  private String messageId;
  /**
   * Pin消息所在的群聊ID
   * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
   */
  @SerializedName("chat_id")
  private String chatId;
  /**
   * Pin的操作人ID
   * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
   */
  @SerializedName("operator_id")
  private String operatorId;
  /**
   * Pin的操作人ID类型。当Pin的操作人为用户时，为==open_id==；当Pin的操作人为机器人时，为==app_id==
   * <p> 示例值：open_id
   */
  @SerializedName("operator_id_type")
  private String operatorIdType;
  /**
   * Pin的创建时间（毫秒级时间戳）
   * <p> 示例值：1615380573211
   */
  @SerializedName("create_time")
  private String createTime;

  // builder 开始
  public Pin() {
  }

  public Pin(Builder builder) {
    /**
     * Pin的消息ID
     * <p> 示例值：om_dc13264520392913993dd051dba21dcf
     */
    this.messageId = builder.messageId;
    /**
     * Pin消息所在的群聊ID
     * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
     */
    this.chatId = builder.chatId;
    /**
     * Pin的操作人ID
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     */
    this.operatorId = builder.operatorId;
    /**
     * Pin的操作人ID类型。当Pin的操作人为用户时，为==open_id==；当Pin的操作人为机器人时，为==app_id==
     * <p> 示例值：open_id
     */
    this.operatorIdType = builder.operatorIdType;
    /**
     * Pin的创建时间（毫秒级时间戳）
     * <p> 示例值：1615380573211
     */
    this.createTime = builder.createTime;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getMessageId() {
    return this.messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public String getChatId() {
    return this.chatId;
  }

  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  public String getOperatorId() {
    return this.operatorId;
  }

  public void setOperatorId(String operatorId) {
    this.operatorId = operatorId;
  }

  public String getOperatorIdType() {
    return this.operatorIdType;
  }

  public void setOperatorIdType(String operatorIdType) {
    this.operatorIdType = operatorIdType;
  }

  public String getCreateTime() {
    return this.createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public static class Builder {

    /**
     * Pin的消息ID
     * <p> 示例值：om_dc13264520392913993dd051dba21dcf
     */
    private String messageId;
    /**
     * Pin消息所在的群聊ID
     * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
     */
    private String chatId;
    /**
     * Pin的操作人ID
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     */
    private String operatorId;
    /**
     * Pin的操作人ID类型。当Pin的操作人为用户时，为==open_id==；当Pin的操作人为机器人时，为==app_id==
     * <p> 示例值：open_id
     */
    private String operatorIdType;
    /**
     * Pin的创建时间（毫秒级时间戳）
     * <p> 示例值：1615380573211
     */
    private String createTime;

    /**
     * Pin的消息ID
     * <p> 示例值：om_dc13264520392913993dd051dba21dcf
     *
     * @param messageId
     * @return
     */
    public Builder messageId(String messageId) {
      this.messageId = messageId;
      return this;
    }


    /**
     * Pin消息所在的群聊ID
     * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
     *
     * @param chatId
     * @return
     */
    public Builder chatId(String chatId) {
      this.chatId = chatId;
      return this;
    }


    /**
     * Pin的操作人ID
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     *
     * @param operatorId
     * @return
     */
    public Builder operatorId(String operatorId) {
      this.operatorId = operatorId;
      return this;
    }


    /**
     * Pin的操作人ID类型。当Pin的操作人为用户时，为==open_id==；当Pin的操作人为机器人时，为==app_id==
     * <p> 示例值：open_id
     *
     * @param operatorIdType
     * @return
     */
    public Builder operatorIdType(String operatorIdType) {
      this.operatorIdType = operatorIdType;
      return this;
    }


    /**
     * Pin的创建时间（毫秒级时间戳）
     * <p> 示例值：1615380573211
     *
     * @param createTime
     * @return
     */
    public Builder createTime(String createTime) {
      this.createTime = createTime;
      return this;
    }


    public Pin build() {
      return new Pin(this);
    }
  }
}
