// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class ListMetricSourceTableReq {

  /**
   * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
   * <p> 示例值：6969864184272078374
   */
  @Query
  @SerializedName("page_token")
  private String pageToken;
  /**
   * 每页获取记录数
   * <p> 示例值：10
   */
  @Query
  @SerializedName("page_size")
  private String pageSize;
  /**
   * okr指标库id
   * <p> 示例值：7041857032248410131
   */
  @Path
  @SerializedName("metric_source_id")
  private String metricSourceId;

  // builder 开始
  public ListMetricSourceTableReq() {
  }

  public ListMetricSourceTableReq(Builder builder) {
    /**
     * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
     * <p> 示例值：6969864184272078374
     */
    this.pageToken = builder.pageToken;
    /**
     * 每页获取记录数
     * <p> 示例值：10
     */
    this.pageSize = builder.pageSize;
    /**
     * okr指标库id
     * <p> 示例值：7041857032248410131
     */
    this.metricSourceId = builder.metricSourceId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getPageToken() {
    return this.pageToken;
  }

  public void setPageToken(String pageToken) {
    this.pageToken = pageToken;
  }

  public String getPageSize() {
    return this.pageSize;
  }

  public void setPageSize(String pageSize) {
    this.pageSize = pageSize;
  }

  public String getMetricSourceId() {
    return this.metricSourceId;
  }

  public void setMetricSourceId(String metricSourceId) {
    this.metricSourceId = metricSourceId;
  }

  public static class Builder {

    private String pageToken; // 页码标识，获取第一页传空，每次查询会返回下一页的page_token
    private String pageSize; // 每页获取记录数
    private String metricSourceId; // okr指标库id

    /**
     * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
     * <p> 示例值：6969864184272078374
     *
     * @param pageToken
     * @return
     */
    public Builder pageToken(String pageToken) {
      this.pageToken = pageToken;
      return this;
    }

    /**
     * 每页获取记录数
     * <p> 示例值：10
     *
     * @param pageSize
     * @return
     */
    public Builder pageSize(String pageSize) {
      this.pageSize = pageSize;
      return this;
    }

    /**
     * okr指标库id
     * <p> 示例值：7041857032248410131
     *
     * @param metricSourceId
     * @return
     */
    public Builder metricSourceId(String metricSourceId) {
      this.metricSourceId = metricSourceId;
      return this;
    }

    public ListMetricSourceTableReq build() {
      return new ListMetricSourceTableReq(this);
    }
  }
}
