// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.google.gson.annotations.SerializedName;

public class OkrReview {

  /**
   * 复盘的用户
   * <p> 示例值：
   */
  @SerializedName("user_id")
  private OkrObjectiveAlignedObjectiveOwner userId;
  /**
   * 用户对应的OKR复盘列表
   * <p> 示例值：
   */
  @SerializedName("review_period_list")
  private OkrReviewPeriod[] reviewPeriodList;

  // builder 开始
  public OkrReview() {
  }

  public OkrReview(Builder builder) {
    /**
     * 复盘的用户
     * <p> 示例值：
     */
    this.userId = builder.userId;
    /**
     * 用户对应的OKR复盘列表
     * <p> 示例值：
     */
    this.reviewPeriodList = builder.reviewPeriodList;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public OkrObjectiveAlignedObjectiveOwner getUserId() {
    return this.userId;
  }

  public void setUserId(OkrObjectiveAlignedObjectiveOwner userId) {
    this.userId = userId;
  }

  public OkrReviewPeriod[] getReviewPeriodList() {
    return this.reviewPeriodList;
  }

  public void setReviewPeriodList(OkrReviewPeriod[] reviewPeriodList) {
    this.reviewPeriodList = reviewPeriodList;
  }

  public static class Builder {

    /**
     * 复盘的用户
     * <p> 示例值：
     */
    private OkrObjectiveAlignedObjectiveOwner userId;
    /**
     * 用户对应的OKR复盘列表
     * <p> 示例值：
     */
    private OkrReviewPeriod[] reviewPeriodList;

    /**
     * 复盘的用户
     * <p> 示例值：
     *
     * @param userId
     * @return
     */
    public Builder userId(OkrObjectiveAlignedObjectiveOwner userId) {
      this.userId = userId;
      return this;
    }


    /**
     * 用户对应的OKR复盘列表
     * <p> 示例值：
     *
     * @param reviewPeriodList
     * @return
     */
    public Builder reviewPeriodList(OkrReviewPeriod[] reviewPeriodList) {
      this.reviewPeriodList = reviewPeriodList;
      return this;
    }


    public OkrReview build() {
      return new OkrReview(this);
    }
  }
}
