// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.tenant.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.tenant.v2.model.QueryTenantResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantService {

  private static final Logger log = LoggerFactory.getLogger(TenantService.class);
  private final Tenant tenant; // 企业

  public TenantService(Config config) {
    this.tenant = new Tenant(config);
  }

  /**
   * 企业
   *
   * @return
   */
  public Tenant tenant() {
    return tenant;
  }

  public static class Tenant {

    private final Config config;

    public Tenant(Config config) {
      this.config = config;
    }

    /**
     * 获取企业信息，获取企业名称、企业编号等企业信息
     * <p> 如果ISV应用是企业创建时默认安装，并且180天内企业未打开或使用过此应用，则无法通过此接口获取到企业信息。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/tenant-v2/tenant/query">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/tenant-v2/tenant/query</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/tenantv2/QueryTenantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/tenantv2/QueryTenantSample.java</a>
     * ;
     */
    public QueryTenantResp query(RequestOptions reqOptions) throws Exception {
      // 请求参数选项
      if (reqOptions == null) {
        reqOptions = new RequestOptions();
      }

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/tenant/v2/tenant/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      QueryTenantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/tenant/v2/tenant/query"
            , Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));

        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      return resp;
    }

    /**
     * 获取企业信息，获取企业名称、企业编号等企业信息
     * <p> 如果ISV应用是企业创建时默认安装，并且180天内企业未打开或使用过此应用，则无法通过此接口获取到企业信息。 ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/tenant-v2/tenant/query">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/tenant-v2/tenant/query</a>
     * ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/tenantv2/QueryTenantSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/tenantv2/QueryTenantSample.java</a>
     * ;
     */
    public QueryTenantResp query() throws Exception {
      // 请求参数选项
      RequestOptions reqOptions = new RequestOptions();

      // 发起请求
      RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
          , "/open-apis/tenant/v2/tenant/query"
          , Sets.newHashSet(AccessTokenType.Tenant)
          , null);

      // 反序列化
      QueryTenantResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTenantResp.class);
      if (resp == null) {
        log.error(String.format(
            "%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,",
            "/open-apis/tenant/v2/tenant/query"
            , Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
            httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                StandardCharsets.UTF_8)));

        throw new IllegalArgumentException("The result returned by the server is illegal");
      }

      resp.setRawResponse(httpResponse);
      return resp;
    }
  }

}