// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class RoomLevel {

  /**
   * 层级ID
   * <p> 示例值：层级ID
   */
  @SerializedName("room_level_id")
  private String roomLevelId;
  /**
   * 层级名称
   * <p> 示例值：测试层级
   */
  @SerializedName("name")
  private String name;
  /**
   * 父层级ID
   * <p> 示例值：omb_4ad1a2c7a2fbc5fc9570f38456931293
   */
  @SerializedName("parent_id")
  private String parentId;
  /**
   * 层级路径
   * <p> 示例值：[omb_8d020b12fe49e82847c2af3c193d5754, omb_8d020b12fe49e82847c2af3c193d5754]
   */
  @SerializedName("path")
  private String[] path;
  /**
   * 是否有子层级
   * <p> 示例值：false
   */
  @SerializedName("has_child")
  private Boolean hasChild;
  /**
   * 自定义层级ID
   * <p> 示例值：10000
   */
  @SerializedName("custom_group_id")
  private String customGroupId;

  // builder 开始
  public RoomLevel() {
  }

  public RoomLevel(Builder builder) {
    /**
     * 层级ID
     * <p> 示例值：层级ID
     */
    this.roomLevelId = builder.roomLevelId;
    /**
     * 层级名称
     * <p> 示例值：测试层级
     */
    this.name = builder.name;
    /**
     * 父层级ID
     * <p> 示例值：omb_4ad1a2c7a2fbc5fc9570f38456931293
     */
    this.parentId = builder.parentId;
    /**
     * 层级路径
     * <p> 示例值：[omb_8d020b12fe49e82847c2af3c193d5754, omb_8d020b12fe49e82847c2af3c193d5754]
     */
    this.path = builder.path;
    /**
     * 是否有子层级
     * <p> 示例值：false
     */
    this.hasChild = builder.hasChild;
    /**
     * 自定义层级ID
     * <p> 示例值：10000
     */
    this.customGroupId = builder.customGroupId;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public String getRoomLevelId() {
    return this.roomLevelId;
  }

  public void setRoomLevelId(String roomLevelId) {
    this.roomLevelId = roomLevelId;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getParentId() {
    return this.parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  public String[] getPath() {
    return this.path;
  }

  public void setPath(String[] path) {
    this.path = path;
  }

  public Boolean getHasChild() {
    return this.hasChild;
  }

  public void setHasChild(Boolean hasChild) {
    this.hasChild = hasChild;
  }

  public String getCustomGroupId() {
    return this.customGroupId;
  }

  public void setCustomGroupId(String customGroupId) {
    this.customGroupId = customGroupId;
  }

  public static class Builder {

    /**
     * 层级ID
     * <p> 示例值：层级ID
     */
    private String roomLevelId;
    /**
     * 层级名称
     * <p> 示例值：测试层级
     */
    private String name;
    /**
     * 父层级ID
     * <p> 示例值：omb_4ad1a2c7a2fbc5fc9570f38456931293
     */
    private String parentId;
    /**
     * 层级路径
     * <p> 示例值：[omb_8d020b12fe49e82847c2af3c193d5754, omb_8d020b12fe49e82847c2af3c193d5754]
     */
    private String[] path;
    /**
     * 是否有子层级
     * <p> 示例值：false
     */
    private Boolean hasChild;
    /**
     * 自定义层级ID
     * <p> 示例值：10000
     */
    private String customGroupId;

    /**
     * 层级ID
     * <p> 示例值：层级ID
     *
     * @param roomLevelId
     * @return
     */
    public Builder roomLevelId(String roomLevelId) {
      this.roomLevelId = roomLevelId;
      return this;
    }


    /**
     * 层级名称
     * <p> 示例值：测试层级
     *
     * @param name
     * @return
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }


    /**
     * 父层级ID
     * <p> 示例值：omb_4ad1a2c7a2fbc5fc9570f38456931293
     *
     * @param parentId
     * @return
     */
    public Builder parentId(String parentId) {
      this.parentId = parentId;
      return this;
    }


    /**
     * 层级路径
     * <p> 示例值：[omb_8d020b12fe49e82847c2af3c193d5754, omb_8d020b12fe49e82847c2af3c193d5754]
     *
     * @param path
     * @return
     */
    public Builder path(String[] path) {
      this.path = path;
      return this;
    }


    /**
     * 是否有子层级
     * <p> 示例值：false
     *
     * @param hasChild
     * @return
     */
    public Builder hasChild(Boolean hasChild) {
      this.hasChild = hasChild;
      return this;
    }


    /**
     * 自定义层级ID
     * <p> 示例值：10000
     *
     * @param customGroupId
     * @return
     */
    public Builder customGroupId(String customGroupId) {
      this.customGroupId = customGroupId;
      return this;
    }


    public RoomLevel build() {
      return new RoomLevel(this);
    }
  }
}
