/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.okr.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.okr.v1.model.BatchGetOkrReq;
import com.lark.oapi.service.okr.v1.model.BatchGetOkrResp;
import com.lark.oapi.service.okr.v1.model.BatchUpdateMetricSourceTableItemReq;
import com.lark.oapi.service.okr.v1.model.BatchUpdateMetricSourceTableItemResp;
import com.lark.oapi.service.okr.v1.model.CreateProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.CreateProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.DeleteProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.DeleteProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.GetMetricSourceTableItemReq;
import com.lark.oapi.service.okr.v1.model.GetMetricSourceTableItemResp;
import com.lark.oapi.service.okr.v1.model.GetProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.GetProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceReq;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceResp;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceTableItemReq;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceTableItemResp;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceTableReq;
import com.lark.oapi.service.okr.v1.model.ListMetricSourceTableResp;
import com.lark.oapi.service.okr.v1.model.ListPeriodReq;
import com.lark.oapi.service.okr.v1.model.ListPeriodResp;
import com.lark.oapi.service.okr.v1.model.ListUserOkrReq;
import com.lark.oapi.service.okr.v1.model.ListUserOkrResp;
import com.lark.oapi.service.okr.v1.model.PatchMetricSourceTableItemReq;
import com.lark.oapi.service.okr.v1.model.PatchMetricSourceTableItemResp;
import com.lark.oapi.service.okr.v1.model.QueryReviewReq;
import com.lark.oapi.service.okr.v1.model.QueryReviewResp;
import com.lark.oapi.service.okr.v1.model.UpdateProgressRecordReq;
import com.lark.oapi.service.okr.v1.model.UpdateProgressRecordResp;
import com.lark.oapi.service.okr.v1.model.UploadImageReq;
import com.lark.oapi.service.okr.v1.model.UploadImageResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkrService {
    private static final Logger log = LoggerFactory.getLogger(OkrService.class);
    private final Image image;
    private final MetricSource metricSource;
    private final MetricSourceTable metricSourceTable;
    private final MetricSourceTableItem metricSourceTableItem;
    private final Okr okr;
    private final Period period;
    private final ProgressRecord progressRecord;
    private final Review review;
    private final UserOkr userOkr;

    public OkrService(Config config) {
        this.image = new Image(config);
        this.metricSource = new MetricSource(config);
        this.metricSourceTable = new MetricSourceTable(config);
        this.metricSourceTableItem = new MetricSourceTableItem(config);
        this.okr = new Okr(config);
        this.period = new Period(config);
        this.progressRecord = new ProgressRecord(config);
        this.review = new Review(config);
        this.userOkr = new UserOkr(config);
    }

    public Image image() {
        return this.image;
    }

    public MetricSource metricSource() {
        return this.metricSource;
    }

    public MetricSourceTable metricSourceTable() {
        return this.metricSourceTable;
    }

    public MetricSourceTableItem metricSourceTableItem() {
        return this.metricSourceTableItem;
    }

    public Okr okr() {
        return this.okr;
    }

    public Period period() {
        return this.period;
    }

    public ProgressRecord progressRecord() {
        return this.progressRecord;
    }

    public Review review() {
        return this.review;
    }

    public UserOkr userOkr() {
        return this.userOkr;
    }

    public static class UserOkr {
        private final Config config;

        public UserOkr(Config config) {
            this.config = config;
        }

        public ListUserOkrResp list(ListUserOkrReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListUserOkrResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/users/:user_id/okrs", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req), ListUserOkrResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/users/:user_id/okrs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListUserOkrResp list(ListUserOkrReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/users/:user_id/okrs", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListUserOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListUserOkrResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/users/:user_id/okrs", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Review {
        private final Config config;

        public Review(Config config) {
            this.config = config;
        }

        public QueryReviewResp query(QueryReviewReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            QueryReviewResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/reviews/query", Sets.newHashSet(AccessTokenType.Tenant), req), QueryReviewResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/reviews/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public QueryReviewResp query(QueryReviewReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/reviews/query", Sets.newHashSet(AccessTokenType.Tenant), req);
            QueryReviewResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryReviewResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/reviews/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ProgressRecord {
        private final Config config;

        public ProgressRecord(Config config) {
            this.config = config;
        }

        public CreateProgressRecordResp create(CreateProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateProgressRecordResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/progress_records", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), CreateProgressRecordResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateProgressRecordResp create(CreateProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/progress_records", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CreateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateProgressRecordResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteProgressRecordResp delete(DeleteProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteProgressRecordResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), DeleteProgressRecordResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteProgressRecordResp delete(DeleteProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteProgressRecordResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetProgressRecordResp get(GetProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetProgressRecordResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), GetProgressRecordResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetProgressRecordResp get(GetProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetProgressRecordResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateProgressRecordResp update(UpdateProgressRecordReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UpdateProgressRecordResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), UpdateProgressRecordResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateProgressRecordResp update(UpdateProgressRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/okr/v1/progress_records/:progress_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateProgressRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateProgressRecordResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/progress_records/:progress_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Period {
        private final Config config;

        public Period(Config config) {
            this.config = config;
        }

        public ListPeriodResp list(ListPeriodReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListPeriodResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/periods", Sets.newHashSet(AccessTokenType.Tenant), req), ListPeriodResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/periods", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListPeriodResp list(ListPeriodReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/periods", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListPeriodResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListPeriodResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/periods", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Okr {
        private final Config config;

        public Okr(Config config) {
            this.config = config;
        }

        public BatchGetOkrResp batchGet(BatchGetOkrReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            BatchGetOkrResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/okrs/batch_get", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req), BatchGetOkrResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/okrs/batch_get", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchGetOkrResp batchGet(BatchGetOkrReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/okrs/batch_get", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            BatchGetOkrResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchGetOkrResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/okrs/batch_get", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class MetricSourceTableItem {
        private final Config config;

        public MetricSourceTableItem(Config config) {
            this.config = config;
        }

        public BatchUpdateMetricSourceTableItemResp batchUpdate(BatchUpdateMetricSourceTableItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            BatchUpdateMetricSourceTableItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/batch_update", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), BatchUpdateMetricSourceTableItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/batch_update", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public BatchUpdateMetricSourceTableItemResp batchUpdate(BatchUpdateMetricSourceTableItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/batch_update", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            BatchUpdateMetricSourceTableItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchUpdateMetricSourceTableItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/batch_update", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetMetricSourceTableItemResp get(GetMetricSourceTableItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetMetricSourceTableItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), GetMetricSourceTableItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetMetricSourceTableItemResp get(GetMetricSourceTableItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetMetricSourceTableItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetMetricSourceTableItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListMetricSourceTableItemResp list(ListMetricSourceTableItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListMetricSourceTableItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ListMetricSourceTableItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListMetricSourceTableItemResp list(ListMetricSourceTableItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListMetricSourceTableItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListMetricSourceTableItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchMetricSourceTableItemResp patch(PatchMetricSourceTableItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchMetricSourceTableItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), PatchMetricSourceTableItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchMetricSourceTableItemResp patch(PatchMetricSourceTableItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            PatchMetricSourceTableItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchMetricSourceTableItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables/:metric_table_id/items/:metric_item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class MetricSourceTable {
        private final Config config;

        public MetricSourceTable(Config config) {
            this.config = config;
        }

        public ListMetricSourceTableResp list(ListMetricSourceTableReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListMetricSourceTableResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ListMetricSourceTableResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListMetricSourceTableResp list(ListMetricSourceTableReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListMetricSourceTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListMetricSourceTableResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources/:metric_source_id/tables", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class MetricSource {
        private final Config config;

        public MetricSource(Config config) {
            this.config = config;
        }

        public ListMetricSourceResp list(ListMetricSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListMetricSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ListMetricSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListMetricSourceResp list(ListMetricSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/okr/v1/metric_sources", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            ListMetricSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListMetricSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/metric_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Image {
        private final Config config;

        public Image(Config config) {
            this.config = config;
        }

        public UploadImageResp upload(UploadImageReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/images/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UploadImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadImageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/images/upload", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UploadImageResp upload(UploadImageReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/okr/v1/images/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UploadImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadImageResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/okr/v1/images/upload", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

