/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.search.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.search.v2.model.CreateDataSourceItemReq;
import com.lark.oapi.service.search.v2.model.CreateDataSourceItemResp;
import com.lark.oapi.service.search.v2.model.CreateDataSourceReq;
import com.lark.oapi.service.search.v2.model.CreateDataSourceResp;
import com.lark.oapi.service.search.v2.model.CreateSchemaReq;
import com.lark.oapi.service.search.v2.model.CreateSchemaResp;
import com.lark.oapi.service.search.v2.model.DeleteDataSourceItemReq;
import com.lark.oapi.service.search.v2.model.DeleteDataSourceItemResp;
import com.lark.oapi.service.search.v2.model.DeleteDataSourceReq;
import com.lark.oapi.service.search.v2.model.DeleteDataSourceResp;
import com.lark.oapi.service.search.v2.model.DeleteSchemaReq;
import com.lark.oapi.service.search.v2.model.DeleteSchemaResp;
import com.lark.oapi.service.search.v2.model.GetDataSourceItemReq;
import com.lark.oapi.service.search.v2.model.GetDataSourceItemResp;
import com.lark.oapi.service.search.v2.model.GetDataSourceReq;
import com.lark.oapi.service.search.v2.model.GetDataSourceResp;
import com.lark.oapi.service.search.v2.model.GetSchemaReq;
import com.lark.oapi.service.search.v2.model.GetSchemaResp;
import com.lark.oapi.service.search.v2.model.ListDataSourceReq;
import com.lark.oapi.service.search.v2.model.ListDataSourceResp;
import com.lark.oapi.service.search.v2.model.PatchDataSourceReq;
import com.lark.oapi.service.search.v2.model.PatchDataSourceResp;
import com.lark.oapi.service.search.v2.model.PatchSchemaReq;
import com.lark.oapi.service.search.v2.model.PatchSchemaResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchService.class);
    private final DataSource dataSource;
    private final DataSourceItem dataSourceItem;
    private final Schema schema;

    public SearchService(Config config) {
        this.dataSource = new DataSource(config);
        this.dataSourceItem = new DataSourceItem(config);
        this.schema = new Schema(config);
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public DataSourceItem dataSourceItem() {
        return this.dataSourceItem;
    }

    public Schema schema() {
        return this.schema;
    }

    public static class Schema {
        private final Config config;

        public Schema(Config config) {
            this.config = config;
        }

        public CreateSchemaResp create(CreateSchemaReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateSchemaResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/schemas", Sets.newHashSet(AccessTokenType.Tenant), req), CreateSchemaResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateSchemaResp create(CreateSchemaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/schemas", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSchemaResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteSchemaResp delete(DeleteSchemaReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteSchemaResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req), DeleteSchemaResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteSchemaResp delete(DeleteSchemaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            DeleteSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteSchemaResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetSchemaResp get(GetSchemaReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetSchemaResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetSchemaResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetSchemaResp get(GetSchemaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetSchemaResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchSchemaResp patch(PatchSchemaReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchSchemaResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchSchemaResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchSchemaResp patch(PatchSchemaReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/search/v2/schemas/:schema_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchSchemaResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchSchemaResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/schemas/:schema_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class DataSourceItem {
        private final Config config;

        public DataSourceItem(Config config) {
            this.config = config;
        }

        public CreateDataSourceItemResp create(CreateDataSourceItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateDataSourceItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/data_sources/:data_source_id/items", Sets.newHashSet(AccessTokenType.Tenant), req), CreateDataSourceItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateDataSourceItemResp create(CreateDataSourceItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/data_sources/:data_source_id/items", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateDataSourceItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDataSourceItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteDataSourceItemResp delete(DeleteDataSourceItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteDataSourceItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Sets.newHashSet(AccessTokenType.Tenant), req), DeleteDataSourceItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteDataSourceItemResp delete(DeleteDataSourceItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            DeleteDataSourceItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteDataSourceItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetDataSourceItemResp get(GetDataSourceItemReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetDataSourceItemResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetDataSourceItemResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetDataSourceItemResp get(GetDataSourceItemReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetDataSourceItemResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetDataSourceItemResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id/items/:item_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class DataSource {
        private final Config config;

        public DataSource(Config config) {
            this.config = config;
        }

        public CreateDataSourceResp create(CreateDataSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateDataSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/data_sources", Sets.newHashSet(AccessTokenType.Tenant), req), CreateDataSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateDataSourceResp create(CreateDataSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/search/v2/data_sources", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateDataSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateDataSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteDataSourceResp delete(DeleteDataSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteDataSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req), DeleteDataSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteDataSourceResp delete(DeleteDataSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            DeleteDataSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteDataSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetDataSourceResp get(GetDataSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetDataSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetDataSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetDataSourceResp get(GetDataSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetDataSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetDataSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListDataSourceResp list(ListDataSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListDataSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources", Sets.newHashSet(AccessTokenType.Tenant), req), ListDataSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListDataSourceResp list(ListDataSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/search/v2/data_sources", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListDataSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListDataSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchDataSourceResp patch(PatchDataSourceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchDataSourceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchDataSourceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchDataSourceResp patch(PatchDataSourceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/search/v2/data_sources/:data_source_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchDataSourceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchDataSourceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/search/v2/data_sources/:data_source_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

