/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.cache.ICache;
import com.lark.oapi.core.cache.LocalCache;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.token.AppTicketManager;
import com.lark.oapi.core.token.GlobalAppTicketManager;
import com.lark.oapi.core.token.GlobalTokenManager;
import com.lark.oapi.core.token.TokenManager;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.service.acs.AcsService;
import com.lark.oapi.service.admin.AdminService;
import com.lark.oapi.service.application.ApplicationService;
import com.lark.oapi.service.approval.ApprovalService;
import com.lark.oapi.service.attendance.AttendanceService;
import com.lark.oapi.service.auth.AuthService;
import com.lark.oapi.service.authen.AuthenService;
import com.lark.oapi.service.baike.BaikeService;
import com.lark.oapi.service.bitable.BitableService;
import com.lark.oapi.service.block.BlockService;
import com.lark.oapi.service.calendar.CalendarService;
import com.lark.oapi.service.contact.ContactService;
import com.lark.oapi.service.corehr.CorehrService;
import com.lark.oapi.service.document_ai.DocumentAiService;
import com.lark.oapi.service.docx.DocxService;
import com.lark.oapi.service.drive.DriveService;
import com.lark.oapi.service.ehr.EhrService;
import com.lark.oapi.service.event.EventService;
import com.lark.oapi.service.ext.ExtService;
import com.lark.oapi.service.gray_test_open_sg.GrayTestOpenSgService;
import com.lark.oapi.service.helpdesk.HelpdeskService;
import com.lark.oapi.service.hire.HireService;
import com.lark.oapi.service.human_authentication.HumanAuthenticationService;
import com.lark.oapi.service.im.ImService;
import com.lark.oapi.service.lingo.LingoService;
import com.lark.oapi.service.mail.MailService;
import com.lark.oapi.service.mdm.MdmService;
import com.lark.oapi.service.meeting_room.MeetingRoomService;
import com.lark.oapi.service.okr.OkrService;
import com.lark.oapi.service.optical_char_recognition.OpticalCharRecognitionService;
import com.lark.oapi.service.passport.PassportService;
import com.lark.oapi.service.personal_settings.PersonalSettingsService;
import com.lark.oapi.service.search.SearchService;
import com.lark.oapi.service.security_and_compliance.SecurityAndComplianceService;
import com.lark.oapi.service.sheets.SheetsService;
import com.lark.oapi.service.speech_to_text.SpeechToTextService;
import com.lark.oapi.service.task.TaskService;
import com.lark.oapi.service.tenant.TenantService;
import com.lark.oapi.service.translation.TranslationService;
import com.lark.oapi.service.vc.VcService;
import com.lark.oapi.service.wiki.WikiService;
import com.lark.oapi.service.workplace.WorkplaceService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class Client {
    private Config config;
    private ApplicationService application;
    private LingoService lingo;
    private PersonalSettingsService personalSettings;
    private SearchService search;
    private WikiService wiki;
    private AttendanceService attendance;
    private BaikeService baike;
    private DocumentAiService documentAi;
    private ImService im;
    private WorkplaceService workplace;
    private AuthenService authen;
    private DriveService drive;
    private HireService hire;
    private EhrService ehr;
    private HelpdeskService helpdesk;
    private MdmService mdm;
    private SecurityAndComplianceService securityAndCompliance;
    private SheetsService sheets;
    private BlockService block;
    private ContactService contact;
    private CorehrService corehr;
    private SpeechToTextService speechToText;
    private MeetingRoomService meetingRoom;
    private TenantService tenant;
    private TranslationService translation;
    private AdminService admin;
    private CalendarService calendar;
    private MailService mail;
    private PassportService passport;
    private AcsService acs;
    private ApprovalService approval;
    private HumanAuthenticationService humanAuthentication;
    private OkrService okr;
    private VcService vc;
    private AuthService auth;
    private DocxService docx;
    private GrayTestOpenSgService grayTestOpenSg;
    private TaskService task;
    private BitableService bitable;
    private EventService event;
    private OpticalCharRecognitionService opticalCharRecognition;
    private ExtService extService;

    public static Builder newBuilder(String appId, String appSecret) {
        return new Builder(appId, appSecret);
    }

    public ExtService ext() {
        return this.extService;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public ApplicationService application() {
        return this.application;
    }

    public LingoService lingo() {
        return this.lingo;
    }

    public PersonalSettingsService personalSettings() {
        return this.personalSettings;
    }

    public SearchService search() {
        return this.search;
    }

    public WikiService wiki() {
        return this.wiki;
    }

    public AttendanceService attendance() {
        return this.attendance;
    }

    public BaikeService baike() {
        return this.baike;
    }

    public DocumentAiService documentAi() {
        return this.documentAi;
    }

    public ImService im() {
        return this.im;
    }

    public WorkplaceService workplace() {
        return this.workplace;
    }

    public AuthenService authen() {
        return this.authen;
    }

    public DriveService drive() {
        return this.drive;
    }

    public HireService hire() {
        return this.hire;
    }

    public EhrService ehr() {
        return this.ehr;
    }

    public HelpdeskService helpdesk() {
        return this.helpdesk;
    }

    public MdmService mdm() {
        return this.mdm;
    }

    public SecurityAndComplianceService securityAndCompliance() {
        return this.securityAndCompliance;
    }

    public SheetsService sheets() {
        return this.sheets;
    }

    public BlockService block() {
        return this.block;
    }

    public ContactService contact() {
        return this.contact;
    }

    public CorehrService corehr() {
        return this.corehr;
    }

    public SpeechToTextService speechToText() {
        return this.speechToText;
    }

    public MeetingRoomService meetingRoom() {
        return this.meetingRoom;
    }

    public TenantService tenant() {
        return this.tenant;
    }

    public TranslationService translation() {
        return this.translation;
    }

    public AdminService admin() {
        return this.admin;
    }

    public CalendarService calendar() {
        return this.calendar;
    }

    public MailService mail() {
        return this.mail;
    }

    public PassportService passport() {
        return this.passport;
    }

    public AcsService acs() {
        return this.acs;
    }

    public ApprovalService approval() {
        return this.approval;
    }

    public HumanAuthenticationService humanAuthentication() {
        return this.humanAuthentication;
    }

    public OkrService okr() {
        return this.okr;
    }

    public VcService vc() {
        return this.vc;
    }

    public AuthService auth() {
        return this.auth;
    }

    public DocxService docx() {
        return this.docx;
    }

    public GrayTestOpenSgService grayTestOpenSg() {
        return this.grayTestOpenSg;
    }

    public TaskService task() {
        return this.task;
    }

    public BitableService bitable() {
        return this.bitable;
    }

    public EventService event() {
        return this.event;
    }

    public OpticalCharRecognitionService opticalCharRecognition() {
        return this.opticalCharRecognition;
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public static final class Builder {
        private Config config = new Config();

        public Builder(String appId, String appSecret) {
            this.config.setAppId(appId);
            this.config.setAppSecret(appSecret);
            this.config.setBaseUrl(BaseUrlEnum.FeiShu.getUrl());
            this.config.setAppType(AppType.SELF_BUILT);
            this.config.setDisableTokenCache(false);
        }

        public Builder helpDeskCredential(String helpDeskId, String helpDeskToken) {
            this.config.setHelpDeskToken(helpDeskToken);
            this.config.setHelpDeskID(helpDeskId);
            if (Strings.isNotEmpty(helpDeskId) && Strings.isNotEmpty(helpDeskToken)) {
                this.config.setHelpDeskAuthToken(Base64.getEncoder().encodeToString(String.format("%s:%s", helpDeskId, helpDeskToken).getBytes(StandardCharsets.UTF_8)));
            }
            return this;
        }

        public Builder appType(AppType appType) {
            this.config.setAppType(appType);
            return this;
        }

        public Builder marketplaceApp() {
            this.config.setAppType(AppType.MARKETPLACE);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder logReqAtDebug(boolean logReqRespInfoAtDebugLevel) {
            this.config.setLogReqAtDebug(logReqRespInfoAtDebugLevel);
            return this;
        }

        public Builder openBaseUrl(String baseUrl) {
            this.config.setBaseUrl(baseUrl);
            return this;
        }

        public Builder openBaseUrl(BaseUrlEnum baseUrl) {
            this.config.setBaseUrl(baseUrl.getUrl());
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder requestTimeout(long timeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(timeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder httpTransport(IHttpTransport httpTransport) {
            this.config.setHttpTransport(httpTransport);
            return this;
        }

        private void initCache(Config config) {
            if (config.getCache() != null) {
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(config.getCache()));
                GlobalTokenManager.setTokenManager(new TokenManager(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(cache));
                GlobalTokenManager.setTokenManager(new TokenManager(cache));
            }
        }

        private void initHttpTransport(Config config) {
            if (config.getHttpTransport() == null) {
                if (config.getRequestTimeOut() > 0L) {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.create(config.getRequestTimeOut(), config.getTimeOutTimeUnit())));
                } else {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.defaultClient));
                }
            }
        }

        public Client build() {
            Client client = new Client();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            client.extService = new ExtService(this.config);
            client.application = new ApplicationService(this.config);
            client.lingo = new LingoService(this.config);
            client.personalSettings = new PersonalSettingsService(this.config);
            client.search = new SearchService(this.config);
            client.wiki = new WikiService(this.config);
            client.attendance = new AttendanceService(this.config);
            client.baike = new BaikeService(this.config);
            client.documentAi = new DocumentAiService(this.config);
            client.im = new ImService(this.config);
            client.workplace = new WorkplaceService(this.config);
            client.authen = new AuthenService(this.config);
            client.drive = new DriveService(this.config);
            client.hire = new HireService(this.config);
            client.ehr = new EhrService(this.config);
            client.helpdesk = new HelpdeskService(this.config);
            client.mdm = new MdmService(this.config);
            client.securityAndCompliance = new SecurityAndComplianceService(this.config);
            client.sheets = new SheetsService(this.config);
            client.block = new BlockService(this.config);
            client.contact = new ContactService(this.config);
            client.corehr = new CorehrService(this.config);
            client.speechToText = new SpeechToTextService(this.config);
            client.meetingRoom = new MeetingRoomService(this.config);
            client.tenant = new TenantService(this.config);
            client.translation = new TranslationService(this.config);
            client.admin = new AdminService(this.config);
            client.calendar = new CalendarService(this.config);
            client.mail = new MailService(this.config);
            client.passport = new PassportService(this.config);
            client.acs = new AcsService(this.config);
            client.approval = new ApprovalService(this.config);
            client.humanAuthentication = new HumanAuthenticationService(this.config);
            client.okr = new OkrService(this.config);
            client.vc = new VcService(this.config);
            client.auth = new AuthService(this.config);
            client.docx = new DocxService(this.config);
            client.grayTestOpenSg = new GrayTestOpenSgService(this.config);
            client.task = new TaskService(this.config);
            client.bitable = new BitableService(this.config);
            client.event = new EventService(this.config);
            client.opticalCharRecognition = new OpticalCharRecognitionService(this.config);
            return client;
        }
    }
}

