// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.acs.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Query;

public class CreateRuleExternalReq {
    /**
     * 权限组id-为空创建,不为空则更新
     * <p> 示例值：7298933941867135276
     */
    @Query
    @SerializedName("rule_id")
    private String ruleId;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    @Body
    private CreateRuleExternalReqBody body;

    // builder 开始
    public CreateRuleExternalReq() {
    }

    public CreateRuleExternalReq(Builder builder) {
        /**
         * 权限组id-为空创建,不为空则更新
         * <p> 示例值：7298933941867135276
         */
        this.ruleId = builder.ruleId;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public CreateRuleExternalReqBody getCreateRuleExternalReqBody() {
        return this.body;
    }

    public void setCreateRuleExternalReqBody(CreateRuleExternalReqBody body) {
        this.body = body;
    }

    public static class Builder {
        private String ruleId; // 权限组id-为空创建,不为空则更新
        private String userIdType; // 此次调用中使用的用户ID的类型
        private CreateRuleExternalReqBody body;

        /**
         * 权限组id-为空创建,不为空则更新
         * <p> 示例值：7298933941867135276
         *
         * @param ruleId
         * @return
         */
        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.acs.v1.enums.CreateRuleExternalUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.acs.v1.enums.CreateRuleExternalUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        public CreateRuleExternalReqBody getCreateRuleExternalReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder createRuleExternalReqBody(CreateRuleExternalReqBody body) {
            this.body = body;
            return this;
        }

        public CreateRuleExternalReq build() {
            return new CreateRuleExternalReq(this);
        }
    }
}
