// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class ManageRelation {
    /**
     * 下级所在部门
     * <p> 示例值：4719456877659520852
     */
    @SerializedName("subordinate_department_id")
    private String subordinateDepartmentId;
    /**
     * 下级员工
     * <p> 示例值：6893010737371809287
     */
    @SerializedName("subordinate_employee_id")
    private String subordinateEmployeeId;
    /**
     * 汇报关系（实现汇报，虚线汇报，第二汇报线...）
     * <p> 示例值：
     */
    @SerializedName("manager_type")
    private Enum managerType;
    /**
     * 汇报线类型 (按人汇报，按部门汇报...)
     * <p> 示例值：
     */
    @SerializedName("report_mode_type")
    private Enum reportModeType;
    /**
     * 上级员工
     * <p> 示例值：6893013626584565256
     */
    @SerializedName("superior_employee_id")
    private String superiorEmployeeId;
    /**
     * 生效时间
     * <p> 示例值：2021-06-06 00:00:00
     */
    @SerializedName("effective_time")
    private String effectiveTime;

    // builder 开始
    public ManageRelation() {
    }

    public ManageRelation(Builder builder) {
        /**
         * 下级所在部门
         * <p> 示例值：4719456877659520852
         */
        this.subordinateDepartmentId = builder.subordinateDepartmentId;
        /**
         * 下级员工
         * <p> 示例值：6893010737371809287
         */
        this.subordinateEmployeeId = builder.subordinateEmployeeId;
        /**
         * 汇报关系（实现汇报，虚线汇报，第二汇报线...）
         * <p> 示例值：
         */
        this.managerType = builder.managerType;
        /**
         * 汇报线类型 (按人汇报，按部门汇报...)
         * <p> 示例值：
         */
        this.reportModeType = builder.reportModeType;
        /**
         * 上级员工
         * <p> 示例值：6893013626584565256
         */
        this.superiorEmployeeId = builder.superiorEmployeeId;
        /**
         * 生效时间
         * <p> 示例值：2021-06-06 00:00:00
         */
        this.effectiveTime = builder.effectiveTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSubordinateDepartmentId() {
        return this.subordinateDepartmentId;
    }

    public void setSubordinateDepartmentId(String subordinateDepartmentId) {
        this.subordinateDepartmentId = subordinateDepartmentId;
    }

    public String getSubordinateEmployeeId() {
        return this.subordinateEmployeeId;
    }

    public void setSubordinateEmployeeId(String subordinateEmployeeId) {
        this.subordinateEmployeeId = subordinateEmployeeId;
    }

    public Enum getManagerType() {
        return this.managerType;
    }

    public void setManagerType(Enum managerType) {
        this.managerType = managerType;
    }

    public Enum getReportModeType() {
        return this.reportModeType;
    }

    public void setReportModeType(Enum reportModeType) {
        this.reportModeType = reportModeType;
    }

    public String getSuperiorEmployeeId() {
        return this.superiorEmployeeId;
    }

    public void setSuperiorEmployeeId(String superiorEmployeeId) {
        this.superiorEmployeeId = superiorEmployeeId;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public static class Builder {
        /**
         * 下级所在部门
         * <p> 示例值：4719456877659520852
         */
        private String subordinateDepartmentId;
        /**
         * 下级员工
         * <p> 示例值：6893010737371809287
         */
        private String subordinateEmployeeId;
        /**
         * 汇报关系（实现汇报，虚线汇报，第二汇报线...）
         * <p> 示例值：
         */
        private Enum managerType;
        /**
         * 汇报线类型 (按人汇报，按部门汇报...)
         * <p> 示例值：
         */
        private Enum reportModeType;
        /**
         * 上级员工
         * <p> 示例值：6893013626584565256
         */
        private String superiorEmployeeId;
        /**
         * 生效时间
         * <p> 示例值：2021-06-06 00:00:00
         */
        private String effectiveTime;

        /**
         * 下级所在部门
         * <p> 示例值：4719456877659520852
         *
         * @param subordinateDepartmentId
         * @return
         */
        public Builder subordinateDepartmentId(String subordinateDepartmentId) {
            this.subordinateDepartmentId = subordinateDepartmentId;
            return this;
        }


        /**
         * 下级员工
         * <p> 示例值：6893010737371809287
         *
         * @param subordinateEmployeeId
         * @return
         */
        public Builder subordinateEmployeeId(String subordinateEmployeeId) {
            this.subordinateEmployeeId = subordinateEmployeeId;
            return this;
        }


        /**
         * 汇报关系（实现汇报，虚线汇报，第二汇报线...）
         * <p> 示例值：
         *
         * @param managerType
         * @return
         */
        public Builder managerType(Enum managerType) {
            this.managerType = managerType;
            return this;
        }


        /**
         * 汇报线类型 (按人汇报，按部门汇报...)
         * <p> 示例值：
         *
         * @param reportModeType
         * @return
         */
        public Builder reportModeType(Enum reportModeType) {
            this.reportModeType = reportModeType;
            return this;
        }


        /**
         * 上级员工
         * <p> 示例值：6893013626584565256
         *
         * @param superiorEmployeeId
         * @return
         */
        public Builder superiorEmployeeId(String superiorEmployeeId) {
            this.superiorEmployeeId = superiorEmployeeId;
            return this;
        }


        /**
         * 生效时间
         * <p> 示例值：2021-06-06 00:00:00
         *
         * @param effectiveTime
         * @return
         */
        public Builder effectiveTime(String effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }


        public ManageRelation build() {
            return new ManageRelation(this);
        }
    }
}
