// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class ListFileReq {
    /**
     * 分页大小
     * <p> 示例值：10
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
     * <p> 示例值：MTY1NTA3MTA1OXw3MTA4NDc2MDc1NzkyOTI0Nabcef
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 文件夹的token（若不填写该参数或填写空字符串，则默认获取用户云空间下的清单，且不支持分页）
     * <p> 示例值：fldbcO1UuPz8VwnpPx5a9abcef
     */
    @Query
    @SerializedName("folder_token")
    private String folderToken;
    /**
     * 排序规则
     * <p> 示例值：EditedTime
     */
    @Query
    @SerializedName("order_by")
    private String orderBy;
    /**
     * 升序降序
     * <p> 示例值：DESC
     */
    @Query
    @SerializedName("direction")
    private String direction;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;

    // builder 开始
    public ListFileReq() {
    }

    public ListFileReq(Builder builder) {
        /**
         * 分页大小
         * <p> 示例值：10
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：MTY1NTA3MTA1OXw3MTA4NDc2MDc1NzkyOTI0Nabcef
         */
        this.pageToken = builder.pageToken;
        /**
         * 文件夹的token（若不填写该参数或填写空字符串，则默认获取用户云空间下的清单，且不支持分页）
         * <p> 示例值：fldbcO1UuPz8VwnpPx5a9abcef
         */
        this.folderToken = builder.folderToken;
        /**
         * 排序规则
         * <p> 示例值：EditedTime
         */
        this.orderBy = builder.orderBy;
        /**
         * 升序降序
         * <p> 示例值：DESC
         */
        this.direction = builder.direction;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getFolderToken() {
        return this.folderToken;
    }

    public void setFolderToken(String folderToken) {
        this.folderToken = folderToken;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public static class Builder {
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
        private String folderToken; // 文件夹的token（若不填写该参数或填写空字符串，则默认获取用户云空间下的清单，且不支持分页）
        private String orderBy; // 排序规则
        private String direction; // 升序降序
        private String userIdType; // 此次调用中使用的用户ID的类型


        /**
         * 分页大小
         * <p> 示例值：10
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：MTY1NTA3MTA1OXw3MTA4NDc2MDc1NzkyOTI0Nabcef
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 文件夹的token（若不填写该参数或填写空字符串，则默认获取用户云空间下的清单，且不支持分页）
         * <p> 示例值：fldbcO1UuPz8VwnpPx5a9abcef
         *
         * @param folderToken
         * @return
         */
        public Builder folderToken(String folderToken) {
            this.folderToken = folderToken;
            return this;
        }


        /**
         * 排序规则
         * <p> 示例值：EditedTime
         *
         * @param orderBy
         * @return
         */
        public Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        /**
         * 排序规则
         * <p> 示例值：EditedTime
         *
         * @param orderBy {@link com.lark.oapi.service.drive.v1.enums.ListFileOrderByEnum}
         * @return
         */
        public Builder orderBy(com.lark.oapi.service.drive.v1.enums.ListFileOrderByEnum orderBy) {
            this.orderBy = orderBy.getValue();
            return this;
        }


        /**
         * 升序降序
         * <p> 示例值：DESC
         *
         * @param direction
         * @return
         */
        public Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * 升序降序
         * <p> 示例值：DESC
         *
         * @param direction {@link com.lark.oapi.service.drive.v1.enums.ListFileDirectionEnum}
         * @return
         */
        public Builder direction(com.lark.oapi.service.drive.v1.enums.ListFileDirectionEnum direction) {
            this.direction = direction.getValue();
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.drive.v1.enums.ListFileUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.drive.v1.enums.ListFileUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        public ListFileReq build() {
            return new ListFileReq(this);
        }
    }
}
