// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.okr;

import com.lark.oapi.core.Config;
import com.lark.oapi.service.okr.v1.V1;
import com.lark.oapi.service.okr.v1.resource.*;

public class OkrService {
    private final V1 v1;
    private final Image image; // 图片
    private final Okr okr; // OKR
    private final Period period; // OKR周期
    private final PeriodRule periodRule; // 周期规则
    private final ProgressRecord progressRecord; // OKR进展记录
    private final UserOkr userOkr; // 用户OKR

    public OkrService(Config config) {
        this.v1 = new V1(config);
        this.image = new Image(config);
        this.okr = new Okr(config);
        this.period = new Period(config);
        this.periodRule = new PeriodRule(config);
        this.progressRecord = new ProgressRecord(config);
        this.userOkr = new UserOkr(config);
    }

    public V1 v1() {
        return v1;
    }

    public Image image() {
        return image;
    }

    public Okr okr() {
        return okr;
    }

    public Period period() {
        return period;
    }

    public PeriodRule periodRule() {
        return periodRule;
    }

    public ProgressRecord progressRecord() {
        return progressRecord;
    }

    public UserOkr userOkr() {
        return userOkr;
    }
}