// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.google.gson.annotations.SerializedName;

public class ModelParam {
    /**
     * embedding模型名字
     * <p> 示例值：lark-encoder
     */
    @SerializedName("encoder_name")
    private String encoderName;
    /**
     * 排序模型名字
     * <p> 示例值：lark-ranker
     */
    @SerializedName("ranker_name")
    private String rankerName;
    /**
     * 过滤模型名字
     * <p> 示例值：lark-filter
     */
    @SerializedName("filter_name")
    private String filterName;
    /**
     * 时效权威互动模型名字
     * <p> 示例值：lark-booster
     */
    @SerializedName("booster_name")
    private String boosterName;
    /**
     * 选择返回的语种，可选{zh,en,ja,auto,all}，auto自动检测query的语种并过滤，all保留所有语种不做过滤，默认auto
     * <p> 示例值：zh
     */
    @SerializedName("passage_language")
    private String passageLanguage;

    // builder 开始
    public ModelParam() {
    }

    public ModelParam(Builder builder) {
        /**
         * embedding模型名字
         * <p> 示例值：lark-encoder
         */
        this.encoderName = builder.encoderName;
        /**
         * 排序模型名字
         * <p> 示例值：lark-ranker
         */
        this.rankerName = builder.rankerName;
        /**
         * 过滤模型名字
         * <p> 示例值：lark-filter
         */
        this.filterName = builder.filterName;
        /**
         * 时效权威互动模型名字
         * <p> 示例值：lark-booster
         */
        this.boosterName = builder.boosterName;
        /**
         * 选择返回的语种，可选{zh,en,ja,auto,all}，auto自动检测query的语种并过滤，all保留所有语种不做过滤，默认auto
         * <p> 示例值：zh
         */
        this.passageLanguage = builder.passageLanguage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getEncoderName() {
        return this.encoderName;
    }

    public void setEncoderName(String encoderName) {
        this.encoderName = encoderName;
    }

    public String getRankerName() {
        return this.rankerName;
    }

    public void setRankerName(String rankerName) {
        this.rankerName = rankerName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getBoosterName() {
        return this.boosterName;
    }

    public void setBoosterName(String boosterName) {
        this.boosterName = boosterName;
    }

    public String getPassageLanguage() {
        return this.passageLanguage;
    }

    public void setPassageLanguage(String passageLanguage) {
        this.passageLanguage = passageLanguage;
    }

    public static class Builder {
        /**
         * embedding模型名字
         * <p> 示例值：lark-encoder
         */
        private String encoderName;
        /**
         * 排序模型名字
         * <p> 示例值：lark-ranker
         */
        private String rankerName;
        /**
         * 过滤模型名字
         * <p> 示例值：lark-filter
         */
        private String filterName;
        /**
         * 时效权威互动模型名字
         * <p> 示例值：lark-booster
         */
        private String boosterName;
        /**
         * 选择返回的语种，可选{zh,en,ja,auto,all}，auto自动检测query的语种并过滤，all保留所有语种不做过滤，默认auto
         * <p> 示例值：zh
         */
        private String passageLanguage;

        /**
         * embedding模型名字
         * <p> 示例值：lark-encoder
         *
         * @param encoderName
         * @return
         */
        public Builder encoderName(String encoderName) {
            this.encoderName = encoderName;
            return this;
        }


        /**
         * 排序模型名字
         * <p> 示例值：lark-ranker
         *
         * @param rankerName
         * @return
         */
        public Builder rankerName(String rankerName) {
            this.rankerName = rankerName;
            return this;
        }


        /**
         * 过滤模型名字
         * <p> 示例值：lark-filter
         *
         * @param filterName
         * @return
         */
        public Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }


        /**
         * 时效权威互动模型名字
         * <p> 示例值：lark-booster
         *
         * @param boosterName
         * @return
         */
        public Builder boosterName(String boosterName) {
            this.boosterName = boosterName;
            return this;
        }


        /**
         * 选择返回的语种，可选{zh,en,ja,auto,all}，auto自动检测query的语种并过滤，all保留所有语种不做过滤，默认auto
         * <p> 示例值：zh
         *
         * @param passageLanguage
         * @return
         */
        public Builder passageLanguage(String passageLanguage) {
            this.passageLanguage = passageLanguage;
            return this;
        }


        public ModelParam build() {
            return new ModelParam(this);
        }
    }
}
