// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.google.gson.annotations.SerializedName;

public class EmailFilter {
    /**
     * 企业用户列表
     * <p> 示例值：ou_7636758725e268a4c67dc7457d27719d
     */
    @SerializedName("owner_userid_list")
    private String[] ownerUseridList;
    /**
     * 公共邮箱列表
     * <p> 示例值：jiajinqud@zijietiaobudong.top
     */
    @SerializedName("owner_address_list")
    private String[] ownerAddressList;
    /**
     * 查询时间范围
     * <p> 示例值：
     */
    @SerializedName("time_range")
    private TimeRange timeRange;
    /**
     * 发件人邮箱列表
     * <p> 示例值：mail-noreply@feishu.cn
     */
    @SerializedName("senders")
    private String[] senders;
    /**
     * 收件人邮箱列表
     * <p> 示例值：jiajinqud@zijietiaobudong.top
     */
    @SerializedName("recipients")
    private String[] recipients;
    /**
     * 邮件标题
     * <p> 示例值：test email
     */
    @SerializedName("email_title")
    private String emailTitle;
    /**
     * 邮件ID
     * <p> 示例值：5e1d0913ea6770d309fd18778fb45a15a1e69857.8fb8a4da.a4fd.4d48.baa0.2396bf70c04d@staging.feishu.cn
     */
    @SerializedName("email_id")
    private String emailId;

    // builder 开始
    public EmailFilter() {
    }

    public EmailFilter(Builder builder) {
        /**
         * 企业用户列表
         * <p> 示例值：ou_7636758725e268a4c67dc7457d27719d
         */
        this.ownerUseridList = builder.ownerUseridList;
        /**
         * 公共邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         */
        this.ownerAddressList = builder.ownerAddressList;
        /**
         * 查询时间范围
         * <p> 示例值：
         */
        this.timeRange = builder.timeRange;
        /**
         * 发件人邮箱列表
         * <p> 示例值：mail-noreply@feishu.cn
         */
        this.senders = builder.senders;
        /**
         * 收件人邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         */
        this.recipients = builder.recipients;
        /**
         * 邮件标题
         * <p> 示例值：test email
         */
        this.emailTitle = builder.emailTitle;
        /**
         * 邮件ID
         * <p> 示例值：5e1d0913ea6770d309fd18778fb45a15a1e69857.8fb8a4da.a4fd.4d48.baa0.2396bf70c04d@staging.feishu.cn
         */
        this.emailId = builder.emailId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getOwnerUseridList() {
        return this.ownerUseridList;
    }

    public void setOwnerUseridList(String[] ownerUseridList) {
        this.ownerUseridList = ownerUseridList;
    }

    public String[] getOwnerAddressList() {
        return this.ownerAddressList;
    }

    public void setOwnerAddressList(String[] ownerAddressList) {
        this.ownerAddressList = ownerAddressList;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public String[] getSenders() {
        return this.senders;
    }

    public void setSenders(String[] senders) {
        this.senders = senders;
    }

    public String[] getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String[] recipients) {
        this.recipients = recipients;
    }

    public String getEmailTitle() {
        return this.emailTitle;
    }

    public void setEmailTitle(String emailTitle) {
        this.emailTitle = emailTitle;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public static class Builder {
        /**
         * 企业用户列表
         * <p> 示例值：ou_7636758725e268a4c67dc7457d27719d
         */
        private String[] ownerUseridList;
        /**
         * 公共邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         */
        private String[] ownerAddressList;
        /**
         * 查询时间范围
         * <p> 示例值：
         */
        private TimeRange timeRange;
        /**
         * 发件人邮箱列表
         * <p> 示例值：mail-noreply@feishu.cn
         */
        private String[] senders;
        /**
         * 收件人邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         */
        private String[] recipients;
        /**
         * 邮件标题
         * <p> 示例值：test email
         */
        private String emailTitle;
        /**
         * 邮件ID
         * <p> 示例值：5e1d0913ea6770d309fd18778fb45a15a1e69857.8fb8a4da.a4fd.4d48.baa0.2396bf70c04d@staging.feishu.cn
         */
        private String emailId;

        /**
         * 企业用户列表
         * <p> 示例值：ou_7636758725e268a4c67dc7457d27719d
         *
         * @param ownerUseridList
         * @return
         */
        public Builder ownerUseridList(String[] ownerUseridList) {
            this.ownerUseridList = ownerUseridList;
            return this;
        }


        /**
         * 公共邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         *
         * @param ownerAddressList
         * @return
         */
        public Builder ownerAddressList(String[] ownerAddressList) {
            this.ownerAddressList = ownerAddressList;
            return this;
        }


        /**
         * 查询时间范围
         * <p> 示例值：
         *
         * @param timeRange
         * @return
         */
        public Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }


        /**
         * 发件人邮箱列表
         * <p> 示例值：mail-noreply@feishu.cn
         *
         * @param senders
         * @return
         */
        public Builder senders(String[] senders) {
            this.senders = senders;
            return this;
        }


        /**
         * 收件人邮箱列表
         * <p> 示例值：jiajinqud@zijietiaobudong.top
         *
         * @param recipients
         * @return
         */
        public Builder recipients(String[] recipients) {
            this.recipients = recipients;
            return this;
        }


        /**
         * 邮件标题
         * <p> 示例值：test email
         *
         * @param emailTitle
         * @return
         */
        public Builder emailTitle(String emailTitle) {
            this.emailTitle = emailTitle;
            return this;
        }


        /**
         * 邮件ID
         * <p> 示例值：5e1d0913ea6770d309fd18778fb45a15a1e69857.8fb8a4da.a4fd.4d48.baa0.2396bf70c04d@staging.feishu.cn
         *
         * @param emailId
         * @return
         */
        public Builder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }


        public EmailFilter build() {
            return new EmailFilter(this);
        }
    }
}
