// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.google.gson.annotations.SerializedName;

public class Attachment {
    /**
     * 附件guid
     * <p> 示例值：f860de3e-6881-4ddd-9321-070f36d1af0b
     */
    @SerializedName("guid")
    private String guid;
    /**
     * 附件在云文档系统中的token
     * <p> 示例值：boxcnTDqPaRA6JbYnzQsZ2doB2b
     */
    @SerializedName("file_token")
    private String fileToken;
    /**
     * 附件名
     * <p> 示例值：foo.jpg
     */
    @SerializedName("name")
    private String name;
    /**
     * 附件的字节大小
     * <p> 示例值：62232
     */
    @SerializedName("size")
    private Integer size;
    /**
     * 附件归属的资源
     * <p> 示例值：
     */
    @SerializedName("resource")
    private Resource resource;
    /**
     * 附件上传者
     * <p> 示例值：
     */
    @SerializedName("uploader")
    private Member uploader;
    /**
     * 是否是封面图
     * <p> 示例值：false
     */
    @SerializedName("is_cover")
    private Boolean isCover;
    /**
     * 上传时间戳(ms)
     * <p> 示例值：1675742789470
     */
    @SerializedName("uploaded_at")
    private String uploadedAt;
    /**
     * 附件的临时下载url，有效时间3分钟，且只允许调用3次进行附件下载。只有在获取附件时会动态生成。
     * <p> 示例值：https://example.com/download/authcode/?code=OWMzNDlmMjJmZThkYzZkZGJlMjYwZTI0OTUxZTE2MDJfMDZmZmMwOWVj
     */
    @SerializedName("url")
    private String url;

    // builder 开始
    public Attachment() {
    }

    public Attachment(Builder builder) {
        /**
         * 附件guid
         * <p> 示例值：f860de3e-6881-4ddd-9321-070f36d1af0b
         */
        this.guid = builder.guid;
        /**
         * 附件在云文档系统中的token
         * <p> 示例值：boxcnTDqPaRA6JbYnzQsZ2doB2b
         */
        this.fileToken = builder.fileToken;
        /**
         * 附件名
         * <p> 示例值：foo.jpg
         */
        this.name = builder.name;
        /**
         * 附件的字节大小
         * <p> 示例值：62232
         */
        this.size = builder.size;
        /**
         * 附件归属的资源
         * <p> 示例值：
         */
        this.resource = builder.resource;
        /**
         * 附件上传者
         * <p> 示例值：
         */
        this.uploader = builder.uploader;
        /**
         * 是否是封面图
         * <p> 示例值：false
         */
        this.isCover = builder.isCover;
        /**
         * 上传时间戳(ms)
         * <p> 示例值：1675742789470
         */
        this.uploadedAt = builder.uploadedAt;
        /**
         * 附件的临时下载url，有效时间3分钟，且只允许调用3次进行附件下载。只有在获取附件时会动态生成。
         * <p> 示例值：https://example.com/download/authcode/?code=OWMzNDlmMjJmZThkYzZkZGJlMjYwZTI0OTUxZTE2MDJfMDZmZmMwOWVj
         */
        this.url = builder.url;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getFileToken() {
        return this.fileToken;
    }

    public void setFileToken(String fileToken) {
        this.fileToken = fileToken;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Member getUploader() {
        return this.uploader;
    }

    public void setUploader(Member uploader) {
        this.uploader = uploader;
    }

    public Boolean getIsCover() {
        return this.isCover;
    }

    public void setIsCover(Boolean isCover) {
        this.isCover = isCover;
    }

    public String getUploadedAt() {
        return this.uploadedAt;
    }

    public void setUploadedAt(String uploadedAt) {
        this.uploadedAt = uploadedAt;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static class Builder {
        /**
         * 附件guid
         * <p> 示例值：f860de3e-6881-4ddd-9321-070f36d1af0b
         */
        private String guid;
        /**
         * 附件在云文档系统中的token
         * <p> 示例值：boxcnTDqPaRA6JbYnzQsZ2doB2b
         */
        private String fileToken;
        /**
         * 附件名
         * <p> 示例值：foo.jpg
         */
        private String name;
        /**
         * 附件的字节大小
         * <p> 示例值：62232
         */
        private Integer size;
        /**
         * 附件归属的资源
         * <p> 示例值：
         */
        private Resource resource;
        /**
         * 附件上传者
         * <p> 示例值：
         */
        private Member uploader;
        /**
         * 是否是封面图
         * <p> 示例值：false
         */
        private Boolean isCover;
        /**
         * 上传时间戳(ms)
         * <p> 示例值：1675742789470
         */
        private String uploadedAt;
        /**
         * 附件的临时下载url，有效时间3分钟，且只允许调用3次进行附件下载。只有在获取附件时会动态生成。
         * <p> 示例值：https://example.com/download/authcode/?code=OWMzNDlmMjJmZThkYzZkZGJlMjYwZTI0OTUxZTE2MDJfMDZmZmMwOWVj
         */
        private String url;

        /**
         * 附件guid
         * <p> 示例值：f860de3e-6881-4ddd-9321-070f36d1af0b
         *
         * @param guid
         * @return
         */
        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }


        /**
         * 附件在云文档系统中的token
         * <p> 示例值：boxcnTDqPaRA6JbYnzQsZ2doB2b
         *
         * @param fileToken
         * @return
         */
        public Builder fileToken(String fileToken) {
            this.fileToken = fileToken;
            return this;
        }


        /**
         * 附件名
         * <p> 示例值：foo.jpg
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 附件的字节大小
         * <p> 示例值：62232
         *
         * @param size
         * @return
         */
        public Builder size(Integer size) {
            this.size = size;
            return this;
        }


        /**
         * 附件归属的资源
         * <p> 示例值：
         *
         * @param resource
         * @return
         */
        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }


        /**
         * 附件上传者
         * <p> 示例值：
         *
         * @param uploader
         * @return
         */
        public Builder uploader(Member uploader) {
            this.uploader = uploader;
            return this;
        }


        /**
         * 是否是封面图
         * <p> 示例值：false
         *
         * @param isCover
         * @return
         */
        public Builder isCover(Boolean isCover) {
            this.isCover = isCover;
            return this;
        }


        /**
         * 上传时间戳(ms)
         * <p> 示例值：1675742789470
         *
         * @param uploadedAt
         * @return
         */
        public Builder uploadedAt(String uploadedAt) {
            this.uploadedAt = uploadedAt;
            return this;
        }


        /**
         * 附件的临时下载url，有效时间3分钟，且只允许调用3次进行附件下载。只有在获取附件时会动态生成。
         * <p> 示例值：https://example.com/download/authcode/?code=OWMzNDlmMjJmZThkYzZkZGJlMjYwZTI0OTUxZTE2MDJfMDZmZmMwOWVj
         *
         * @param url
         * @return
         */
        public Builder url(String url) {
            this.url = url;
            return this;
        }


        public Attachment build() {
            return new Attachment(this);
        }
    }
}
