// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.authen.v1.model;

import com.google.gson.annotations.SerializedName;

public class TokenInfo {
    /**
     * user_access_token，用于获取用户资源和访问某些open api
     * <p> 示例值：u-5Dak9ZAxJ9tFUn8MaTD_BFM51FNdg5xzO0y010000HWb
     */
    @SerializedName("access_token")
    private String accessToken;
    /**
     * 刷新用户 `access_token` 时使用的 token
     * <p> 示例值：ur-6EyFQZyplb9URrOx5NtT_HM53zrJg59HXwy040400G.e
     */
    @SerializedName("refresh_token")
    private String refreshToken;
    /**
     * token 类型，固定值
     * <p> 示例值：Bearer
     */
    @SerializedName("token_type")
    private String tokenType;
    /**
     * `access_token`的有效期，单位: 秒，一般是两个小时左右，需要以返回结果为准
     * <p> 示例值：7199
     */
    @SerializedName("expires_in")
    private Integer expiresIn;
    /**
     * `refresh_token` 的有效期，单位: 秒，一般是30天左右，需要以返回结果为准
     * <p> 示例值：2591999
     */
    @SerializedName("refresh_expires_in")
    private Integer refreshExpiresIn;
    /**
     * 用户授予app的权限全集
     * <p> 示例值：auth:user.id:read bitable:app
     */
    @SerializedName("scope")
    private String scope;

    // builder 开始
    public TokenInfo() {
    }

    public TokenInfo(Builder builder) {
        /**
         * user_access_token，用于获取用户资源和访问某些open api
         * <p> 示例值：u-5Dak9ZAxJ9tFUn8MaTD_BFM51FNdg5xzO0y010000HWb
         */
        this.accessToken = builder.accessToken;
        /**
         * 刷新用户 `access_token` 时使用的 token
         * <p> 示例值：ur-6EyFQZyplb9URrOx5NtT_HM53zrJg59HXwy040400G.e
         */
        this.refreshToken = builder.refreshToken;
        /**
         * token 类型，固定值
         * <p> 示例值：Bearer
         */
        this.tokenType = builder.tokenType;
        /**
         * `access_token`的有效期，单位: 秒，一般是两个小时左右，需要以返回结果为准
         * <p> 示例值：7199
         */
        this.expiresIn = builder.expiresIn;
        /**
         * `refresh_token` 的有效期，单位: 秒，一般是30天左右，需要以返回结果为准
         * <p> 示例值：2591999
         */
        this.refreshExpiresIn = builder.refreshExpiresIn;
        /**
         * 用户授予app的权限全集
         * <p> 示例值：auth:user.id:read bitable:app
         */
        this.scope = builder.scope;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Integer getRefreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    public void setRefreshExpiresIn(Integer refreshExpiresIn) {
        this.refreshExpiresIn = refreshExpiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public static class Builder {
        /**
         * user_access_token，用于获取用户资源和访问某些open api
         * <p> 示例值：u-5Dak9ZAxJ9tFUn8MaTD_BFM51FNdg5xzO0y010000HWb
         */
        private String accessToken;
        /**
         * 刷新用户 `access_token` 时使用的 token
         * <p> 示例值：ur-6EyFQZyplb9URrOx5NtT_HM53zrJg59HXwy040400G.e
         */
        private String refreshToken;
        /**
         * token 类型，固定值
         * <p> 示例值：Bearer
         */
        private String tokenType;
        /**
         * `access_token`的有效期，单位: 秒，一般是两个小时左右，需要以返回结果为准
         * <p> 示例值：7199
         */
        private Integer expiresIn;
        /**
         * `refresh_token` 的有效期，单位: 秒，一般是30天左右，需要以返回结果为准
         * <p> 示例值：2591999
         */
        private Integer refreshExpiresIn;
        /**
         * 用户授予app的权限全集
         * <p> 示例值：auth:user.id:read bitable:app
         */
        private String scope;

        /**
         * user_access_token，用于获取用户资源和访问某些open api
         * <p> 示例值：u-5Dak9ZAxJ9tFUn8MaTD_BFM51FNdg5xzO0y010000HWb
         *
         * @param accessToken
         * @return
         */
        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }


        /**
         * 刷新用户 `access_token` 时使用的 token
         * <p> 示例值：ur-6EyFQZyplb9URrOx5NtT_HM53zrJg59HXwy040400G.e
         *
         * @param refreshToken
         * @return
         */
        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }


        /**
         * token 类型，固定值
         * <p> 示例值：Bearer
         *
         * @param tokenType
         * @return
         */
        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }


        /**
         * `access_token`的有效期，单位: 秒，一般是两个小时左右，需要以返回结果为准
         * <p> 示例值：7199
         *
         * @param expiresIn
         * @return
         */
        public Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }


        /**
         * `refresh_token` 的有效期，单位: 秒，一般是30天左右，需要以返回结果为准
         * <p> 示例值：2591999
         *
         * @param refreshExpiresIn
         * @return
         */
        public Builder refreshExpiresIn(Integer refreshExpiresIn) {
            this.refreshExpiresIn = refreshExpiresIn;
            return this;
        }


        /**
         * 用户授予app的权限全集
         * <p> 示例值：auth:user.id:read bitable:app
         *
         * @param scope
         * @return
         */
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }


        public TokenInfo build() {
            return new TokenInfo(this);
        }
    }
}
