// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class TransferInfo {
    /**
     * 备注
     * <p> 示例值：异动详情
     */
    @SerializedName("remark")
    private String remark;
    /**
     * offer信息
     * <p> 示例值：优质人才，加急处理
     */
    @SerializedName("offer_info")
    private String offerInfo;
    /**
     * 是否撤销虚线上级
     * <p> 示例值：true
     */
    @SerializedName("target_dotted_manager_clean")
    private Boolean targetDottedManagerClean;
    /**
     * 是否有试用期
     * <p> 示例值：false
     */
    @SerializedName("probation_exist")
    private Boolean probationExist;
    /**
     * 原部门
     * <p> 示例值：6966236933198579208
     */
    @SerializedName("original_department")
    private String originalDepartment;
    /**
     * 新部门
     * <p> 示例值：6966236933198579208
     */
    @SerializedName("target_department")
    private String targetDepartment;
    /**
     * 原工作地点
     * <p> 示例值：6967271100992587295
     */
    @SerializedName("original_work_location")
    private String originalWorkLocation;
    /**
     * 新工作地点
     * <p> 示例值：6967271100992587295
     */
    @SerializedName("target_work_location")
    private String targetWorkLocation;
    /**
     * 原直属上级
     * <p> 示例值：6974641477444060708
     */
    @SerializedName("original_direct_manager")
    private String originalDirectManager;
    /**
     * 新直属上级
     * <p> 示例值：7013619729281713671
     */
    @SerializedName("target_direct_manager")
    private String targetDirectManager;
    /**
     * 原虚线上级
     * <p> 示例值：6974648866876573198
     */
    @SerializedName("original_dotted_manager")
    private String originalDottedManager;
    /**
     * 新虚线上级
     * <p> 示例值：7013328578351842852
     */
    @SerializedName("target_dotted_manager")
    private String targetDottedManager;
    /**
     * 原职务
     * <p> 示例值：6969469398088287751
     */
    @SerializedName("original_job")
    private String originalJob;
    /**
     * 新职务
     * <p> 示例值：6969469557836760606
     */
    @SerializedName("target_job")
    private String targetJob;
    /**
     * 原序列
     * <p> 示例值：6967287547462419975
     */
    @SerializedName("original_job_family")
    private String originalJobFamily;
    /**
     * 新序列
     * <p> 示例值：6967287547462419975
     */
    @SerializedName("target_job_family")
    private String targetJobFamily;
    /**
     * 原级别
     * <p> 示例值：6972085707674355214
     */
    @SerializedName("original_job_level")
    private String originalJobLevel;
    /**
     * 新级别
     * <p> 示例值：6972085707674355214
     */
    @SerializedName("target_job_level")
    private String targetJobLevel;
    /**
     * 原人员类型
     * <p> 示例值：6968386026792289828
     */
    @SerializedName("original_workforce_type")
    private String originalWorkforceType;
    /**
     * 新人员类型
     * <p> 示例值：7036268995372303885
     */
    @SerializedName("target_workforce_type")
    private String targetWorkforceType;
    /**
     * 原公司
     * <p> 示例值：6974659700705068581
     */
    @SerializedName("original_company")
    private String originalCompany;
    /**
     * 新公司
     * <p> 示例值：6974659700705068581
     */
    @SerializedName("target_company")
    private String targetCompany;
    /**
     * 原合同编号
     * <p> 示例值：55332
     */
    @SerializedName("original_contract_number")
    private String originalContractNumber;
    /**
     * 新合同编号
     * <p> 示例值：55333
     */
    @SerializedName("target_contract_number")
    private String targetContractNumber;
    /**
     * 原合同类型
     * <p> 示例值：labor_contract
     */
    @SerializedName("original_contract_type")
    private String originalContractType;
    /**
     * 新合同类型
     * <p> 示例值：labor_contract
     */
    @SerializedName("target_contract_type")
    private String targetContractType;
    /**
     * 原期限类型
     * <p> 示例值：fixed_term
     */
    @SerializedName("original_duration_type")
    private String originalDurationType;
    /**
     * 新期限类型
     * <p> 示例值：fixed_term
     */
    @SerializedName("target_duration_type")
    private String targetDurationType;
    /**
     * 原签订类型
     * <p> 示例值：new
     */
    @SerializedName("original_signing_type")
    private String originalSigningType;
    /**
     * 新签订类型
     * <p> 示例值：new
     */
    @SerializedName("target_signing_type")
    private String targetSigningType;
    /**
     * 原合同开始日期
     * <p> 示例值：2021-07-01
     */
    @SerializedName("original_contract_start_date")
    private String originalContractStartDate;
    /**
     * 新合同开始日期
     * <p> 示例值：2021-07-01
     */
    @SerializedName("target_contract_start_date")
    private String targetContractStartDate;
    /**
     * 原合同结束日期
     * <p> 示例值：2024-07-01
     */
    @SerializedName("original_contract_end_date")
    private String originalContractEndDate;
    /**
     * 新合同结束日期
     * <p> 示例值：2024-07-01
     */
    @SerializedName("target_contract_end_date")
    private String targetContractEndDate;
    /**
     * 原工时制度
     * <p> 示例值：6969087376740206087
     */
    @SerializedName("original_working_hours_type")
    private String originalWorkingHoursType;
    /**
     * 新工时制度
     * <p> 示例值：6969087376740206087
     */
    @SerializedName("target_working_hours_type")
    private String targetWorkingHoursType;
    /**
     * 原工作日历
     * <p> 示例值：6969087376740236087
     */
    @SerializedName("original_working_calendar")
    private String originalWorkingCalendar;
    /**
     * 新工作日历
     * <p> 示例值：6969087376740236087
     */
    @SerializedName("target_working_calendar")
    private String targetWorkingCalendar;
    /**
     * 原试用期预计结束日期
     * <p> 示例值：2021-11-17
     */
    @SerializedName("original_probation_end_date")
    private String originalProbationEndDate;
    /**
     * 新试用期预计结束日期
     * <p> 示例值：2021-11-17
     */
    @SerializedName("target_probation_end_date")
    private String targetProbationEndDate;
    /**
     * 原周工作时长
     * <p> 示例值：162
     */
    @SerializedName("original_weekly_working_hours")
    private String originalWeeklyWorkingHours;
    /**
     * 新周工作时长
     * <p> 示例值：160
     */
    @SerializedName("target_weekly_working_hours")
    private String targetWeeklyWorkingHours;
    /**
     * 原排班
     * <p> 示例值：work_shift
     */
    @SerializedName("original_work_shift")
    private String originalWorkShift;
    /**
     * 新排班
     * <p> 示例值：non_work_shift
     */
    @SerializedName("target_work_shift")
    private String targetWorkShift;
    /**
     * 原成本中心分摊信息
     * <p> 示例值：
     */
    @SerializedName("original_cost_center_rate")
    private SupportCostCenterItem[] originalCostCenterRate;
    /**
     * 新成本中心分摊信息
     * <p> 示例值：
     */
    @SerializedName("target_cost_center_rate")
    private SupportCostCenterItem[] targetCostCenterRate;
    /**
     * 原工作信息
     * <p> 示例值：
     */
    @SerializedName("original_employment_change")
    private TranferEmploymentInfo originalEmploymentChange;
    /**
     * 新工作信息
     * <p> 示例值：
     */
    @SerializedName("target_employment_change")
    private TranferEmploymentInfo targetEmploymentChange;
    /**
     * 原职等
     * <p> 示例值：7289005963599693366
     */
    @SerializedName("original_job_grade")
    private String originalJobGrade;
    /**
     * 新职等
     * <p> 示例值：7289005963599693366
     */
    @SerializedName("target_job_grade")
    private String targetJobGrade;

    // builder 开始
    public TransferInfo() {
    }

    public TransferInfo(Builder builder) {
        /**
         * 备注
         * <p> 示例值：异动详情
         */
        this.remark = builder.remark;
        /**
         * offer信息
         * <p> 示例值：优质人才，加急处理
         */
        this.offerInfo = builder.offerInfo;
        /**
         * 是否撤销虚线上级
         * <p> 示例值：true
         */
        this.targetDottedManagerClean = builder.targetDottedManagerClean;
        /**
         * 是否有试用期
         * <p> 示例值：false
         */
        this.probationExist = builder.probationExist;
        /**
         * 原部门
         * <p> 示例值：6966236933198579208
         */
        this.originalDepartment = builder.originalDepartment;
        /**
         * 新部门
         * <p> 示例值：6966236933198579208
         */
        this.targetDepartment = builder.targetDepartment;
        /**
         * 原工作地点
         * <p> 示例值：6967271100992587295
         */
        this.originalWorkLocation = builder.originalWorkLocation;
        /**
         * 新工作地点
         * <p> 示例值：6967271100992587295
         */
        this.targetWorkLocation = builder.targetWorkLocation;
        /**
         * 原直属上级
         * <p> 示例值：6974641477444060708
         */
        this.originalDirectManager = builder.originalDirectManager;
        /**
         * 新直属上级
         * <p> 示例值：7013619729281713671
         */
        this.targetDirectManager = builder.targetDirectManager;
        /**
         * 原虚线上级
         * <p> 示例值：6974648866876573198
         */
        this.originalDottedManager = builder.originalDottedManager;
        /**
         * 新虚线上级
         * <p> 示例值：7013328578351842852
         */
        this.targetDottedManager = builder.targetDottedManager;
        /**
         * 原职务
         * <p> 示例值：6969469398088287751
         */
        this.originalJob = builder.originalJob;
        /**
         * 新职务
         * <p> 示例值：6969469557836760606
         */
        this.targetJob = builder.targetJob;
        /**
         * 原序列
         * <p> 示例值：6967287547462419975
         */
        this.originalJobFamily = builder.originalJobFamily;
        /**
         * 新序列
         * <p> 示例值：6967287547462419975
         */
        this.targetJobFamily = builder.targetJobFamily;
        /**
         * 原级别
         * <p> 示例值：6972085707674355214
         */
        this.originalJobLevel = builder.originalJobLevel;
        /**
         * 新级别
         * <p> 示例值：6972085707674355214
         */
        this.targetJobLevel = builder.targetJobLevel;
        /**
         * 原人员类型
         * <p> 示例值：6968386026792289828
         */
        this.originalWorkforceType = builder.originalWorkforceType;
        /**
         * 新人员类型
         * <p> 示例值：7036268995372303885
         */
        this.targetWorkforceType = builder.targetWorkforceType;
        /**
         * 原公司
         * <p> 示例值：6974659700705068581
         */
        this.originalCompany = builder.originalCompany;
        /**
         * 新公司
         * <p> 示例值：6974659700705068581
         */
        this.targetCompany = builder.targetCompany;
        /**
         * 原合同编号
         * <p> 示例值：55332
         */
        this.originalContractNumber = builder.originalContractNumber;
        /**
         * 新合同编号
         * <p> 示例值：55333
         */
        this.targetContractNumber = builder.targetContractNumber;
        /**
         * 原合同类型
         * <p> 示例值：labor_contract
         */
        this.originalContractType = builder.originalContractType;
        /**
         * 新合同类型
         * <p> 示例值：labor_contract
         */
        this.targetContractType = builder.targetContractType;
        /**
         * 原期限类型
         * <p> 示例值：fixed_term
         */
        this.originalDurationType = builder.originalDurationType;
        /**
         * 新期限类型
         * <p> 示例值：fixed_term
         */
        this.targetDurationType = builder.targetDurationType;
        /**
         * 原签订类型
         * <p> 示例值：new
         */
        this.originalSigningType = builder.originalSigningType;
        /**
         * 新签订类型
         * <p> 示例值：new
         */
        this.targetSigningType = builder.targetSigningType;
        /**
         * 原合同开始日期
         * <p> 示例值：2021-07-01
         */
        this.originalContractStartDate = builder.originalContractStartDate;
        /**
         * 新合同开始日期
         * <p> 示例值：2021-07-01
         */
        this.targetContractStartDate = builder.targetContractStartDate;
        /**
         * 原合同结束日期
         * <p> 示例值：2024-07-01
         */
        this.originalContractEndDate = builder.originalContractEndDate;
        /**
         * 新合同结束日期
         * <p> 示例值：2024-07-01
         */
        this.targetContractEndDate = builder.targetContractEndDate;
        /**
         * 原工时制度
         * <p> 示例值：6969087376740206087
         */
        this.originalWorkingHoursType = builder.originalWorkingHoursType;
        /**
         * 新工时制度
         * <p> 示例值：6969087376740206087
         */
        this.targetWorkingHoursType = builder.targetWorkingHoursType;
        /**
         * 原工作日历
         * <p> 示例值：6969087376740236087
         */
        this.originalWorkingCalendar = builder.originalWorkingCalendar;
        /**
         * 新工作日历
         * <p> 示例值：6969087376740236087
         */
        this.targetWorkingCalendar = builder.targetWorkingCalendar;
        /**
         * 原试用期预计结束日期
         * <p> 示例值：2021-11-17
         */
        this.originalProbationEndDate = builder.originalProbationEndDate;
        /**
         * 新试用期预计结束日期
         * <p> 示例值：2021-11-17
         */
        this.targetProbationEndDate = builder.targetProbationEndDate;
        /**
         * 原周工作时长
         * <p> 示例值：162
         */
        this.originalWeeklyWorkingHours = builder.originalWeeklyWorkingHours;
        /**
         * 新周工作时长
         * <p> 示例值：160
         */
        this.targetWeeklyWorkingHours = builder.targetWeeklyWorkingHours;
        /**
         * 原排班
         * <p> 示例值：work_shift
         */
        this.originalWorkShift = builder.originalWorkShift;
        /**
         * 新排班
         * <p> 示例值：non_work_shift
         */
        this.targetWorkShift = builder.targetWorkShift;
        /**
         * 原成本中心分摊信息
         * <p> 示例值：
         */
        this.originalCostCenterRate = builder.originalCostCenterRate;
        /**
         * 新成本中心分摊信息
         * <p> 示例值：
         */
        this.targetCostCenterRate = builder.targetCostCenterRate;
        /**
         * 原工作信息
         * <p> 示例值：
         */
        this.originalEmploymentChange = builder.originalEmploymentChange;
        /**
         * 新工作信息
         * <p> 示例值：
         */
        this.targetEmploymentChange = builder.targetEmploymentChange;
        /**
         * 原职等
         * <p> 示例值：7289005963599693366
         */
        this.originalJobGrade = builder.originalJobGrade;
        /**
         * 新职等
         * <p> 示例值：7289005963599693366
         */
        this.targetJobGrade = builder.targetJobGrade;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOfferInfo() {
        return this.offerInfo;
    }

    public void setOfferInfo(String offerInfo) {
        this.offerInfo = offerInfo;
    }

    public Boolean getTargetDottedManagerClean() {
        return this.targetDottedManagerClean;
    }

    public void setTargetDottedManagerClean(Boolean targetDottedManagerClean) {
        this.targetDottedManagerClean = targetDottedManagerClean;
    }

    public Boolean getProbationExist() {
        return this.probationExist;
    }

    public void setProbationExist(Boolean probationExist) {
        this.probationExist = probationExist;
    }

    public String getOriginalDepartment() {
        return this.originalDepartment;
    }

    public void setOriginalDepartment(String originalDepartment) {
        this.originalDepartment = originalDepartment;
    }

    public String getTargetDepartment() {
        return this.targetDepartment;
    }

    public void setTargetDepartment(String targetDepartment) {
        this.targetDepartment = targetDepartment;
    }

    public String getOriginalWorkLocation() {
        return this.originalWorkLocation;
    }

    public void setOriginalWorkLocation(String originalWorkLocation) {
        this.originalWorkLocation = originalWorkLocation;
    }

    public String getTargetWorkLocation() {
        return this.targetWorkLocation;
    }

    public void setTargetWorkLocation(String targetWorkLocation) {
        this.targetWorkLocation = targetWorkLocation;
    }

    public String getOriginalDirectManager() {
        return this.originalDirectManager;
    }

    public void setOriginalDirectManager(String originalDirectManager) {
        this.originalDirectManager = originalDirectManager;
    }

    public String getTargetDirectManager() {
        return this.targetDirectManager;
    }

    public void setTargetDirectManager(String targetDirectManager) {
        this.targetDirectManager = targetDirectManager;
    }

    public String getOriginalDottedManager() {
        return this.originalDottedManager;
    }

    public void setOriginalDottedManager(String originalDottedManager) {
        this.originalDottedManager = originalDottedManager;
    }

    public String getTargetDottedManager() {
        return this.targetDottedManager;
    }

    public void setTargetDottedManager(String targetDottedManager) {
        this.targetDottedManager = targetDottedManager;
    }

    public String getOriginalJob() {
        return this.originalJob;
    }

    public void setOriginalJob(String originalJob) {
        this.originalJob = originalJob;
    }

    public String getTargetJob() {
        return this.targetJob;
    }

    public void setTargetJob(String targetJob) {
        this.targetJob = targetJob;
    }

    public String getOriginalJobFamily() {
        return this.originalJobFamily;
    }

    public void setOriginalJobFamily(String originalJobFamily) {
        this.originalJobFamily = originalJobFamily;
    }

    public String getTargetJobFamily() {
        return this.targetJobFamily;
    }

    public void setTargetJobFamily(String targetJobFamily) {
        this.targetJobFamily = targetJobFamily;
    }

    public String getOriginalJobLevel() {
        return this.originalJobLevel;
    }

    public void setOriginalJobLevel(String originalJobLevel) {
        this.originalJobLevel = originalJobLevel;
    }

    public String getTargetJobLevel() {
        return this.targetJobLevel;
    }

    public void setTargetJobLevel(String targetJobLevel) {
        this.targetJobLevel = targetJobLevel;
    }

    public String getOriginalWorkforceType() {
        return this.originalWorkforceType;
    }

    public void setOriginalWorkforceType(String originalWorkforceType) {
        this.originalWorkforceType = originalWorkforceType;
    }

    public String getTargetWorkforceType() {
        return this.targetWorkforceType;
    }

    public void setTargetWorkforceType(String targetWorkforceType) {
        this.targetWorkforceType = targetWorkforceType;
    }

    public String getOriginalCompany() {
        return this.originalCompany;
    }

    public void setOriginalCompany(String originalCompany) {
        this.originalCompany = originalCompany;
    }

    public String getTargetCompany() {
        return this.targetCompany;
    }

    public void setTargetCompany(String targetCompany) {
        this.targetCompany = targetCompany;
    }

    public String getOriginalContractNumber() {
        return this.originalContractNumber;
    }

    public void setOriginalContractNumber(String originalContractNumber) {
        this.originalContractNumber = originalContractNumber;
    }

    public String getTargetContractNumber() {
        return this.targetContractNumber;
    }

    public void setTargetContractNumber(String targetContractNumber) {
        this.targetContractNumber = targetContractNumber;
    }

    public String getOriginalContractType() {
        return this.originalContractType;
    }

    public void setOriginalContractType(String originalContractType) {
        this.originalContractType = originalContractType;
    }

    public String getTargetContractType() {
        return this.targetContractType;
    }

    public void setTargetContractType(String targetContractType) {
        this.targetContractType = targetContractType;
    }

    public String getOriginalDurationType() {
        return this.originalDurationType;
    }

    public void setOriginalDurationType(String originalDurationType) {
        this.originalDurationType = originalDurationType;
    }

    public String getTargetDurationType() {
        return this.targetDurationType;
    }

    public void setTargetDurationType(String targetDurationType) {
        this.targetDurationType = targetDurationType;
    }

    public String getOriginalSigningType() {
        return this.originalSigningType;
    }

    public void setOriginalSigningType(String originalSigningType) {
        this.originalSigningType = originalSigningType;
    }

    public String getTargetSigningType() {
        return this.targetSigningType;
    }

    public void setTargetSigningType(String targetSigningType) {
        this.targetSigningType = targetSigningType;
    }

    public String getOriginalContractStartDate() {
        return this.originalContractStartDate;
    }

    public void setOriginalContractStartDate(String originalContractStartDate) {
        this.originalContractStartDate = originalContractStartDate;
    }

    public String getTargetContractStartDate() {
        return this.targetContractStartDate;
    }

    public void setTargetContractStartDate(String targetContractStartDate) {
        this.targetContractStartDate = targetContractStartDate;
    }

    public String getOriginalContractEndDate() {
        return this.originalContractEndDate;
    }

    public void setOriginalContractEndDate(String originalContractEndDate) {
        this.originalContractEndDate = originalContractEndDate;
    }

    public String getTargetContractEndDate() {
        return this.targetContractEndDate;
    }

    public void setTargetContractEndDate(String targetContractEndDate) {
        this.targetContractEndDate = targetContractEndDate;
    }

    public String getOriginalWorkingHoursType() {
        return this.originalWorkingHoursType;
    }

    public void setOriginalWorkingHoursType(String originalWorkingHoursType) {
        this.originalWorkingHoursType = originalWorkingHoursType;
    }

    public String getTargetWorkingHoursType() {
        return this.targetWorkingHoursType;
    }

    public void setTargetWorkingHoursType(String targetWorkingHoursType) {
        this.targetWorkingHoursType = targetWorkingHoursType;
    }

    public String getOriginalWorkingCalendar() {
        return this.originalWorkingCalendar;
    }

    public void setOriginalWorkingCalendar(String originalWorkingCalendar) {
        this.originalWorkingCalendar = originalWorkingCalendar;
    }

    public String getTargetWorkingCalendar() {
        return this.targetWorkingCalendar;
    }

    public void setTargetWorkingCalendar(String targetWorkingCalendar) {
        this.targetWorkingCalendar = targetWorkingCalendar;
    }

    public String getOriginalProbationEndDate() {
        return this.originalProbationEndDate;
    }

    public void setOriginalProbationEndDate(String originalProbationEndDate) {
        this.originalProbationEndDate = originalProbationEndDate;
    }

    public String getTargetProbationEndDate() {
        return this.targetProbationEndDate;
    }

    public void setTargetProbationEndDate(String targetProbationEndDate) {
        this.targetProbationEndDate = targetProbationEndDate;
    }

    public String getOriginalWeeklyWorkingHours() {
        return this.originalWeeklyWorkingHours;
    }

    public void setOriginalWeeklyWorkingHours(String originalWeeklyWorkingHours) {
        this.originalWeeklyWorkingHours = originalWeeklyWorkingHours;
    }

    public String getTargetWeeklyWorkingHours() {
        return this.targetWeeklyWorkingHours;
    }

    public void setTargetWeeklyWorkingHours(String targetWeeklyWorkingHours) {
        this.targetWeeklyWorkingHours = targetWeeklyWorkingHours;
    }

    public String getOriginalWorkShift() {
        return this.originalWorkShift;
    }

    public void setOriginalWorkShift(String originalWorkShift) {
        this.originalWorkShift = originalWorkShift;
    }

    public String getTargetWorkShift() {
        return this.targetWorkShift;
    }

    public void setTargetWorkShift(String targetWorkShift) {
        this.targetWorkShift = targetWorkShift;
    }

    public SupportCostCenterItem[] getOriginalCostCenterRate() {
        return this.originalCostCenterRate;
    }

    public void setOriginalCostCenterRate(SupportCostCenterItem[] originalCostCenterRate) {
        this.originalCostCenterRate = originalCostCenterRate;
    }

    public SupportCostCenterItem[] getTargetCostCenterRate() {
        return this.targetCostCenterRate;
    }

    public void setTargetCostCenterRate(SupportCostCenterItem[] targetCostCenterRate) {
        this.targetCostCenterRate = targetCostCenterRate;
    }

    public TranferEmploymentInfo getOriginalEmploymentChange() {
        return this.originalEmploymentChange;
    }

    public void setOriginalEmploymentChange(TranferEmploymentInfo originalEmploymentChange) {
        this.originalEmploymentChange = originalEmploymentChange;
    }

    public TranferEmploymentInfo getTargetEmploymentChange() {
        return this.targetEmploymentChange;
    }

    public void setTargetEmploymentChange(TranferEmploymentInfo targetEmploymentChange) {
        this.targetEmploymentChange = targetEmploymentChange;
    }

    public String getOriginalJobGrade() {
        return this.originalJobGrade;
    }

    public void setOriginalJobGrade(String originalJobGrade) {
        this.originalJobGrade = originalJobGrade;
    }

    public String getTargetJobGrade() {
        return this.targetJobGrade;
    }

    public void setTargetJobGrade(String targetJobGrade) {
        this.targetJobGrade = targetJobGrade;
    }

    public static class Builder {
        /**
         * 备注
         * <p> 示例值：异动详情
         */
        private String remark;
        /**
         * offer信息
         * <p> 示例值：优质人才，加急处理
         */
        private String offerInfo;
        /**
         * 是否撤销虚线上级
         * <p> 示例值：true
         */
        private Boolean targetDottedManagerClean;
        /**
         * 是否有试用期
         * <p> 示例值：false
         */
        private Boolean probationExist;
        /**
         * 原部门
         * <p> 示例值：6966236933198579208
         */
        private String originalDepartment;
        /**
         * 新部门
         * <p> 示例值：6966236933198579208
         */
        private String targetDepartment;
        /**
         * 原工作地点
         * <p> 示例值：6967271100992587295
         */
        private String originalWorkLocation;
        /**
         * 新工作地点
         * <p> 示例值：6967271100992587295
         */
        private String targetWorkLocation;
        /**
         * 原直属上级
         * <p> 示例值：6974641477444060708
         */
        private String originalDirectManager;
        /**
         * 新直属上级
         * <p> 示例值：7013619729281713671
         */
        private String targetDirectManager;
        /**
         * 原虚线上级
         * <p> 示例值：6974648866876573198
         */
        private String originalDottedManager;
        /**
         * 新虚线上级
         * <p> 示例值：7013328578351842852
         */
        private String targetDottedManager;
        /**
         * 原职务
         * <p> 示例值：6969469398088287751
         */
        private String originalJob;
        /**
         * 新职务
         * <p> 示例值：6969469557836760606
         */
        private String targetJob;
        /**
         * 原序列
         * <p> 示例值：6967287547462419975
         */
        private String originalJobFamily;
        /**
         * 新序列
         * <p> 示例值：6967287547462419975
         */
        private String targetJobFamily;
        /**
         * 原级别
         * <p> 示例值：6972085707674355214
         */
        private String originalJobLevel;
        /**
         * 新级别
         * <p> 示例值：6972085707674355214
         */
        private String targetJobLevel;
        /**
         * 原人员类型
         * <p> 示例值：6968386026792289828
         */
        private String originalWorkforceType;
        /**
         * 新人员类型
         * <p> 示例值：7036268995372303885
         */
        private String targetWorkforceType;
        /**
         * 原公司
         * <p> 示例值：6974659700705068581
         */
        private String originalCompany;
        /**
         * 新公司
         * <p> 示例值：6974659700705068581
         */
        private String targetCompany;
        /**
         * 原合同编号
         * <p> 示例值：55332
         */
        private String originalContractNumber;
        /**
         * 新合同编号
         * <p> 示例值：55333
         */
        private String targetContractNumber;
        /**
         * 原合同类型
         * <p> 示例值：labor_contract
         */
        private String originalContractType;
        /**
         * 新合同类型
         * <p> 示例值：labor_contract
         */
        private String targetContractType;
        /**
         * 原期限类型
         * <p> 示例值：fixed_term
         */
        private String originalDurationType;
        /**
         * 新期限类型
         * <p> 示例值：fixed_term
         */
        private String targetDurationType;
        /**
         * 原签订类型
         * <p> 示例值：new
         */
        private String originalSigningType;
        /**
         * 新签订类型
         * <p> 示例值：new
         */
        private String targetSigningType;
        /**
         * 原合同开始日期
         * <p> 示例值：2021-07-01
         */
        private String originalContractStartDate;
        /**
         * 新合同开始日期
         * <p> 示例值：2021-07-01
         */
        private String targetContractStartDate;
        /**
         * 原合同结束日期
         * <p> 示例值：2024-07-01
         */
        private String originalContractEndDate;
        /**
         * 新合同结束日期
         * <p> 示例值：2024-07-01
         */
        private String targetContractEndDate;
        /**
         * 原工时制度
         * <p> 示例值：6969087376740206087
         */
        private String originalWorkingHoursType;
        /**
         * 新工时制度
         * <p> 示例值：6969087376740206087
         */
        private String targetWorkingHoursType;
        /**
         * 原工作日历
         * <p> 示例值：6969087376740236087
         */
        private String originalWorkingCalendar;
        /**
         * 新工作日历
         * <p> 示例值：6969087376740236087
         */
        private String targetWorkingCalendar;
        /**
         * 原试用期预计结束日期
         * <p> 示例值：2021-11-17
         */
        private String originalProbationEndDate;
        /**
         * 新试用期预计结束日期
         * <p> 示例值：2021-11-17
         */
        private String targetProbationEndDate;
        /**
         * 原周工作时长
         * <p> 示例值：162
         */
        private String originalWeeklyWorkingHours;
        /**
         * 新周工作时长
         * <p> 示例值：160
         */
        private String targetWeeklyWorkingHours;
        /**
         * 原排班
         * <p> 示例值：work_shift
         */
        private String originalWorkShift;
        /**
         * 新排班
         * <p> 示例值：non_work_shift
         */
        private String targetWorkShift;
        /**
         * 原成本中心分摊信息
         * <p> 示例值：
         */
        private SupportCostCenterItem[] originalCostCenterRate;
        /**
         * 新成本中心分摊信息
         * <p> 示例值：
         */
        private SupportCostCenterItem[] targetCostCenterRate;
        /**
         * 原工作信息
         * <p> 示例值：
         */
        private TranferEmploymentInfo originalEmploymentChange;
        /**
         * 新工作信息
         * <p> 示例值：
         */
        private TranferEmploymentInfo targetEmploymentChange;
        /**
         * 原职等
         * <p> 示例值：7289005963599693366
         */
        private String originalJobGrade;
        /**
         * 新职等
         * <p> 示例值：7289005963599693366
         */
        private String targetJobGrade;

        /**
         * 备注
         * <p> 示例值：异动详情
         *
         * @param remark
         * @return
         */
        public Builder remark(String remark) {
            this.remark = remark;
            return this;
        }


        /**
         * offer信息
         * <p> 示例值：优质人才，加急处理
         *
         * @param offerInfo
         * @return
         */
        public Builder offerInfo(String offerInfo) {
            this.offerInfo = offerInfo;
            return this;
        }


        /**
         * 是否撤销虚线上级
         * <p> 示例值：true
         *
         * @param targetDottedManagerClean
         * @return
         */
        public Builder targetDottedManagerClean(Boolean targetDottedManagerClean) {
            this.targetDottedManagerClean = targetDottedManagerClean;
            return this;
        }


        /**
         * 是否有试用期
         * <p> 示例值：false
         *
         * @param probationExist
         * @return
         */
        public Builder probationExist(Boolean probationExist) {
            this.probationExist = probationExist;
            return this;
        }


        /**
         * 原部门
         * <p> 示例值：6966236933198579208
         *
         * @param originalDepartment
         * @return
         */
        public Builder originalDepartment(String originalDepartment) {
            this.originalDepartment = originalDepartment;
            return this;
        }


        /**
         * 新部门
         * <p> 示例值：6966236933198579208
         *
         * @param targetDepartment
         * @return
         */
        public Builder targetDepartment(String targetDepartment) {
            this.targetDepartment = targetDepartment;
            return this;
        }


        /**
         * 原工作地点
         * <p> 示例值：6967271100992587295
         *
         * @param originalWorkLocation
         * @return
         */
        public Builder originalWorkLocation(String originalWorkLocation) {
            this.originalWorkLocation = originalWorkLocation;
            return this;
        }


        /**
         * 新工作地点
         * <p> 示例值：6967271100992587295
         *
         * @param targetWorkLocation
         * @return
         */
        public Builder targetWorkLocation(String targetWorkLocation) {
            this.targetWorkLocation = targetWorkLocation;
            return this;
        }


        /**
         * 原直属上级
         * <p> 示例值：6974641477444060708
         *
         * @param originalDirectManager
         * @return
         */
        public Builder originalDirectManager(String originalDirectManager) {
            this.originalDirectManager = originalDirectManager;
            return this;
        }


        /**
         * 新直属上级
         * <p> 示例值：7013619729281713671
         *
         * @param targetDirectManager
         * @return
         */
        public Builder targetDirectManager(String targetDirectManager) {
            this.targetDirectManager = targetDirectManager;
            return this;
        }


        /**
         * 原虚线上级
         * <p> 示例值：6974648866876573198
         *
         * @param originalDottedManager
         * @return
         */
        public Builder originalDottedManager(String originalDottedManager) {
            this.originalDottedManager = originalDottedManager;
            return this;
        }


        /**
         * 新虚线上级
         * <p> 示例值：7013328578351842852
         *
         * @param targetDottedManager
         * @return
         */
        public Builder targetDottedManager(String targetDottedManager) {
            this.targetDottedManager = targetDottedManager;
            return this;
        }


        /**
         * 原职务
         * <p> 示例值：6969469398088287751
         *
         * @param originalJob
         * @return
         */
        public Builder originalJob(String originalJob) {
            this.originalJob = originalJob;
            return this;
        }


        /**
         * 新职务
         * <p> 示例值：6969469557836760606
         *
         * @param targetJob
         * @return
         */
        public Builder targetJob(String targetJob) {
            this.targetJob = targetJob;
            return this;
        }


        /**
         * 原序列
         * <p> 示例值：6967287547462419975
         *
         * @param originalJobFamily
         * @return
         */
        public Builder originalJobFamily(String originalJobFamily) {
            this.originalJobFamily = originalJobFamily;
            return this;
        }


        /**
         * 新序列
         * <p> 示例值：6967287547462419975
         *
         * @param targetJobFamily
         * @return
         */
        public Builder targetJobFamily(String targetJobFamily) {
            this.targetJobFamily = targetJobFamily;
            return this;
        }


        /**
         * 原级别
         * <p> 示例值：6972085707674355214
         *
         * @param originalJobLevel
         * @return
         */
        public Builder originalJobLevel(String originalJobLevel) {
            this.originalJobLevel = originalJobLevel;
            return this;
        }


        /**
         * 新级别
         * <p> 示例值：6972085707674355214
         *
         * @param targetJobLevel
         * @return
         */
        public Builder targetJobLevel(String targetJobLevel) {
            this.targetJobLevel = targetJobLevel;
            return this;
        }


        /**
         * 原人员类型
         * <p> 示例值：6968386026792289828
         *
         * @param originalWorkforceType
         * @return
         */
        public Builder originalWorkforceType(String originalWorkforceType) {
            this.originalWorkforceType = originalWorkforceType;
            return this;
        }


        /**
         * 新人员类型
         * <p> 示例值：7036268995372303885
         *
         * @param targetWorkforceType
         * @return
         */
        public Builder targetWorkforceType(String targetWorkforceType) {
            this.targetWorkforceType = targetWorkforceType;
            return this;
        }


        /**
         * 原公司
         * <p> 示例值：6974659700705068581
         *
         * @param originalCompany
         * @return
         */
        public Builder originalCompany(String originalCompany) {
            this.originalCompany = originalCompany;
            return this;
        }


        /**
         * 新公司
         * <p> 示例值：6974659700705068581
         *
         * @param targetCompany
         * @return
         */
        public Builder targetCompany(String targetCompany) {
            this.targetCompany = targetCompany;
            return this;
        }


        /**
         * 原合同编号
         * <p> 示例值：55332
         *
         * @param originalContractNumber
         * @return
         */
        public Builder originalContractNumber(String originalContractNumber) {
            this.originalContractNumber = originalContractNumber;
            return this;
        }


        /**
         * 新合同编号
         * <p> 示例值：55333
         *
         * @param targetContractNumber
         * @return
         */
        public Builder targetContractNumber(String targetContractNumber) {
            this.targetContractNumber = targetContractNumber;
            return this;
        }


        /**
         * 原合同类型
         * <p> 示例值：labor_contract
         *
         * @param originalContractType
         * @return
         */
        public Builder originalContractType(String originalContractType) {
            this.originalContractType = originalContractType;
            return this;
        }


        /**
         * 新合同类型
         * <p> 示例值：labor_contract
         *
         * @param targetContractType
         * @return
         */
        public Builder targetContractType(String targetContractType) {
            this.targetContractType = targetContractType;
            return this;
        }


        /**
         * 原期限类型
         * <p> 示例值：fixed_term
         *
         * @param originalDurationType
         * @return
         */
        public Builder originalDurationType(String originalDurationType) {
            this.originalDurationType = originalDurationType;
            return this;
        }


        /**
         * 新期限类型
         * <p> 示例值：fixed_term
         *
         * @param targetDurationType
         * @return
         */
        public Builder targetDurationType(String targetDurationType) {
            this.targetDurationType = targetDurationType;
            return this;
        }


        /**
         * 原签订类型
         * <p> 示例值：new
         *
         * @param originalSigningType
         * @return
         */
        public Builder originalSigningType(String originalSigningType) {
            this.originalSigningType = originalSigningType;
            return this;
        }


        /**
         * 新签订类型
         * <p> 示例值：new
         *
         * @param targetSigningType
         * @return
         */
        public Builder targetSigningType(String targetSigningType) {
            this.targetSigningType = targetSigningType;
            return this;
        }


        /**
         * 原合同开始日期
         * <p> 示例值：2021-07-01
         *
         * @param originalContractStartDate
         * @return
         */
        public Builder originalContractStartDate(String originalContractStartDate) {
            this.originalContractStartDate = originalContractStartDate;
            return this;
        }


        /**
         * 新合同开始日期
         * <p> 示例值：2021-07-01
         *
         * @param targetContractStartDate
         * @return
         */
        public Builder targetContractStartDate(String targetContractStartDate) {
            this.targetContractStartDate = targetContractStartDate;
            return this;
        }


        /**
         * 原合同结束日期
         * <p> 示例值：2024-07-01
         *
         * @param originalContractEndDate
         * @return
         */
        public Builder originalContractEndDate(String originalContractEndDate) {
            this.originalContractEndDate = originalContractEndDate;
            return this;
        }


        /**
         * 新合同结束日期
         * <p> 示例值：2024-07-01
         *
         * @param targetContractEndDate
         * @return
         */
        public Builder targetContractEndDate(String targetContractEndDate) {
            this.targetContractEndDate = targetContractEndDate;
            return this;
        }


        /**
         * 原工时制度
         * <p> 示例值：6969087376740206087
         *
         * @param originalWorkingHoursType
         * @return
         */
        public Builder originalWorkingHoursType(String originalWorkingHoursType) {
            this.originalWorkingHoursType = originalWorkingHoursType;
            return this;
        }


        /**
         * 新工时制度
         * <p> 示例值：6969087376740206087
         *
         * @param targetWorkingHoursType
         * @return
         */
        public Builder targetWorkingHoursType(String targetWorkingHoursType) {
            this.targetWorkingHoursType = targetWorkingHoursType;
            return this;
        }


        /**
         * 原工作日历
         * <p> 示例值：6969087376740236087
         *
         * @param originalWorkingCalendar
         * @return
         */
        public Builder originalWorkingCalendar(String originalWorkingCalendar) {
            this.originalWorkingCalendar = originalWorkingCalendar;
            return this;
        }


        /**
         * 新工作日历
         * <p> 示例值：6969087376740236087
         *
         * @param targetWorkingCalendar
         * @return
         */
        public Builder targetWorkingCalendar(String targetWorkingCalendar) {
            this.targetWorkingCalendar = targetWorkingCalendar;
            return this;
        }


        /**
         * 原试用期预计结束日期
         * <p> 示例值：2021-11-17
         *
         * @param originalProbationEndDate
         * @return
         */
        public Builder originalProbationEndDate(String originalProbationEndDate) {
            this.originalProbationEndDate = originalProbationEndDate;
            return this;
        }


        /**
         * 新试用期预计结束日期
         * <p> 示例值：2021-11-17
         *
         * @param targetProbationEndDate
         * @return
         */
        public Builder targetProbationEndDate(String targetProbationEndDate) {
            this.targetProbationEndDate = targetProbationEndDate;
            return this;
        }


        /**
         * 原周工作时长
         * <p> 示例值：162
         *
         * @param originalWeeklyWorkingHours
         * @return
         */
        public Builder originalWeeklyWorkingHours(String originalWeeklyWorkingHours) {
            this.originalWeeklyWorkingHours = originalWeeklyWorkingHours;
            return this;
        }


        /**
         * 新周工作时长
         * <p> 示例值：160
         *
         * @param targetWeeklyWorkingHours
         * @return
         */
        public Builder targetWeeklyWorkingHours(String targetWeeklyWorkingHours) {
            this.targetWeeklyWorkingHours = targetWeeklyWorkingHours;
            return this;
        }


        /**
         * 原排班
         * <p> 示例值：work_shift
         *
         * @param originalWorkShift
         * @return
         */
        public Builder originalWorkShift(String originalWorkShift) {
            this.originalWorkShift = originalWorkShift;
            return this;
        }


        /**
         * 新排班
         * <p> 示例值：non_work_shift
         *
         * @param targetWorkShift
         * @return
         */
        public Builder targetWorkShift(String targetWorkShift) {
            this.targetWorkShift = targetWorkShift;
            return this;
        }


        /**
         * 原成本中心分摊信息
         * <p> 示例值：
         *
         * @param originalCostCenterRate
         * @return
         */
        public Builder originalCostCenterRate(SupportCostCenterItem[] originalCostCenterRate) {
            this.originalCostCenterRate = originalCostCenterRate;
            return this;
        }


        /**
         * 新成本中心分摊信息
         * <p> 示例值：
         *
         * @param targetCostCenterRate
         * @return
         */
        public Builder targetCostCenterRate(SupportCostCenterItem[] targetCostCenterRate) {
            this.targetCostCenterRate = targetCostCenterRate;
            return this;
        }


        /**
         * 原工作信息
         * <p> 示例值：
         *
         * @param originalEmploymentChange
         * @return
         */
        public Builder originalEmploymentChange(TranferEmploymentInfo originalEmploymentChange) {
            this.originalEmploymentChange = originalEmploymentChange;
            return this;
        }


        /**
         * 新工作信息
         * <p> 示例值：
         *
         * @param targetEmploymentChange
         * @return
         */
        public Builder targetEmploymentChange(TranferEmploymentInfo targetEmploymentChange) {
            this.targetEmploymentChange = targetEmploymentChange;
            return this;
        }


        /**
         * 原职等
         * <p> 示例值：7289005963599693366
         *
         * @param originalJobGrade
         * @return
         */
        public Builder originalJobGrade(String originalJobGrade) {
            this.originalJobGrade = originalJobGrade;
            return this;
        }


        /**
         * 新职等
         * <p> 示例值：7289005963599693366
         *
         * @param targetJobGrade
         * @return
         */
        public Builder targetJobGrade(String targetJobGrade) {
            this.targetJobGrade = targetJobGrade;
            return this;
        }


        public TransferInfo build() {
            return new TransferInfo(this);
        }
    }
}
