// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.google.gson.annotations.SerializedName;

public class ContentParagraph {
    /**
     * 段落样式
     * <p> 示例值：
     */
    @SerializedName("style")
    private ContentParagraphStyle style;
    /**
     * 段落元素组成一个段落
     * <p> 示例值：
     */
    @SerializedName("elements")
    private ContentParagraphElement[] elements;

    // builder 开始
    public ContentParagraph() {
    }

    public ContentParagraph(Builder builder) {
        /**
         * 段落样式
         * <p> 示例值：
         */
        this.style = builder.style;
        /**
         * 段落元素组成一个段落
         * <p> 示例值：
         */
        this.elements = builder.elements;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ContentParagraphStyle getStyle() {
        return this.style;
    }

    public void setStyle(ContentParagraphStyle style) {
        this.style = style;
    }

    public ContentParagraphElement[] getElements() {
        return this.elements;
    }

    public void setElements(ContentParagraphElement[] elements) {
        this.elements = elements;
    }

    public static class Builder {
        /**
         * 段落样式
         * <p> 示例值：
         */
        private ContentParagraphStyle style;
        /**
         * 段落元素组成一个段落
         * <p> 示例值：
         */
        private ContentParagraphElement[] elements;

        /**
         * 段落样式
         * <p> 示例值：
         *
         * @param style
         * @return
         */
        public Builder style(ContentParagraphStyle style) {
            this.style = style;
            return this;
        }


        /**
         * 段落元素组成一个段落
         * <p> 示例值：
         *
         * @param elements
         * @return
         */
        public Builder elements(ContentParagraphElement[] elements) {
            this.elements = elements;
            return this;
        }


        public ContentParagraph build() {
            return new ContentParagraph(this);
        }
    }
}
