// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;

public class PatchCustomFieldOptionReq {
    /**
     * 要更新的选项的自定义字段GUID
     * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
     */
    @Path
    @SerializedName("custom_field_guid")
    private String customFieldGuid;
    /**
     * 要更新的选项的GUID
     * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
     */
    @Path
    @SerializedName("option_guid")
    private String optionGuid;
    @Body
    private PatchCustomFieldOptionReqBody body;

    // builder 开始
    public PatchCustomFieldOptionReq() {
    }

    public PatchCustomFieldOptionReq(Builder builder) {
        /**
         * 要更新的选项的自定义字段GUID
         * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
         */
        this.customFieldGuid = builder.customFieldGuid;
        /**
         * 要更新的选项的GUID
         * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
         */
        this.optionGuid = builder.optionGuid;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCustomFieldGuid() {
        return this.customFieldGuid;
    }

    public void setCustomFieldGuid(String customFieldGuid) {
        this.customFieldGuid = customFieldGuid;
    }

    public String getOptionGuid() {
        return this.optionGuid;
    }

    public void setOptionGuid(String optionGuid) {
        this.optionGuid = optionGuid;
    }

    public PatchCustomFieldOptionReqBody getPatchCustomFieldOptionReqBody() {
        return this.body;
    }

    public void setPatchCustomFieldOptionReqBody(PatchCustomFieldOptionReqBody body) {
        this.body = body;
    }

    public static class Builder {

        private String customFieldGuid; // 要更新的选项的自定义字段GUID
        private String optionGuid; // 要更新的选项的GUID
        private PatchCustomFieldOptionReqBody body;

        /**
         * 要更新的选项的自定义字段GUID
         * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
         *
         * @param customFieldGuid
         * @return
         */
        public Builder customFieldGuid(String customFieldGuid) {
            this.customFieldGuid = customFieldGuid;
            return this;
        }

        /**
         * 要更新的选项的GUID
         * <p> 示例值：b13adf3c-cad6-4e02-8929-550c112b5633
         *
         * @param optionGuid
         * @return
         */
        public Builder optionGuid(String optionGuid) {
            this.optionGuid = optionGuid;
            return this;
        }

        public PatchCustomFieldOptionReqBody getPatchCustomFieldOptionReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder patchCustomFieldOptionReqBody(PatchCustomFieldOptionReqBody body) {
            this.body = body;
            return this;
        }

        public PatchCustomFieldOptionReq build() {
            return new PatchCustomFieldOptionReq(this);
        }
    }
}
