// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Bank {
    /**
     * 银行 ID
     * <p> 示例值：6893014062142064135
     */
    @SerializedName("bank_id")
    private String bankId;
    /**
     * 银行名称
     * <p> 示例值：
     */
    @SerializedName("bank_name")
    private I18n[] bankName;
    /**
     * 总行代码
     * <p> 示例值：BKCH
     */
    @SerializedName("bank_code")
    private String bankCode;
    /**
     * 国家 / 地区 ID ，可通过【查询单条国家/地区信息】 接口查询
     * <p> 示例值：6893014062142064133
     */
    @SerializedName("country_region_id")
    private String countryRegionId;
    /**
     * 状态
     * <p> 示例值：1
     */
    @SerializedName("status")
    private Integer status;

    // builder 开始
    public Bank() {
    }

    public Bank(Builder builder) {
        /**
         * 银行 ID
         * <p> 示例值：6893014062142064135
         */
        this.bankId = builder.bankId;
        /**
         * 银行名称
         * <p> 示例值：
         */
        this.bankName = builder.bankName;
        /**
         * 总行代码
         * <p> 示例值：BKCH
         */
        this.bankCode = builder.bankCode;
        /**
         * 国家 / 地区 ID ，可通过【查询单条国家/地区信息】 接口查询
         * <p> 示例值：6893014062142064133
         */
        this.countryRegionId = builder.countryRegionId;
        /**
         * 状态
         * <p> 示例值：1
         */
        this.status = builder.status;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public I18n[] getBankName() {
        return this.bankName;
    }

    public void setBankName(I18n[] bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getCountryRegionId() {
        return this.countryRegionId;
    }

    public void setCountryRegionId(String countryRegionId) {
        this.countryRegionId = countryRegionId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static class Builder {
        /**
         * 银行 ID
         * <p> 示例值：6893014062142064135
         */
        private String bankId;
        /**
         * 银行名称
         * <p> 示例值：
         */
        private I18n[] bankName;
        /**
         * 总行代码
         * <p> 示例值：BKCH
         */
        private String bankCode;
        /**
         * 国家 / 地区 ID ，可通过【查询单条国家/地区信息】 接口查询
         * <p> 示例值：6893014062142064133
         */
        private String countryRegionId;
        /**
         * 状态
         * <p> 示例值：1
         */
        private Integer status;

        /**
         * 银行 ID
         * <p> 示例值：6893014062142064135
         *
         * @param bankId
         * @return
         */
        public Builder bankId(String bankId) {
            this.bankId = bankId;
            return this;
        }


        /**
         * 银行名称
         * <p> 示例值：
         *
         * @param bankName
         * @return
         */
        public Builder bankName(I18n[] bankName) {
            this.bankName = bankName;
            return this;
        }


        /**
         * 总行代码
         * <p> 示例值：BKCH
         *
         * @param bankCode
         * @return
         */
        public Builder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }


        /**
         * 国家 / 地区 ID ，可通过【查询单条国家/地区信息】 接口查询
         * <p> 示例值：6893014062142064133
         *
         * @param countryRegionId
         * @return
         */
        public Builder countryRegionId(String countryRegionId) {
            this.countryRegionId = countryRegionId;
            return this;
        }


        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status
         * @return
         */
        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status {@link com.lark.oapi.service.corehr.v2.enums.BankBasicDataObjStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.corehr.v2.enums.BankBasicDataObjStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        public Bank build() {
            return new Bank(this);
        }
    }
}
