// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class BankBranch {
    /**
     * 支行 ID
     * <p> 示例值：6893014062142064111
     */
    @SerializedName("bank_branch_id")
    private String bankBranchId;
    /**
     * 支行名称
     * <p> 示例值：
     */
    @SerializedName("bank_branch_name")
    private I18n[] bankBranchName;
    /**
     * 所属银行 ID，可通过【查询银行信息】接口查询
     * <p> 示例值：6893011062142064111
     */
    @SerializedName("bank_id")
    private String bankId;
    /**
     * 金融分支机构编码
     * <p> 示例值：201
     */
    @SerializedName("code")
    private String code;
    /**
     * 银行代码
     * <p> 示例值：PBOCCNBJ
     */
    @SerializedName("swift_code")
    private String swiftCode;
    /**
     * 状态
     * <p> 示例值：1
     */
    @SerializedName("status")
    private Integer status;

    // builder 开始
    public BankBranch() {
    }

    public BankBranch(Builder builder) {
        /**
         * 支行 ID
         * <p> 示例值：6893014062142064111
         */
        this.bankBranchId = builder.bankBranchId;
        /**
         * 支行名称
         * <p> 示例值：
         */
        this.bankBranchName = builder.bankBranchName;
        /**
         * 所属银行 ID，可通过【查询银行信息】接口查询
         * <p> 示例值：6893011062142064111
         */
        this.bankId = builder.bankId;
        /**
         * 金融分支机构编码
         * <p> 示例值：201
         */
        this.code = builder.code;
        /**
         * 银行代码
         * <p> 示例值：PBOCCNBJ
         */
        this.swiftCode = builder.swiftCode;
        /**
         * 状态
         * <p> 示例值：1
         */
        this.status = builder.status;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public I18n[] getBankBranchName() {
        return this.bankBranchName;
    }

    public void setBankBranchName(I18n[] bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSwiftCode() {
        return this.swiftCode;
    }

    public void setSwiftCode(String swiftCode) {
        this.swiftCode = swiftCode;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static class Builder {
        /**
         * 支行 ID
         * <p> 示例值：6893014062142064111
         */
        private String bankBranchId;
        /**
         * 支行名称
         * <p> 示例值：
         */
        private I18n[] bankBranchName;
        /**
         * 所属银行 ID，可通过【查询银行信息】接口查询
         * <p> 示例值：6893011062142064111
         */
        private String bankId;
        /**
         * 金融分支机构编码
         * <p> 示例值：201
         */
        private String code;
        /**
         * 银行代码
         * <p> 示例值：PBOCCNBJ
         */
        private String swiftCode;
        /**
         * 状态
         * <p> 示例值：1
         */
        private Integer status;

        /**
         * 支行 ID
         * <p> 示例值：6893014062142064111
         *
         * @param bankBranchId
         * @return
         */
        public Builder bankBranchId(String bankBranchId) {
            this.bankBranchId = bankBranchId;
            return this;
        }


        /**
         * 支行名称
         * <p> 示例值：
         *
         * @param bankBranchName
         * @return
         */
        public Builder bankBranchName(I18n[] bankBranchName) {
            this.bankBranchName = bankBranchName;
            return this;
        }


        /**
         * 所属银行 ID，可通过【查询银行信息】接口查询
         * <p> 示例值：6893011062142064111
         *
         * @param bankId
         * @return
         */
        public Builder bankId(String bankId) {
            this.bankId = bankId;
            return this;
        }


        /**
         * 金融分支机构编码
         * <p> 示例值：201
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 银行代码
         * <p> 示例值：PBOCCNBJ
         *
         * @param swiftCode
         * @return
         */
        public Builder swiftCode(String swiftCode) {
            this.swiftCode = swiftCode;
            return this;
        }


        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status
         * @return
         */
        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        /**
         * 状态
         * <p> 示例值：1
         *
         * @param status {@link com.lark.oapi.service.corehr.v2.enums.BankBranchBasicDataObjStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.corehr.v2.enums.BankBranchBasicDataObjStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        public BankBranch build() {
            return new BankBranch(this);
        }
    }
}
