// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ReorganizationInfo {
    /**
     * 原部门名称
     * <p> 示例值：
     */
    @SerializedName("original_department_names")
    private I18n[] originalDepartmentNames;
    /**
     * 调整后部门名称
     * <p> 示例值：
     */
    @SerializedName("target_department_names")
    private I18n[] targetDepartmentNames;
    /**
     * 原部门编码
     * <p> 示例值：D00000456
     */
    @SerializedName("original_department_code")
    private String originalDepartmentCode;
    /**
     * 调整后部门编码
     * <p> 示例值：D00000456
     */
    @SerializedName("target_department_code")
    private String targetDepartmentCode;
    /**
     * 原部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
     * <p> 示例值：
     */
    @SerializedName("original_sub_type")
    private Enum originalSubType;
    /**
     * 调整后部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
     * <p> 示例值：
     */
    @SerializedName("target_sub_type")
    private Enum targetSubType;
    /**
     * 原部门负责人
     * <p> 示例值：6974648866876573198
     */
    @SerializedName("original_department_manager")
    private String originalDepartmentManager;
    /**
     * 调整后部门负责人
     * <p> 示例值：7013328578351842852
     */
    @SerializedName("target_department_manager")
    private String targetDepartmentManager;
    /**
     * 原描述
     * <p> 示例值：
     */
    @SerializedName("original_descriptions")
    private I18n[] originalDescriptions;
    /**
     * 调整后描述
     * <p> 示例值：
     */
    @SerializedName("target_descriptions")
    private I18n[] targetDescriptions;
    /**
     * 原默认成本中心
     * <p> 示例值：
     */
    @SerializedName("original_cost_center")
    private CostCenter originalCostCenter;
    /**
     * 调整后默认成本中心
     * <p> 示例值：
     */
    @SerializedName("target_cost_center")
    private CostCenter targetCostCenter;
    /**
     * 原是否保密
     * <p> 示例值：true
     */
    @SerializedName("original_is_confidential")
    private Boolean originalIsConfidential;
    /**
     * 调整后是否保密
     * <p> 示例值：true
     */
    @SerializedName("target_is_confidential")
    private Boolean targetIsConfidential;
    /**
     * 原是否使用职务
     * <p> 示例值：true
     */
    @SerializedName("original_staffing_model")
    private Boolean originalStaffingModel;
    /**
     * 调整后是否使用职务
     * <p> 示例值：false
     */
    @SerializedName("target_staffing_model")
    private Boolean targetStaffingModel;
    /**
     * 原上级部门
     * <p> 示例值：6974659700705068581
     */
    @SerializedName("original_parent_department_id")
    private String originalParentDepartmentId;
    /**
     * 调整后上级部门
     * <p> 示例值：6974659700705068581
     */
    @SerializedName("target_parent_department_id")
    private String targetParentDepartmentId;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("custom_fields")
    private ChangeFieldPair[] customFields;

    // builder 开始
    public ReorganizationInfo() {
    }

    public ReorganizationInfo(Builder builder) {
        /**
         * 原部门名称
         * <p> 示例值：
         */
        this.originalDepartmentNames = builder.originalDepartmentNames;
        /**
         * 调整后部门名称
         * <p> 示例值：
         */
        this.targetDepartmentNames = builder.targetDepartmentNames;
        /**
         * 原部门编码
         * <p> 示例值：D00000456
         */
        this.originalDepartmentCode = builder.originalDepartmentCode;
        /**
         * 调整后部门编码
         * <p> 示例值：D00000456
         */
        this.targetDepartmentCode = builder.targetDepartmentCode;
        /**
         * 原部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         */
        this.originalSubType = builder.originalSubType;
        /**
         * 调整后部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         */
        this.targetSubType = builder.targetSubType;
        /**
         * 原部门负责人
         * <p> 示例值：6974648866876573198
         */
        this.originalDepartmentManager = builder.originalDepartmentManager;
        /**
         * 调整后部门负责人
         * <p> 示例值：7013328578351842852
         */
        this.targetDepartmentManager = builder.targetDepartmentManager;
        /**
         * 原描述
         * <p> 示例值：
         */
        this.originalDescriptions = builder.originalDescriptions;
        /**
         * 调整后描述
         * <p> 示例值：
         */
        this.targetDescriptions = builder.targetDescriptions;
        /**
         * 原默认成本中心
         * <p> 示例值：
         */
        this.originalCostCenter = builder.originalCostCenter;
        /**
         * 调整后默认成本中心
         * <p> 示例值：
         */
        this.targetCostCenter = builder.targetCostCenter;
        /**
         * 原是否保密
         * <p> 示例值：true
         */
        this.originalIsConfidential = builder.originalIsConfidential;
        /**
         * 调整后是否保密
         * <p> 示例值：true
         */
        this.targetIsConfidential = builder.targetIsConfidential;
        /**
         * 原是否使用职务
         * <p> 示例值：true
         */
        this.originalStaffingModel = builder.originalStaffingModel;
        /**
         * 调整后是否使用职务
         * <p> 示例值：false
         */
        this.targetStaffingModel = builder.targetStaffingModel;
        /**
         * 原上级部门
         * <p> 示例值：6974659700705068581
         */
        this.originalParentDepartmentId = builder.originalParentDepartmentId;
        /**
         * 调整后上级部门
         * <p> 示例值：6974659700705068581
         */
        this.targetParentDepartmentId = builder.targetParentDepartmentId;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customFields = builder.customFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public I18n[] getOriginalDepartmentNames() {
        return this.originalDepartmentNames;
    }

    public void setOriginalDepartmentNames(I18n[] originalDepartmentNames) {
        this.originalDepartmentNames = originalDepartmentNames;
    }

    public I18n[] getTargetDepartmentNames() {
        return this.targetDepartmentNames;
    }

    public void setTargetDepartmentNames(I18n[] targetDepartmentNames) {
        this.targetDepartmentNames = targetDepartmentNames;
    }

    public String getOriginalDepartmentCode() {
        return this.originalDepartmentCode;
    }

    public void setOriginalDepartmentCode(String originalDepartmentCode) {
        this.originalDepartmentCode = originalDepartmentCode;
    }

    public String getTargetDepartmentCode() {
        return this.targetDepartmentCode;
    }

    public void setTargetDepartmentCode(String targetDepartmentCode) {
        this.targetDepartmentCode = targetDepartmentCode;
    }

    public Enum getOriginalSubType() {
        return this.originalSubType;
    }

    public void setOriginalSubType(Enum originalSubType) {
        this.originalSubType = originalSubType;
    }

    public Enum getTargetSubType() {
        return this.targetSubType;
    }

    public void setTargetSubType(Enum targetSubType) {
        this.targetSubType = targetSubType;
    }

    public String getOriginalDepartmentManager() {
        return this.originalDepartmentManager;
    }

    public void setOriginalDepartmentManager(String originalDepartmentManager) {
        this.originalDepartmentManager = originalDepartmentManager;
    }

    public String getTargetDepartmentManager() {
        return this.targetDepartmentManager;
    }

    public void setTargetDepartmentManager(String targetDepartmentManager) {
        this.targetDepartmentManager = targetDepartmentManager;
    }

    public I18n[] getOriginalDescriptions() {
        return this.originalDescriptions;
    }

    public void setOriginalDescriptions(I18n[] originalDescriptions) {
        this.originalDescriptions = originalDescriptions;
    }

    public I18n[] getTargetDescriptions() {
        return this.targetDescriptions;
    }

    public void setTargetDescriptions(I18n[] targetDescriptions) {
        this.targetDescriptions = targetDescriptions;
    }

    public CostCenter getOriginalCostCenter() {
        return this.originalCostCenter;
    }

    public void setOriginalCostCenter(CostCenter originalCostCenter) {
        this.originalCostCenter = originalCostCenter;
    }

    public CostCenter getTargetCostCenter() {
        return this.targetCostCenter;
    }

    public void setTargetCostCenter(CostCenter targetCostCenter) {
        this.targetCostCenter = targetCostCenter;
    }

    public Boolean getOriginalIsConfidential() {
        return this.originalIsConfidential;
    }

    public void setOriginalIsConfidential(Boolean originalIsConfidential) {
        this.originalIsConfidential = originalIsConfidential;
    }

    public Boolean getTargetIsConfidential() {
        return this.targetIsConfidential;
    }

    public void setTargetIsConfidential(Boolean targetIsConfidential) {
        this.targetIsConfidential = targetIsConfidential;
    }

    public Boolean getOriginalStaffingModel() {
        return this.originalStaffingModel;
    }

    public void setOriginalStaffingModel(Boolean originalStaffingModel) {
        this.originalStaffingModel = originalStaffingModel;
    }

    public Boolean getTargetStaffingModel() {
        return this.targetStaffingModel;
    }

    public void setTargetStaffingModel(Boolean targetStaffingModel) {
        this.targetStaffingModel = targetStaffingModel;
    }

    public String getOriginalParentDepartmentId() {
        return this.originalParentDepartmentId;
    }

    public void setOriginalParentDepartmentId(String originalParentDepartmentId) {
        this.originalParentDepartmentId = originalParentDepartmentId;
    }

    public String getTargetParentDepartmentId() {
        return this.targetParentDepartmentId;
    }

    public void setTargetParentDepartmentId(String targetParentDepartmentId) {
        this.targetParentDepartmentId = targetParentDepartmentId;
    }

    public ChangeFieldPair[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ChangeFieldPair[] customFields) {
        this.customFields = customFields;
    }

    public static class Builder {
        /**
         * 原部门名称
         * <p> 示例值：
         */
        private I18n[] originalDepartmentNames;
        /**
         * 调整后部门名称
         * <p> 示例值：
         */
        private I18n[] targetDepartmentNames;
        /**
         * 原部门编码
         * <p> 示例值：D00000456
         */
        private String originalDepartmentCode;
        /**
         * 调整后部门编码
         * <p> 示例值：D00000456
         */
        private String targetDepartmentCode;
        /**
         * 原部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         */
        private Enum originalSubType;
        /**
         * 调整后部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         */
        private Enum targetSubType;
        /**
         * 原部门负责人
         * <p> 示例值：6974648866876573198
         */
        private String originalDepartmentManager;
        /**
         * 调整后部门负责人
         * <p> 示例值：7013328578351842852
         */
        private String targetDepartmentManager;
        /**
         * 原描述
         * <p> 示例值：
         */
        private I18n[] originalDescriptions;
        /**
         * 调整后描述
         * <p> 示例值：
         */
        private I18n[] targetDescriptions;
        /**
         * 原默认成本中心
         * <p> 示例值：
         */
        private CostCenter originalCostCenter;
        /**
         * 调整后默认成本中心
         * <p> 示例值：
         */
        private CostCenter targetCostCenter;
        /**
         * 原是否保密
         * <p> 示例值：true
         */
        private Boolean originalIsConfidential;
        /**
         * 调整后是否保密
         * <p> 示例值：true
         */
        private Boolean targetIsConfidential;
        /**
         * 原是否使用职务
         * <p> 示例值：true
         */
        private Boolean originalStaffingModel;
        /**
         * 调整后是否使用职务
         * <p> 示例值：false
         */
        private Boolean targetStaffingModel;
        /**
         * 原上级部门
         * <p> 示例值：6974659700705068581
         */
        private String originalParentDepartmentId;
        /**
         * 调整后上级部门
         * <p> 示例值：6974659700705068581
         */
        private String targetParentDepartmentId;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private ChangeFieldPair[] customFields;

        /**
         * 原部门名称
         * <p> 示例值：
         *
         * @param originalDepartmentNames
         * @return
         */
        public Builder originalDepartmentNames(I18n[] originalDepartmentNames) {
            this.originalDepartmentNames = originalDepartmentNames;
            return this;
        }


        /**
         * 调整后部门名称
         * <p> 示例值：
         *
         * @param targetDepartmentNames
         * @return
         */
        public Builder targetDepartmentNames(I18n[] targetDepartmentNames) {
            this.targetDepartmentNames = targetDepartmentNames;
            return this;
        }


        /**
         * 原部门编码
         * <p> 示例值：D00000456
         *
         * @param originalDepartmentCode
         * @return
         */
        public Builder originalDepartmentCode(String originalDepartmentCode) {
            this.originalDepartmentCode = originalDepartmentCode;
            return this;
        }


        /**
         * 调整后部门编码
         * <p> 示例值：D00000456
         *
         * @param targetDepartmentCode
         * @return
         */
        public Builder targetDepartmentCode(String targetDepartmentCode) {
            this.targetDepartmentCode = targetDepartmentCode;
            return this;
        }


        /**
         * 原部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         *
         * @param originalSubType
         * @return
         */
        public Builder originalSubType(Enum originalSubType) {
            this.originalSubType = originalSubType;
            return this;
        }


        /**
         * 调整后部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         *
         * @param targetSubType
         * @return
         */
        public Builder targetSubType(Enum targetSubType) {
            this.targetSubType = targetSubType;
            return this;
        }


        /**
         * 原部门负责人
         * <p> 示例值：6974648866876573198
         *
         * @param originalDepartmentManager
         * @return
         */
        public Builder originalDepartmentManager(String originalDepartmentManager) {
            this.originalDepartmentManager = originalDepartmentManager;
            return this;
        }


        /**
         * 调整后部门负责人
         * <p> 示例值：7013328578351842852
         *
         * @param targetDepartmentManager
         * @return
         */
        public Builder targetDepartmentManager(String targetDepartmentManager) {
            this.targetDepartmentManager = targetDepartmentManager;
            return this;
        }


        /**
         * 原描述
         * <p> 示例值：
         *
         * @param originalDescriptions
         * @return
         */
        public Builder originalDescriptions(I18n[] originalDescriptions) {
            this.originalDescriptions = originalDescriptions;
            return this;
        }


        /**
         * 调整后描述
         * <p> 示例值：
         *
         * @param targetDescriptions
         * @return
         */
        public Builder targetDescriptions(I18n[] targetDescriptions) {
            this.targetDescriptions = targetDescriptions;
            return this;
        }


        /**
         * 原默认成本中心
         * <p> 示例值：
         *
         * @param originalCostCenter
         * @return
         */
        public Builder originalCostCenter(CostCenter originalCostCenter) {
            this.originalCostCenter = originalCostCenter;
            return this;
        }


        /**
         * 调整后默认成本中心
         * <p> 示例值：
         *
         * @param targetCostCenter
         * @return
         */
        public Builder targetCostCenter(CostCenter targetCostCenter) {
            this.targetCostCenter = targetCostCenter;
            return this;
        }


        /**
         * 原是否保密
         * <p> 示例值：true
         *
         * @param originalIsConfidential
         * @return
         */
        public Builder originalIsConfidential(Boolean originalIsConfidential) {
            this.originalIsConfidential = originalIsConfidential;
            return this;
        }


        /**
         * 调整后是否保密
         * <p> 示例值：true
         *
         * @param targetIsConfidential
         * @return
         */
        public Builder targetIsConfidential(Boolean targetIsConfidential) {
            this.targetIsConfidential = targetIsConfidential;
            return this;
        }


        /**
         * 原是否使用职务
         * <p> 示例值：true
         *
         * @param originalStaffingModel
         * @return
         */
        public Builder originalStaffingModel(Boolean originalStaffingModel) {
            this.originalStaffingModel = originalStaffingModel;
            return this;
        }


        /**
         * 调整后是否使用职务
         * <p> 示例值：false
         *
         * @param targetStaffingModel
         * @return
         */
        public Builder targetStaffingModel(Boolean targetStaffingModel) {
            this.targetStaffingModel = targetStaffingModel;
            return this;
        }


        /**
         * 原上级部门
         * <p> 示例值：6974659700705068581
         *
         * @param originalParentDepartmentId
         * @return
         */
        public Builder originalParentDepartmentId(String originalParentDepartmentId) {
            this.originalParentDepartmentId = originalParentDepartmentId;
            return this;
        }


        /**
         * 调整后上级部门
         * <p> 示例值：6974659700705068581
         *
         * @param targetParentDepartmentId
         * @return
         */
        public Builder targetParentDepartmentId(String targetParentDepartmentId) {
            this.targetParentDepartmentId = targetParentDepartmentId;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customFields
         * @return
         */
        public Builder customFields(ChangeFieldPair[] customFields) {
            this.customFields = customFields;
            return this;
        }


        public ReorganizationInfo build() {
            return new ReorganizationInfo(this);
        }
    }
}
