// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Document {
    /**
     * 文档唯一标识
     * <p> 示例值：doxcni6mOy7jLRWbEylaKKC7K88
     */
    @SerializedName("document_id")
    private String documentId;
    /**
     * 文档版本 ID
     * <p> 示例值：1
     */
    @SerializedName("revision_id")
    private Integer revisionId;
    /**
     * 文档标题
     * <p> 示例值：undefined
     */
    @SerializedName("title")
    private String title;
    /**
     * 文档展示设置
     * <p> 示例值：
     */
    @SerializedName("display_setting")
    private DocumentDisplaySetting displaySetting;

    // builder 开始
    public Document() {
    }

    public Document(Builder builder) {
        /**
         * 文档唯一标识
         * <p> 示例值：doxcni6mOy7jLRWbEylaKKC7K88
         */
        this.documentId = builder.documentId;
        /**
         * 文档版本 ID
         * <p> 示例值：1
         */
        this.revisionId = builder.revisionId;
        /**
         * 文档标题
         * <p> 示例值：undefined
         */
        this.title = builder.title;
        /**
         * 文档展示设置
         * <p> 示例值：
         */
        this.displaySetting = builder.displaySetting;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Integer getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Integer revisionId) {
        this.revisionId = revisionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DocumentDisplaySetting getDisplaySetting() {
        return this.displaySetting;
    }

    public void setDisplaySetting(DocumentDisplaySetting displaySetting) {
        this.displaySetting = displaySetting;
    }

    public static class Builder {
        /**
         * 文档唯一标识
         * <p> 示例值：doxcni6mOy7jLRWbEylaKKC7K88
         */
        private String documentId;
        /**
         * 文档版本 ID
         * <p> 示例值：1
         */
        private Integer revisionId;
        /**
         * 文档标题
         * <p> 示例值：undefined
         */
        private String title;
        /**
         * 文档展示设置
         * <p> 示例值：
         */
        private DocumentDisplaySetting displaySetting;

        /**
         * 文档唯一标识
         * <p> 示例值：doxcni6mOy7jLRWbEylaKKC7K88
         *
         * @param documentId
         * @return
         */
        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }


        /**
         * 文档版本 ID
         * <p> 示例值：1
         *
         * @param revisionId
         * @return
         */
        public Builder revisionId(Integer revisionId) {
            this.revisionId = revisionId;
            return this;
        }


        /**
         * 文档标题
         * <p> 示例值：undefined
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 文档展示设置
         * <p> 示例值：
         *
         * @param displaySetting
         * @return
         */
        public Builder displaySetting(DocumentDisplaySetting displaySetting) {
            this.displaySetting = displaySetting;
            return this;
        }


        public Document build() {
            return new Document(this);
        }
    }
}
