// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.report.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.report.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class QueryRuleReq {
    /**
     * 规则名称
     * <p> 示例值：工作月报
     */
    @Query
    @SerializedName("rule_name")
    private String ruleName;
    /**
     * 是否包括已删除，默认未删除
     * <p> 示例值：0
     */
    @Query
    @SerializedName("include_deleted")
    private Integer includeDeleted;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;

    // builder 开始
    public QueryRuleReq() {
    }

    public QueryRuleReq(Builder builder) {
        /**
         * 规则名称
         * <p> 示例值：工作月报
         */
        this.ruleName = builder.ruleName;
        /**
         * 是否包括已删除，默认未删除
         * <p> 示例值：0
         */
        this.includeDeleted = builder.includeDeleted;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeDeleted(Integer includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public static class Builder {
        private String ruleName; // 规则名称
        private Integer includeDeleted; // 是否包括已删除，默认未删除
        private String userIdType; // 此次调用中使用的用户ID的类型


        /**
         * 规则名称
         * <p> 示例值：工作月报
         *
         * @param ruleName
         * @return
         */
        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }


        /**
         * 是否包括已删除，默认未删除
         * <p> 示例值：0
         *
         * @param includeDeleted
         * @return
         */
        public Builder includeDeleted(Integer includeDeleted) {
            this.includeDeleted = includeDeleted;
            return this;
        }

        /**
         * 是否包括已删除，默认未删除
         * <p> 示例值：0
         *
         * @param includeDeleted {@link com.lark.oapi.service.report.v1.enums.QueryRuleIncludeDeletedEnum}
         * @return
         */
        public Builder includeDeleted(com.lark.oapi.service.report.v1.enums.QueryRuleIncludeDeletedEnum includeDeleted) {
            this.includeDeleted = includeDeleted.getValue();
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.report.v1.enums.QueryRuleUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.report.v1.enums.QueryRuleUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        public QueryRuleReq build() {
            return new QueryRuleReq(this);
        }
    }
}
