// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.acs.v1.model;

import com.google.gson.annotations.SerializedName;

public class Rule {
    /**
     * 权限组id
     * <p> 示例值：34252345234523
     */
    @SerializedName("id")
    private String id;
    /**
     * 权限组名称
     * <p> 示例值：南门
     */
    @SerializedName("name")
    private String name;
    /**
     * 权限组包含的设备
     * <p> 示例值：
     */
    @SerializedName("devices")
    private DeviceExternal[] devices;
    /**
     * 权限组包含的员工个数
     * <p> 示例值：3
     */
    @SerializedName("user_count")
    private String userCount;
    /**
     * 权限组包含的员工列表
     * <p> 示例值：
     */
    @SerializedName("users")
    private UserExternal[] users;
    /**
     * 权限组包含的访客个数
     * <p> 示例值：3
     */
    @SerializedName("visitor_count")
    private String visitorCount;
    /**
     * 权限组包含的访客列表
     * <p> 示例值：
     */
    @SerializedName("visitors")
    private UserExternal[] visitors;
    /**
     * 是否通知人员录入
     * <p> 示例值：false
     */
    @SerializedName("remind_face")
    private Boolean remindFace;
    /**
     * 开门时间段
     * <p> 示例值：
     */
    @SerializedName("opening_time")
    private OpeningTimeExternal openingTime;
    /**
     * 是否为临时权限组
     * <p> 示例值：false
     */
    @SerializedName("is_temp")
    private Boolean isTemp;

    // builder 开始
    public Rule() {
    }

    public Rule(Builder builder) {
        /**
         * 权限组id
         * <p> 示例值：34252345234523
         */
        this.id = builder.id;
        /**
         * 权限组名称
         * <p> 示例值：南门
         */
        this.name = builder.name;
        /**
         * 权限组包含的设备
         * <p> 示例值：
         */
        this.devices = builder.devices;
        /**
         * 权限组包含的员工个数
         * <p> 示例值：3
         */
        this.userCount = builder.userCount;
        /**
         * 权限组包含的员工列表
         * <p> 示例值：
         */
        this.users = builder.users;
        /**
         * 权限组包含的访客个数
         * <p> 示例值：3
         */
        this.visitorCount = builder.visitorCount;
        /**
         * 权限组包含的访客列表
         * <p> 示例值：
         */
        this.visitors = builder.visitors;
        /**
         * 是否通知人员录入
         * <p> 示例值：false
         */
        this.remindFace = builder.remindFace;
        /**
         * 开门时间段
         * <p> 示例值：
         */
        this.openingTime = builder.openingTime;
        /**
         * 是否为临时权限组
         * <p> 示例值：false
         */
        this.isTemp = builder.isTemp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceExternal[] getDevices() {
        return this.devices;
    }

    public void setDevices(DeviceExternal[] devices) {
        this.devices = devices;
    }

    public String getUserCount() {
        return this.userCount;
    }

    public void setUserCount(String userCount) {
        this.userCount = userCount;
    }

    public UserExternal[] getUsers() {
        return this.users;
    }

    public void setUsers(UserExternal[] users) {
        this.users = users;
    }

    public String getVisitorCount() {
        return this.visitorCount;
    }

    public void setVisitorCount(String visitorCount) {
        this.visitorCount = visitorCount;
    }

    public UserExternal[] getVisitors() {
        return this.visitors;
    }

    public void setVisitors(UserExternal[] visitors) {
        this.visitors = visitors;
    }

    public Boolean getRemindFace() {
        return this.remindFace;
    }

    public void setRemindFace(Boolean remindFace) {
        this.remindFace = remindFace;
    }

    public OpeningTimeExternal getOpeningTime() {
        return this.openingTime;
    }

    public void setOpeningTime(OpeningTimeExternal openingTime) {
        this.openingTime = openingTime;
    }

    public Boolean getIsTemp() {
        return this.isTemp;
    }

    public void setIsTemp(Boolean isTemp) {
        this.isTemp = isTemp;
    }

    public static class Builder {
        /**
         * 权限组id
         * <p> 示例值：34252345234523
         */
        private String id;
        /**
         * 权限组名称
         * <p> 示例值：南门
         */
        private String name;
        /**
         * 权限组包含的设备
         * <p> 示例值：
         */
        private DeviceExternal[] devices;
        /**
         * 权限组包含的员工个数
         * <p> 示例值：3
         */
        private String userCount;
        /**
         * 权限组包含的员工列表
         * <p> 示例值：
         */
        private UserExternal[] users;
        /**
         * 权限组包含的访客个数
         * <p> 示例值：3
         */
        private String visitorCount;
        /**
         * 权限组包含的访客列表
         * <p> 示例值：
         */
        private UserExternal[] visitors;
        /**
         * 是否通知人员录入
         * <p> 示例值：false
         */
        private Boolean remindFace;
        /**
         * 开门时间段
         * <p> 示例值：
         */
        private OpeningTimeExternal openingTime;
        /**
         * 是否为临时权限组
         * <p> 示例值：false
         */
        private Boolean isTemp;

        /**
         * 权限组id
         * <p> 示例值：34252345234523
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 权限组名称
         * <p> 示例值：南门
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 权限组包含的设备
         * <p> 示例值：
         *
         * @param devices
         * @return
         */
        public Builder devices(DeviceExternal[] devices) {
            this.devices = devices;
            return this;
        }


        /**
         * 权限组包含的员工个数
         * <p> 示例值：3
         *
         * @param userCount
         * @return
         */
        public Builder userCount(String userCount) {
            this.userCount = userCount;
            return this;
        }


        /**
         * 权限组包含的员工列表
         * <p> 示例值：
         *
         * @param users
         * @return
         */
        public Builder users(UserExternal[] users) {
            this.users = users;
            return this;
        }


        /**
         * 权限组包含的访客个数
         * <p> 示例值：3
         *
         * @param visitorCount
         * @return
         */
        public Builder visitorCount(String visitorCount) {
            this.visitorCount = visitorCount;
            return this;
        }


        /**
         * 权限组包含的访客列表
         * <p> 示例值：
         *
         * @param visitors
         * @return
         */
        public Builder visitors(UserExternal[] visitors) {
            this.visitors = visitors;
            return this;
        }


        /**
         * 是否通知人员录入
         * <p> 示例值：false
         *
         * @param remindFace
         * @return
         */
        public Builder remindFace(Boolean remindFace) {
            this.remindFace = remindFace;
            return this;
        }


        /**
         * 开门时间段
         * <p> 示例值：
         *
         * @param openingTime
         * @return
         */
        public Builder openingTime(OpeningTimeExternal openingTime) {
            this.openingTime = openingTime;
            return this;
        }


        /**
         * 是否为临时权限组
         * <p> 示例值：false
         *
         * @param isTemp
         * @return
         */
        public Builder isTemp(Boolean isTemp) {
            this.isTemp = isTemp;
            return this;
        }


        public Rule build() {
            return new Rule(this);
        }
    }
}
