// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.google.gson.annotations.SerializedName;

public class AppAbilityWeb {
    /**
     * 是否开启网页应用能力
     * <p> 示例值：true
     */
    @SerializedName("enable")
    private Boolean enable;
    /**
     * PC端链接
     * <p> 示例值：https://open.feishu.cn/
     */
    @SerializedName("pc_url")
    private String pcUrl;
    /**
     * PC端新页面打开方式
     * <p> 示例值：new_tab
     */
    @SerializedName("pc_new_page_open_mode")
    private String pcNewPageOpenMode;
    /**
     * 移动端链接
     * <p> 示例值：https://open.feishu.cn/
     */
    @SerializedName("mobile_url")
    private String mobileUrl;

    // builder 开始
    public AppAbilityWeb() {
    }

    public AppAbilityWeb(Builder builder) {
        /**
         * 是否开启网页应用能力
         * <p> 示例值：true
         */
        this.enable = builder.enable;
        /**
         * PC端链接
         * <p> 示例值：https://open.feishu.cn/
         */
        this.pcUrl = builder.pcUrl;
        /**
         * PC端新页面打开方式
         * <p> 示例值：new_tab
         */
        this.pcNewPageOpenMode = builder.pcNewPageOpenMode;
        /**
         * 移动端链接
         * <p> 示例值：https://open.feishu.cn/
         */
        this.mobileUrl = builder.mobileUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getPcUrl() {
        return this.pcUrl;
    }

    public void setPcUrl(String pcUrl) {
        this.pcUrl = pcUrl;
    }

    public String getPcNewPageOpenMode() {
        return this.pcNewPageOpenMode;
    }

    public void setPcNewPageOpenMode(String pcNewPageOpenMode) {
        this.pcNewPageOpenMode = pcNewPageOpenMode;
    }

    public String getMobileUrl() {
        return this.mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public static class Builder {
        /**
         * 是否开启网页应用能力
         * <p> 示例值：true
         */
        private Boolean enable;
        /**
         * PC端链接
         * <p> 示例值：https://open.feishu.cn/
         */
        private String pcUrl;
        /**
         * PC端新页面打开方式
         * <p> 示例值：new_tab
         */
        private String pcNewPageOpenMode;
        /**
         * 移动端链接
         * <p> 示例值：https://open.feishu.cn/
         */
        private String mobileUrl;

        /**
         * 是否开启网页应用能力
         * <p> 示例值：true
         *
         * @param enable
         * @return
         */
        public Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }


        /**
         * PC端链接
         * <p> 示例值：https://open.feishu.cn/
         *
         * @param pcUrl
         * @return
         */
        public Builder pcUrl(String pcUrl) {
            this.pcUrl = pcUrl;
            return this;
        }


        /**
         * PC端新页面打开方式
         * <p> 示例值：new_tab
         *
         * @param pcNewPageOpenMode
         * @return
         */
        public Builder pcNewPageOpenMode(String pcNewPageOpenMode) {
            this.pcNewPageOpenMode = pcNewPageOpenMode;
            return this;
        }

        /**
         * PC端新页面打开方式
         * <p> 示例值：new_tab
         *
         * @param pcNewPageOpenMode {@link com.lark.oapi.service.application.v6.enums.AppAbilityWebPcNewPageOpenModeEnum}
         * @return
         */
        public Builder pcNewPageOpenMode(com.lark.oapi.service.application.v6.enums.AppAbilityWebPcNewPageOpenModeEnum pcNewPageOpenMode) {
            this.pcNewPageOpenMode = pcNewPageOpenMode.getValue();
            return this;
        }


        /**
         * 移动端链接
         * <p> 示例值：https://open.feishu.cn/
         *
         * @param mobileUrl
         * @return
         */
        public Builder mobileUrl(String mobileUrl) {
            this.mobileUrl = mobileUrl;
            return this;
        }


        public AppAbilityWeb build() {
            return new AppAbilityWeb(this);
        }
    }
}
