// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.google.gson.annotations.SerializedName;

public class CloudDoc {
    /**
     * 云空间重定向 url
     * <p> 示例值：https://www.example.com
     */
    @SerializedName("space_url")
    private String spaceUrl;
    /**
     * 国际化信息
     * <p> 示例值：
     */
    @SerializedName("i18n")
    private CloudDocI18nInfo[] i18n;
    /**
     * 图标链接
     * <p> 示例值：https://www.example.com
     */
    @SerializedName("icon_url")
    private String iconUrl;
    /**
     * 云文档支持模式
     * <p> 示例值：1
     */
    @SerializedName("mode")
    private Integer mode;

    // builder 开始
    public CloudDoc() {
    }

    public CloudDoc(Builder builder) {
        /**
         * 云空间重定向 url
         * <p> 示例值：https://www.example.com
         */
        this.spaceUrl = builder.spaceUrl;
        /**
         * 国际化信息
         * <p> 示例值：
         */
        this.i18n = builder.i18n;
        /**
         * 图标链接
         * <p> 示例值：https://www.example.com
         */
        this.iconUrl = builder.iconUrl;
        /**
         * 云文档支持模式
         * <p> 示例值：1
         */
        this.mode = builder.mode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    public void setSpaceUrl(String spaceUrl) {
        this.spaceUrl = spaceUrl;
    }

    public CloudDocI18nInfo[] getI18n() {
        return this.i18n;
    }

    public void setI18n(CloudDocI18nInfo[] i18n) {
        this.i18n = i18n;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public static class Builder {
        /**
         * 云空间重定向 url
         * <p> 示例值：https://www.example.com
         */
        private String spaceUrl;
        /**
         * 国际化信息
         * <p> 示例值：
         */
        private CloudDocI18nInfo[] i18n;
        /**
         * 图标链接
         * <p> 示例值：https://www.example.com
         */
        private String iconUrl;
        /**
         * 云文档支持模式
         * <p> 示例值：1
         */
        private Integer mode;

        /**
         * 云空间重定向 url
         * <p> 示例值：https://www.example.com
         *
         * @param spaceUrl
         * @return
         */
        public Builder spaceUrl(String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }


        /**
         * 国际化信息
         * <p> 示例值：
         *
         * @param i18n
         * @return
         */
        public Builder i18n(CloudDocI18nInfo[] i18n) {
            this.i18n = i18n;
            return this;
        }


        /**
         * 图标链接
         * <p> 示例值：https://www.example.com
         *
         * @param iconUrl
         * @return
         */
        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }


        /**
         * 云文档支持模式
         * <p> 示例值：1
         *
         * @param mode
         * @return
         */
        public Builder mode(Integer mode) {
            this.mode = mode;
            return this;
        }

        /**
         * 云文档支持模式
         * <p> 示例值：1
         *
         * @param mode {@link com.lark.oapi.service.application.v6.enums.CloudDocCloudDocSupportModeEnum}
         * @return
         */
        public Builder mode(com.lark.oapi.service.application.v6.enums.CloudDocCloudDocSupportModeEnum mode) {
            this.mode = mode.getValue();
            return this;
        }


        public CloudDoc build() {
            return new CloudDoc(this);
        }
    }
}
