// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.google.gson.annotations.SerializedName;

public class TableCell {
    /**
     * 行下标，从 1 开始
     * <p> 示例值：1
     */
    @SerializedName("row_index")
    private Integer rowIndex;
    /**
     * 列下标，从 1 开始
     * <p> 示例值：1
     */
    @SerializedName("col_index")
    private Integer colIndex;
    /**
     * 单元格合并信息
     * <p> 示例值：
     */
    @SerializedName("merge_info")
    private TableCellMergeInfo mergeInfo;
    /**
     * 单元格包含的子节点 id
     * <p> 示例值：
     */
    @SerializedName("children")
    private String[] children;
    /**
     * 单元格内文字
     * <p> 示例值：
     */
    @SerializedName("text")
    private Text text;

    // builder 开始
    public TableCell() {
    }

    public TableCell(Builder builder) {
        /**
         * 行下标，从 1 开始
         * <p> 示例值：1
         */
        this.rowIndex = builder.rowIndex;
        /**
         * 列下标，从 1 开始
         * <p> 示例值：1
         */
        this.colIndex = builder.colIndex;
        /**
         * 单元格合并信息
         * <p> 示例值：
         */
        this.mergeInfo = builder.mergeInfo;
        /**
         * 单元格包含的子节点 id
         * <p> 示例值：
         */
        this.children = builder.children;
        /**
         * 单元格内文字
         * <p> 示例值：
         */
        this.text = builder.text;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Integer getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(Integer colIndex) {
        this.colIndex = colIndex;
    }

    public TableCellMergeInfo getMergeInfo() {
        return this.mergeInfo;
    }

    public void setMergeInfo(TableCellMergeInfo mergeInfo) {
        this.mergeInfo = mergeInfo;
    }

    public String[] getChildren() {
        return this.children;
    }

    public void setChildren(String[] children) {
        this.children = children;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public static class Builder {
        /**
         * 行下标，从 1 开始
         * <p> 示例值：1
         */
        private Integer rowIndex;
        /**
         * 列下标，从 1 开始
         * <p> 示例值：1
         */
        private Integer colIndex;
        /**
         * 单元格合并信息
         * <p> 示例值：
         */
        private TableCellMergeInfo mergeInfo;
        /**
         * 单元格包含的子节点 id
         * <p> 示例值：
         */
        private String[] children;
        /**
         * 单元格内文字
         * <p> 示例值：
         */
        private Text text;

        /**
         * 行下标，从 1 开始
         * <p> 示例值：1
         *
         * @param rowIndex
         * @return
         */
        public Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }


        /**
         * 列下标，从 1 开始
         * <p> 示例值：1
         *
         * @param colIndex
         * @return
         */
        public Builder colIndex(Integer colIndex) {
            this.colIndex = colIndex;
            return this;
        }


        /**
         * 单元格合并信息
         * <p> 示例值：
         *
         * @param mergeInfo
         * @return
         */
        public Builder mergeInfo(TableCellMergeInfo mergeInfo) {
            this.mergeInfo = mergeInfo;
            return this;
        }


        /**
         * 单元格包含的子节点 id
         * <p> 示例值：
         *
         * @param children
         * @return
         */
        public Builder children(String[] children) {
            this.children = children;
            return this;
        }


        /**
         * 单元格内文字
         * <p> 示例值：
         *
         * @param text
         * @return
         */
        public Builder text(Text text) {
            this.text = text;
            return this;
        }


        public TableCell build() {
            return new TableCell(this);
        }
    }
}
