// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class ProfileSettingEmpContractRecord {
    /**
     * 合同协议编号
     * <p> 示例值：6919737965274990093
     */
    @SerializedName("contract_number")
    private String contractNumber;
    /**
     * 合同类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "contract_type"
     * <p> 示例值：labor_contract
     */
    @SerializedName("contract_type")
    private String contractType;
    /**
     * 甲方公司 ID, 引用Company的ID，详细信息可通过【查询单个公司】接口查询获得
     * <p> 示例值：6892686614112241165
     */
    @SerializedName("first_party")
    private String firstParty;
    /**
     * 合同开始日期
     * <p> 示例值：2006-01-02
     */
    @SerializedName("effective_time")
    private String effectiveTime;
    /**
     * 期限类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "duration_type"
     * <p> 示例值：fixed_term
     */
    @SerializedName("duration_type")
    private String durationType;
    /**
     * 合同结束日期
     * <p> 示例值：2050-01-01
     */
    @SerializedName("contract_end_date")
    private String contractEndDate;

    // builder 开始
    public ProfileSettingEmpContractRecord() {
    }

    public ProfileSettingEmpContractRecord(Builder builder) {
        /**
         * 合同协议编号
         * <p> 示例值：6919737965274990093
         */
        this.contractNumber = builder.contractNumber;
        /**
         * 合同类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "contract_type"
         * <p> 示例值：labor_contract
         */
        this.contractType = builder.contractType;
        /**
         * 甲方公司 ID, 引用Company的ID，详细信息可通过【查询单个公司】接口查询获得
         * <p> 示例值：6892686614112241165
         */
        this.firstParty = builder.firstParty;
        /**
         * 合同开始日期
         * <p> 示例值：2006-01-02
         */
        this.effectiveTime = builder.effectiveTime;
        /**
         * 期限类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "duration_type"
         * <p> 示例值：fixed_term
         */
        this.durationType = builder.durationType;
        /**
         * 合同结束日期
         * <p> 示例值：2050-01-01
         */
        this.contractEndDate = builder.contractEndDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    public String getContractType() {
        return this.contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getFirstParty() {
        return this.firstParty;
    }

    public void setFirstParty(String firstParty) {
        this.firstParty = firstParty;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getDurationType() {
        return this.durationType;
    }

    public void setDurationType(String durationType) {
        this.durationType = durationType;
    }

    public String getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(String contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public static class Builder {
        /**
         * 合同协议编号
         * <p> 示例值：6919737965274990093
         */
        private String contractNumber;
        /**
         * 合同类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "contract_type"
         * <p> 示例值：labor_contract
         */
        private String contractType;
        /**
         * 甲方公司 ID, 引用Company的ID，详细信息可通过【查询单个公司】接口查询获得
         * <p> 示例值：6892686614112241165
         */
        private String firstParty;
        /**
         * 合同开始日期
         * <p> 示例值：2006-01-02
         */
        private String effectiveTime;
        /**
         * 期限类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "duration_type"
         * <p> 示例值：fixed_term
         */
        private String durationType;
        /**
         * 合同结束日期
         * <p> 示例值：2050-01-01
         */
        private String contractEndDate;

        /**
         * 合同协议编号
         * <p> 示例值：6919737965274990093
         *
         * @param contractNumber
         * @return
         */
        public Builder contractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
            return this;
        }


        /**
         * 合同类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "contract_type"
         * <p> 示例值：labor_contract
         *
         * @param contractType
         * @return
         */
        public Builder contractType(String contractType) {
            this.contractType = contractType;
            return this;
        }


        /**
         * 甲方公司 ID, 引用Company的ID，详细信息可通过【查询单个公司】接口查询获得
         * <p> 示例值：6892686614112241165
         *
         * @param firstParty
         * @return
         */
        public Builder firstParty(String firstParty) {
            this.firstParty = firstParty;
            return this;
        }


        /**
         * 合同开始日期
         * <p> 示例值：2006-01-02
         *
         * @param effectiveTime
         * @return
         */
        public Builder effectiveTime(String effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }


        /**
         * 期限类型，枚举值可选项 可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "contract" custom_api_name = "duration_type"
         * <p> 示例值：fixed_term
         *
         * @param durationType
         * @return
         */
        public Builder durationType(String durationType) {
            this.durationType = durationType;
            return this;
        }


        /**
         * 合同结束日期
         * <p> 示例值：2050-01-01
         *
         * @param contractEndDate
         * @return
         */
        public Builder contractEndDate(String contractEndDate) {
            this.contractEndDate = contractEndDate;
            return this;
        }


        public ProfileSettingEmpContractRecord build() {
            return new ProfileSettingEmpContractRecord(this);
        }
    }
}
