// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class UserInfo {
    /**
     * 员工id
     * <p> 示例值：3e3cf96b
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 用户默认名
     * <p> 示例值：张三
     */
    @SerializedName("name")
    private String name;
    /**
     * 中文名
     * <p> 示例值：张三
     */
    @SerializedName("zh_name")
    private String zhName;
    /**
     * 英文名
     * <p> 示例值：zhang san
     */
    @SerializedName("en_name")
    private String enName;
    /**
     * 手机号
     * <p> 示例值：13011111111
     */
    @SerializedName("mobile")
    private String mobile;
    /**
     * 员工工号
     * <p> 示例值：1
     */
    @SerializedName("employee_no")
    private String employeeNo;
    /**
     * 邮箱
     * <p> 示例值：zhangsan@gmail.com
     */
    @SerializedName("email")
    private String email;
    /**
     * 用户是否离职
     * <p> 示例值：true
     */
    @SerializedName("is_resigned")
    private Boolean isResigned;
    /**
     * 离职时间，时间戳格式，表示从1970年1月1日开始所经过的秒数
     * <p> 示例值：1672502400
     */
    @SerializedName("resign_time")
    private String resignTime;
    /**
     * 离职日期
     * <p> 示例值：2023-01-01
     */
    @SerializedName("resign_date")
    private String resignDate;

    // builder 开始
    public UserInfo() {
    }

    public UserInfo(Builder builder) {
        /**
         * 员工id
         * <p> 示例值：3e3cf96b
         */
        this.userId = builder.userId;
        /**
         * 用户默认名
         * <p> 示例值：张三
         */
        this.name = builder.name;
        /**
         * 中文名
         * <p> 示例值：张三
         */
        this.zhName = builder.zhName;
        /**
         * 英文名
         * <p> 示例值：zhang san
         */
        this.enName = builder.enName;
        /**
         * 手机号
         * <p> 示例值：13011111111
         */
        this.mobile = builder.mobile;
        /**
         * 员工工号
         * <p> 示例值：1
         */
        this.employeeNo = builder.employeeNo;
        /**
         * 邮箱
         * <p> 示例值：zhangsan@gmail.com
         */
        this.email = builder.email;
        /**
         * 用户是否离职
         * <p> 示例值：true
         */
        this.isResigned = builder.isResigned;
        /**
         * 离职时间，时间戳格式，表示从1970年1月1日开始所经过的秒数
         * <p> 示例值：1672502400
         */
        this.resignTime = builder.resignTime;
        /**
         * 离职日期
         * <p> 示例值：2023-01-01
         */
        this.resignDate = builder.resignDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getZhName() {
        return this.zhName;
    }

    public void setZhName(String zhName) {
        this.zhName = zhName;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmployeeNo() {
        return this.employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getIsResigned() {
        return this.isResigned;
    }

    public void setIsResigned(Boolean isResigned) {
        this.isResigned = isResigned;
    }

    public String getResignTime() {
        return this.resignTime;
    }

    public void setResignTime(String resignTime) {
        this.resignTime = resignTime;
    }

    public String getResignDate() {
        return this.resignDate;
    }

    public void setResignDate(String resignDate) {
        this.resignDate = resignDate;
    }

    public static class Builder {
        /**
         * 员工id
         * <p> 示例值：3e3cf96b
         */
        private String userId;
        /**
         * 用户默认名
         * <p> 示例值：张三
         */
        private String name;
        /**
         * 中文名
         * <p> 示例值：张三
         */
        private String zhName;
        /**
         * 英文名
         * <p> 示例值：zhang san
         */
        private String enName;
        /**
         * 手机号
         * <p> 示例值：13011111111
         */
        private String mobile;
        /**
         * 员工工号
         * <p> 示例值：1
         */
        private String employeeNo;
        /**
         * 邮箱
         * <p> 示例值：zhangsan@gmail.com
         */
        private String email;
        /**
         * 用户是否离职
         * <p> 示例值：true
         */
        private Boolean isResigned;
        /**
         * 离职时间，时间戳格式，表示从1970年1月1日开始所经过的秒数
         * <p> 示例值：1672502400
         */
        private String resignTime;
        /**
         * 离职日期
         * <p> 示例值：2023-01-01
         */
        private String resignDate;

        /**
         * 员工id
         * <p> 示例值：3e3cf96b
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 用户默认名
         * <p> 示例值：张三
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 中文名
         * <p> 示例值：张三
         *
         * @param zhName
         * @return
         */
        public Builder zhName(String zhName) {
            this.zhName = zhName;
            return this;
        }


        /**
         * 英文名
         * <p> 示例值：zhang san
         *
         * @param enName
         * @return
         */
        public Builder enName(String enName) {
            this.enName = enName;
            return this;
        }


        /**
         * 手机号
         * <p> 示例值：13011111111
         *
         * @param mobile
         * @return
         */
        public Builder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }


        /**
         * 员工工号
         * <p> 示例值：1
         *
         * @param employeeNo
         * @return
         */
        public Builder employeeNo(String employeeNo) {
            this.employeeNo = employeeNo;
            return this;
        }


        /**
         * 邮箱
         * <p> 示例值：zhangsan@gmail.com
         *
         * @param email
         * @return
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }


        /**
         * 用户是否离职
         * <p> 示例值：true
         *
         * @param isResigned
         * @return
         */
        public Builder isResigned(Boolean isResigned) {
            this.isResigned = isResigned;
            return this;
        }


        /**
         * 离职时间，时间戳格式，表示从1970年1月1日开始所经过的秒数
         * <p> 示例值：1672502400
         *
         * @param resignTime
         * @return
         */
        public Builder resignTime(String resignTime) {
            this.resignTime = resignTime;
            return this;
        }


        /**
         * 离职日期
         * <p> 示例值：2023-01-01
         *
         * @param resignDate
         * @return
         */
        public Builder resignDate(String resignDate) {
            this.resignDate = resignDate;
            return this;
        }


        public UserInfo build() {
            return new UserInfo(this);
        }
    }
}
